package software.amazon.awscdk.services.lambda.nodejs;

/**
 * (experimental) Command hooks.
 * <p>
 * These commands will run in the environment in which bundling occurs: inside
 * the container for Docker bundling or on the host OS for local bundling.
 * <p>
 * Commands are chained with <code>&amp;&amp;</code>.
 * <p>
 * The following example (specified in TypeScript) copies a file from the input
 * directory to the output directory to include it in the bundled asset:
 * <p>
 * <blockquote><pre>
 * afterBundling(inputDir: string, outputDir: string): string[]{
 *    return [`cp ${inputDir}/my-binary.node ${outputDir}`];
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:05.364Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lambda_nodejs.ICommandHooks")
@software.amazon.jsii.Jsii.Proxy(ICommandHooks.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ICommandHooks extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Returns commands to run after bundling.
     * <p>
     * Commands are chained with <code>&amp;&amp;</code>.
     * <p>
     * @param inputDir This parameter is required.
     * @param outputDir This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> afterBundling(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir);

    /**
     * (experimental) Returns commands to run before bundling.
     * <p>
     * Commands are chained with <code>&amp;&amp;</code>.
     * <p>
     * @param inputDir This parameter is required.
     * @param outputDir This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> beforeBundling(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir);

    /**
     * (experimental) Returns commands to run before installing node modules.
     * <p>
     * This hook only runs when node modules are installed.
     * <p>
     * Commands are chained with <code>&amp;&amp;</code>.
     * <p>
     * @param inputDir This parameter is required.
     * @param outputDir This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> beforeInstall(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.nodejs.ICommandHooks.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Returns commands to run after bundling.
         * <p>
         * Commands are chained with <code>&amp;&amp;</code>.
         * <p>
         * @param inputDir This parameter is required.
         * @param outputDir This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> afterBundling(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "afterBundling", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(inputDir, "inputDir is required"), java.util.Objects.requireNonNull(outputDir, "outputDir is required") }));
        }

        /**
         * (experimental) Returns commands to run before bundling.
         * <p>
         * Commands are chained with <code>&amp;&amp;</code>.
         * <p>
         * @param inputDir This parameter is required.
         * @param outputDir This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> beforeBundling(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "beforeBundling", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(inputDir, "inputDir is required"), java.util.Objects.requireNonNull(outputDir, "outputDir is required") }));
        }

        /**
         * (experimental) Returns commands to run before installing node modules.
         * <p>
         * This hook only runs when node modules are installed.
         * <p>
         * Commands are chained with <code>&amp;&amp;</code>.
         * <p>
         * @param inputDir This parameter is required.
         * @param outputDir This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> beforeInstall(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "beforeInstall", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(inputDir, "inputDir is required"), java.util.Objects.requireNonNull(outputDir, "outputDir is required") }));
        }
    }

    /**
     * Internal default implementation for {@link ICommandHooks}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ICommandHooks {

        /**
         * (experimental) Returns commands to run after bundling.
         * <p>
         * Commands are chained with <code>&amp;&amp;</code>.
         * <p>
         * @param inputDir This parameter is required.
         * @param outputDir This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> afterBundling(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "afterBundling", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(inputDir, "inputDir is required"), java.util.Objects.requireNonNull(outputDir, "outputDir is required") }));
        }

        /**
         * (experimental) Returns commands to run before bundling.
         * <p>
         * Commands are chained with <code>&amp;&amp;</code>.
         * <p>
         * @param inputDir This parameter is required.
         * @param outputDir This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> beforeBundling(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "beforeBundling", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(inputDir, "inputDir is required"), java.util.Objects.requireNonNull(outputDir, "outputDir is required") }));
        }

        /**
         * (experimental) Returns commands to run before installing node modules.
         * <p>
         * This hook only runs when node modules are installed.
         * <p>
         * Commands are chained with <code>&amp;&amp;</code>.
         * <p>
         * @param inputDir This parameter is required.
         * @param outputDir This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> beforeInstall(final @org.jetbrains.annotations.NotNull java.lang.String inputDir, final @org.jetbrains.annotations.NotNull java.lang.String outputDir) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "beforeInstall", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(inputDir, "inputDir is required"), java.util.Objects.requireNonNull(outputDir, "outputDir is required") }));
        }
    }
}
