package software.amazon.awscdk.services.macie;

/**
 * A CloudFormation `AWS::Macie::FindingsFilter`.
 * <p>
 * The <code>AWS::Macie::FindingsFilter</code> resource specifies a findings filter. In Amazon Macie , a <em>findings filter</em> , also referred to as a <em>filter rule</em> , is a set of custom criteria that specifies which findings to include or exclude from the results of a query for findings. The criteria can help you identify and focus on findings that have specific characteristics, such as severity, type, or the name of an affected AWS resource. You can also configure a findings filter to suppress (automatically archive) findings that match the filter's criteria. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-filter-overview.html">Filtering findings</a> in the <em>Amazon Macie User Guide</em> .
 * <p>
 * An <code>AWS::Macie::Session</code> resource must exist for an AWS account before you can create an <code>AWS::Macie::FindingsFilter</code> resource for the account. Use a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn attribute</a> to ensure that an <code>AWS::Macie::Session</code> resource is created before other Macie resources are created for an account. For example, <code>"DependsOn": "Session"</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.macie.*;
 * CfnFindingsFilter cfnFindingsFilter = CfnFindingsFilter.Builder.create(this, "MyCfnFindingsFilter")
 *         .findingCriteria(FindingCriteriaProperty.builder()
 *                 .criterion(Map.of(
 *                         "criterionKey", CriterionAdditionalPropertiesProperty.builder()
 *                                 .eq(List.of("eq"))
 *                                 .gt(123)
 *                                 .gte(123)
 *                                 .lt(123)
 *                                 .lte(123)
 *                                 .neq(List.of("neq"))
 *                                 .build()))
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .action("action")
 *         .description("description")
 *         .position(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.041Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_macie.CfnFindingsFilter")
public class CfnFindingsFilter extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnFindingsFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFindingsFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.macie.CfnFindingsFilter.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Macie::FindingsFilter`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFindingsFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.macie.CfnFindingsFilterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the findings filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An array of `FindingsFilterListItem` objects, one for each findings filter that's associated with the account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrFindingsFilterListItems() {
        return software.amazon.jsii.Kernel.get(this, "attrFindingsFilterListItems", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     * The unique identifier for the findings filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The criteria to use to filter findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFindingCriteria() {
        return software.amazon.jsii.Kernel.get(this, "findingCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The criteria to use to filter findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFindingCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.macie.CfnFindingsFilter.FindingCriteriaProperty value) {
        software.amazon.jsii.Kernel.set(this, "findingCriteria", java.util.Objects.requireNonNull(value, "findingCriteria is required"));
    }

    /**
     * The criteria to use to filter findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFindingCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "findingCriteria", java.util.Objects.requireNonNull(value, "findingCriteria is required"));
    }

    /**
     * A custom name for the findings filter. The name can contain 3-64 characters.
     * <p>
     * Avoid including sensitive data in the name. Users of the account might be able to see the name, depending on the actions that they're allowed to perform in Amazon Macie .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom name for the findings filter. The name can contain 3-64 characters.
     * <p>
     * Avoid including sensitive data in the name. Users of the account might be able to see the name, depending on the actions that they're allowed to perform in Amazon Macie .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The action to perform on findings that match the filter criteria ( `FindingCriteria` ). Valid values are:.
     * <p>
     * <ul>
     * <li><code>ARCHIVE</code> - Suppress (automatically archive) the findings.</li>
     * <li><code>NOOP</code> - Don't perform any action on the findings.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAction() {
        return software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The action to perform on findings that match the filter criteria ( `FindingCriteria` ). Valid values are:.
     * <p>
     * <ul>
     * <li><code>ARCHIVE</code> - Suppress (automatically archive) the findings.</li>
     * <li><code>NOOP</code> - Don't perform any action on the findings.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAction(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "action", value);
    }

    /**
     * A custom description of the findings filter. The description can contain 1-512 characters.
     * <p>
     * Avoid including sensitive data in the description. Users of the account might be able to see the description, depending on the actions that they're allowed to perform in Amazon Macie .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom description of the findings filter. The description can contain 1-512 characters.
     * <p>
     * Avoid including sensitive data in the description. Users of the account might be able to see the description, depending on the actions that they're allowed to perform in Amazon Macie .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The position of the findings filter in the list of saved filters on the Amazon Macie console.
     * <p>
     * This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPosition() {
        return software.amazon.jsii.Kernel.get(this, "position", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The position of the findings filter in the list of saved filters on the Amazon Macie console.
     * <p>
     * This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPosition(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "position", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.macie.*;
     * CriterionAdditionalPropertiesProperty criterionAdditionalPropertiesProperty = CriterionAdditionalPropertiesProperty.builder()
     *         .eq(List.of("eq"))
     *         .gt(123)
     *         .gte(123)
     *         .lt(123)
     *         .lte(123)
     *         .neq(List.of("neq"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_macie.CfnFindingsFilter.CriterionAdditionalPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CriterionAdditionalPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CriterionAdditionalPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.eq`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEq() {
            return null;
        }

        /**
         * `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.gt`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGt() {
            return null;
        }

        /**
         * `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.gte`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGte() {
            return null;
        }

        /**
         * `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.lt`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLt() {
            return null;
        }

        /**
         * `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.lte`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLte() {
            return null;
        }

        /**
         * `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.neq`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNeq() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CriterionAdditionalPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CriterionAdditionalPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CriterionAdditionalPropertiesProperty> {
            java.util.List<java.lang.String> eq;
            java.lang.Number gt;
            java.lang.Number gte;
            java.lang.Number lt;
            java.lang.Number lte;
            java.util.List<java.lang.String> neq;

            /**
             * Sets the value of {@link CriterionAdditionalPropertiesProperty#getEq}
             * @param eq `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.eq`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eq(java.util.List<java.lang.String> eq) {
                this.eq = eq;
                return this;
            }

            /**
             * Sets the value of {@link CriterionAdditionalPropertiesProperty#getGt}
             * @param gt `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.gt`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gt(java.lang.Number gt) {
                this.gt = gt;
                return this;
            }

            /**
             * Sets the value of {@link CriterionAdditionalPropertiesProperty#getGte}
             * @param gte `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.gte`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gte(java.lang.Number gte) {
                this.gte = gte;
                return this;
            }

            /**
             * Sets the value of {@link CriterionAdditionalPropertiesProperty#getLt}
             * @param lt `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.lt`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lt(java.lang.Number lt) {
                this.lt = lt;
                return this;
            }

            /**
             * Sets the value of {@link CriterionAdditionalPropertiesProperty#getLte}
             * @param lte `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.lte`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lte(java.lang.Number lte) {
                this.lte = lte;
                return this;
            }

            /**
             * Sets the value of {@link CriterionAdditionalPropertiesProperty#getNeq}
             * @param neq `CfnFindingsFilter.CriterionAdditionalPropertiesProperty.neq`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder neq(java.util.List<java.lang.String> neq) {
                this.neq = neq;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CriterionAdditionalPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CriterionAdditionalPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CriterionAdditionalPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CriterionAdditionalPropertiesProperty {
            private final java.util.List<java.lang.String> eq;
            private final java.lang.Number gt;
            private final java.lang.Number gte;
            private final java.lang.Number lt;
            private final java.lang.Number lte;
            private final java.util.List<java.lang.String> neq;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eq = software.amazon.jsii.Kernel.get(this, "eq", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.gt = software.amazon.jsii.Kernel.get(this, "gt", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gte = software.amazon.jsii.Kernel.get(this, "gte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lt = software.amazon.jsii.Kernel.get(this, "lt", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lte = software.amazon.jsii.Kernel.get(this, "lte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.neq = software.amazon.jsii.Kernel.get(this, "neq", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eq = builder.eq;
                this.gt = builder.gt;
                this.gte = builder.gte;
                this.lt = builder.lt;
                this.lte = builder.lte;
                this.neq = builder.neq;
            }

            @Override
            public final java.util.List<java.lang.String> getEq() {
                return this.eq;
            }

            @Override
            public final java.lang.Number getGt() {
                return this.gt;
            }

            @Override
            public final java.lang.Number getGte() {
                return this.gte;
            }

            @Override
            public final java.lang.Number getLt() {
                return this.lt;
            }

            @Override
            public final java.lang.Number getLte() {
                return this.lte;
            }

            @Override
            public final java.util.List<java.lang.String> getNeq() {
                return this.neq;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEq() != null) {
                    data.set("eq", om.valueToTree(this.getEq()));
                }
                if (this.getGt() != null) {
                    data.set("gt", om.valueToTree(this.getGt()));
                }
                if (this.getGte() != null) {
                    data.set("gte", om.valueToTree(this.getGte()));
                }
                if (this.getLt() != null) {
                    data.set("lt", om.valueToTree(this.getLt()));
                }
                if (this.getLte() != null) {
                    data.set("lte", om.valueToTree(this.getLte()));
                }
                if (this.getNeq() != null) {
                    data.set("neq", om.valueToTree(this.getNeq()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_macie.CfnFindingsFilter.CriterionAdditionalPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CriterionAdditionalPropertiesProperty.Jsii$Proxy that = (CriterionAdditionalPropertiesProperty.Jsii$Proxy) o;

                if (this.eq != null ? !this.eq.equals(that.eq) : that.eq != null) return false;
                if (this.gt != null ? !this.gt.equals(that.gt) : that.gt != null) return false;
                if (this.gte != null ? !this.gte.equals(that.gte) : that.gte != null) return false;
                if (this.lt != null ? !this.lt.equals(that.lt) : that.lt != null) return false;
                if (this.lte != null ? !this.lte.equals(that.lte) : that.lte != null) return false;
                return this.neq != null ? this.neq.equals(that.neq) : that.neq == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eq != null ? this.eq.hashCode() : 0;
                result = 31 * result + (this.gt != null ? this.gt.hashCode() : 0);
                result = 31 * result + (this.gte != null ? this.gte.hashCode() : 0);
                result = 31 * result + (this.lt != null ? this.lt.hashCode() : 0);
                result = 31 * result + (this.lte != null ? this.lte.hashCode() : 0);
                result = 31 * result + (this.neq != null ? this.neq.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies, as a map, one or more property-based conditions that filter the results of a query for findings.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-filter-overview.html">Filtering findings</a> in the <em>Amazon Macie User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.macie.*;
     * FindingCriteriaProperty findingCriteriaProperty = FindingCriteriaProperty.builder()
     *         .criterion(Map.of(
     *                 "criterionKey", CriterionAdditionalPropertiesProperty.builder()
     *                         .eq(List.of("eq"))
     *                         .gt(123)
     *                         .gte(123)
     *                         .lt(123)
     *                         .lte(123)
     *                         .neq(List.of("neq"))
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_macie.CfnFindingsFilter.FindingCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(FindingCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FindingCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a condition that defines the property, operator, and one or more values to use to filter the results.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCriterion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FindingCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FindingCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FindingCriteriaProperty> {
            java.lang.Object criterion;

            /**
             * Sets the value of {@link FindingCriteriaProperty#getCriterion}
             * @param criterion Specifies a condition that defines the property, operator, and one or more values to use to filter the results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criterion(software.amazon.awscdk.core.IResolvable criterion) {
                this.criterion = criterion;
                return this;
            }

            /**
             * Sets the value of {@link FindingCriteriaProperty#getCriterion}
             * @param criterion Specifies a condition that defines the property, operator, and one or more values to use to filter the results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criterion(java.util.Map<java.lang.String, ? extends java.lang.Object> criterion) {
                this.criterion = criterion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FindingCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FindingCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FindingCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FindingCriteriaProperty {
            private final java.lang.Object criterion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.criterion = software.amazon.jsii.Kernel.get(this, "criterion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.criterion = builder.criterion;
            }

            @Override
            public final java.lang.Object getCriterion() {
                return this.criterion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCriterion() != null) {
                    data.set("criterion", om.valueToTree(this.getCriterion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_macie.CfnFindingsFilter.FindingCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FindingCriteriaProperty.Jsii$Proxy that = (FindingCriteriaProperty.Jsii$Proxy) o;

                return this.criterion != null ? this.criterion.equals(that.criterion) : that.criterion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.criterion != null ? this.criterion.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the unique identifier and custom name of a findings filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.macie.*;
     * FindingsFilterListItemProperty findingsFilterListItemProperty = FindingsFilterListItemProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_macie.CfnFindingsFilter.FindingsFilterListItemProperty")
    @software.amazon.jsii.Jsii.Proxy(FindingsFilterListItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FindingsFilterListItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier for the findings filter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The custom name of the findings filter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FindingsFilterListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FindingsFilterListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FindingsFilterListItemProperty> {
            java.lang.String id;
            java.lang.String name;

            /**
             * Sets the value of {@link FindingsFilterListItemProperty#getId}
             * @param id The unique identifier for the findings filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link FindingsFilterListItemProperty#getName}
             * @param name The custom name of the findings filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FindingsFilterListItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FindingsFilterListItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FindingsFilterListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FindingsFilterListItemProperty {
            private final java.lang.String id;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = builder.id;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_macie.CfnFindingsFilter.FindingsFilterListItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FindingsFilterListItemProperty.Jsii$Proxy that = (FindingsFilterListItemProperty.Jsii$Proxy) o;

                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id != null ? this.id.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.macie.CfnFindingsFilter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.macie.CfnFindingsFilter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.macie.CfnFindingsFilterProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.macie.CfnFindingsFilterProps.Builder();
        }

        /**
         * The criteria to use to filter findings.
         * <p>
         * @return {@code this}
         * @param findingCriteria The criteria to use to filter findings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder findingCriteria(final software.amazon.awscdk.services.macie.CfnFindingsFilter.FindingCriteriaProperty findingCriteria) {
            this.props.findingCriteria(findingCriteria);
            return this;
        }
        /**
         * The criteria to use to filter findings.
         * <p>
         * @return {@code this}
         * @param findingCriteria The criteria to use to filter findings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder findingCriteria(final software.amazon.awscdk.core.IResolvable findingCriteria) {
            this.props.findingCriteria(findingCriteria);
            return this;
        }

        /**
         * A custom name for the findings filter. The name can contain 3-64 characters.
         * <p>
         * Avoid including sensitive data in the name. Users of the account might be able to see the name, depending on the actions that they're allowed to perform in Amazon Macie .
         * <p>
         * @return {@code this}
         * @param name A custom name for the findings filter. The name can contain 3-64 characters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The action to perform on findings that match the filter criteria ( `FindingCriteria` ). Valid values are:.
         * <p>
         * <ul>
         * <li><code>ARCHIVE</code> - Suppress (automatically archive) the findings.</li>
         * <li><code>NOOP</code> - Don't perform any action on the findings.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param action The action to perform on findings that match the filter criteria ( `FindingCriteria` ). Valid values are:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(final java.lang.String action) {
            this.props.action(action);
            return this;
        }

        /**
         * A custom description of the findings filter. The description can contain 1-512 characters.
         * <p>
         * Avoid including sensitive data in the description. Users of the account might be able to see the description, depending on the actions that they're allowed to perform in Amazon Macie .
         * <p>
         * @return {@code this}
         * @param description A custom description of the findings filter. The description can contain 1-512 characters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The position of the findings filter in the list of saved filters on the Amazon Macie console.
         * <p>
         * This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to findings.
         * <p>
         * @return {@code this}
         * @param position The position of the findings filter in the list of saved filters on the Amazon Macie console. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder position(final java.lang.Number position) {
            this.props.position(position);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.macie.CfnFindingsFilter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.macie.CfnFindingsFilter build() {
            return new software.amazon.awscdk.services.macie.CfnFindingsFilter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
