package software.amazon.awscdk.services.msk;

/**
 * (experimental) Properties for a MSK Cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.sasl(SaslAuthProps.builder()
 *                 .scram(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.803Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_msk.ClusterProps")
@software.amazon.jsii.Jsii.Proxy(ClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The physical name of the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * (experimental) The version of Apache Kafka.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.KafkaVersion getKafkaVersion();

    /**
     * (experimental) Defines the virtual networking environment for this cluster.
     * <p>
     * Must have at least 2 subnets in two different AZs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * (experimental) Configuration properties for client authentication.
     * <p>
     * MSK supports using private TLS certificates or SASL/SCRAM to authenticate the identity of clients.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.ClientAuthentication getClientAuthentication() {
        return null;
    }

    /**
     * (experimental) The Amazon MSK configuration to use for the cluster.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.ClusterConfigurationInfo getConfigurationInfo() {
        return null;
    }

    /**
     * (experimental) Information about storage volumes attached to MSK broker nodes.
     * <p>
     * Default: - 1000 GiB EBS volume
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.EbsStorageInfo getEbsStorageInfo() {
        return null;
    }

    /**
     * (experimental) Config details for encryption in transit.
     * <p>
     * Default: - enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.EncryptionInTransitConfig getEncryptionInTransit() {
        return null;
    }

    /**
     * (experimental) The EC2 instance type that you want Amazon MSK to use when it creates your brokers.
     * <p>
     * Default: kafka.m5.large
     * <p>
     * @see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html#broker-instance-types">https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html#broker-instance-types</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * (experimental) Configure your MSK cluster to send broker logs to different destination types.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.BrokerLogging getLogging() {
        return null;
    }

    /**
     * (experimental) Cluster monitoring configuration.
     * <p>
     * Default: - DEFAULT monitoring level
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.MonitoringConfiguration getMonitoring() {
        return null;
    }

    /**
     * (experimental) Number of Apache Kafka brokers deployed in each Availability Zone.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfBrokerNodes() {
        return null;
    }

    /**
     * (experimental) What to do when this resource is deleted from a stack.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster.
     * <p>
     * Default: - create new security group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * (experimental) Where to place the nodes within the VPC.
     * <p>
     * Amazon MSK distributes the broker nodes evenly across the subnets that you specify.
     * The subnets that you specify must be in distinct Availability Zones.
     * Client subnets can't be in Availability Zone us-east-1e.
     * <p>
     * Default: - the Vpc default strategy if not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterProps> {
        java.lang.String clusterName;
        software.amazon.awscdk.services.msk.KafkaVersion kafkaVersion;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.msk.ClientAuthentication clientAuthentication;
        software.amazon.awscdk.services.msk.ClusterConfigurationInfo configurationInfo;
        software.amazon.awscdk.services.msk.EbsStorageInfo ebsStorageInfo;
        software.amazon.awscdk.services.msk.EncryptionInTransitConfig encryptionInTransit;
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.services.msk.BrokerLogging logging;
        software.amazon.awscdk.services.msk.MonitoringConfiguration monitoring;
        java.lang.Number numberOfBrokerNodes;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link ClusterProps#getClusterName}
         * @param clusterName The physical name of the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getKafkaVersion}
         * @param kafkaVersion The version of Apache Kafka. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kafkaVersion(software.amazon.awscdk.services.msk.KafkaVersion kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getVpc}
         * @param vpc Defines the virtual networking environment for this cluster. This parameter is required.
         *            Must have at least 2 subnets in two different AZs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getClientAuthentication}
         * @param clientAuthentication Configuration properties for client authentication.
         *                             MSK supports using private TLS certificates or SASL/SCRAM to authenticate the identity of clients.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientAuthentication(software.amazon.awscdk.services.msk.ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getConfigurationInfo}
         * @param configurationInfo The Amazon MSK configuration to use for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurationInfo(software.amazon.awscdk.services.msk.ClusterConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getEbsStorageInfo}
         * @param ebsStorageInfo Information about storage volumes attached to MSK broker nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ebsStorageInfo(software.amazon.awscdk.services.msk.EbsStorageInfo ebsStorageInfo) {
            this.ebsStorageInfo = ebsStorageInfo;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getEncryptionInTransit}
         * @param encryptionInTransit Config details for encryption in transit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionInTransit(software.amazon.awscdk.services.msk.EncryptionInTransitConfig encryptionInTransit) {
            this.encryptionInTransit = encryptionInTransit;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getInstanceType}
         * @param instanceType The EC2 instance type that you want Amazon MSK to use when it creates your brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getLogging}
         * @param logging Configure your MSK cluster to send broker logs to different destination types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logging(software.amazon.awscdk.services.msk.BrokerLogging logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getMonitoring}
         * @param monitoring Cluster monitoring configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder monitoring(software.amazon.awscdk.services.msk.MonitoringConfiguration monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getNumberOfBrokerNodes}
         * @param numberOfBrokerNodes Number of Apache Kafka brokers deployed in each Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder numberOfBrokerNodes(java.lang.Number numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getRemovalPolicy}
         * @param removalPolicy What to do when this resource is deleted from a stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getSecurityGroups}
         * @param securityGroups The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getVpcSubnets}
         * @param vpcSubnets Where to place the nodes within the VPC.
         *                   Amazon MSK distributes the broker nodes evenly across the subnets that you specify.
         *                   The subnets that you specify must be in distinct Availability Zones.
         *                   Client subnets can't be in Availability Zone us-east-1e.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterProps {
        private final java.lang.String clusterName;
        private final software.amazon.awscdk.services.msk.KafkaVersion kafkaVersion;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.msk.ClientAuthentication clientAuthentication;
        private final software.amazon.awscdk.services.msk.ClusterConfigurationInfo configurationInfo;
        private final software.amazon.awscdk.services.msk.EbsStorageInfo ebsStorageInfo;
        private final software.amazon.awscdk.services.msk.EncryptionInTransitConfig encryptionInTransit;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.msk.BrokerLogging logging;
        private final software.amazon.awscdk.services.msk.MonitoringConfiguration monitoring;
        private final java.lang.Number numberOfBrokerNodes;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kafkaVersion = software.amazon.jsii.Kernel.get(this, "kafkaVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.KafkaVersion.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.clientAuthentication = software.amazon.jsii.Kernel.get(this, "clientAuthentication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.ClientAuthentication.class));
            this.configurationInfo = software.amazon.jsii.Kernel.get(this, "configurationInfo", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.ClusterConfigurationInfo.class));
            this.ebsStorageInfo = software.amazon.jsii.Kernel.get(this, "ebsStorageInfo", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.EbsStorageInfo.class));
            this.encryptionInTransit = software.amazon.jsii.Kernel.get(this, "encryptionInTransit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.EncryptionInTransitConfig.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.BrokerLogging.class));
            this.monitoring = software.amazon.jsii.Kernel.get(this, "monitoring", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.MonitoringConfiguration.class));
            this.numberOfBrokerNodes = software.amazon.jsii.Kernel.get(this, "numberOfBrokerNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.kafkaVersion = java.util.Objects.requireNonNull(builder.kafkaVersion, "kafkaVersion is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.clientAuthentication = builder.clientAuthentication;
            this.configurationInfo = builder.configurationInfo;
            this.ebsStorageInfo = builder.ebsStorageInfo;
            this.encryptionInTransit = builder.encryptionInTransit;
            this.instanceType = builder.instanceType;
            this.logging = builder.logging;
            this.monitoring = builder.monitoring;
            this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
            this.removalPolicy = builder.removalPolicy;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final software.amazon.awscdk.services.msk.KafkaVersion getKafkaVersion() {
            return this.kafkaVersion;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.msk.ClientAuthentication getClientAuthentication() {
            return this.clientAuthentication;
        }

        @Override
        public final software.amazon.awscdk.services.msk.ClusterConfigurationInfo getConfigurationInfo() {
            return this.configurationInfo;
        }

        @Override
        public final software.amazon.awscdk.services.msk.EbsStorageInfo getEbsStorageInfo() {
            return this.ebsStorageInfo;
        }

        @Override
        public final software.amazon.awscdk.services.msk.EncryptionInTransitConfig getEncryptionInTransit() {
            return this.encryptionInTransit;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.msk.BrokerLogging getLogging() {
            return this.logging;
        }

        @Override
        public final software.amazon.awscdk.services.msk.MonitoringConfiguration getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final java.lang.Number getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("kafkaVersion", om.valueToTree(this.getKafkaVersion()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getClientAuthentication() != null) {
                data.set("clientAuthentication", om.valueToTree(this.getClientAuthentication()));
            }
            if (this.getConfigurationInfo() != null) {
                data.set("configurationInfo", om.valueToTree(this.getConfigurationInfo()));
            }
            if (this.getEbsStorageInfo() != null) {
                data.set("ebsStorageInfo", om.valueToTree(this.getEbsStorageInfo()));
            }
            if (this.getEncryptionInTransit() != null) {
                data.set("encryptionInTransit", om.valueToTree(this.getEncryptionInTransit()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getMonitoring() != null) {
                data.set("monitoring", om.valueToTree(this.getMonitoring()));
            }
            if (this.getNumberOfBrokerNodes() != null) {
                data.set("numberOfBrokerNodes", om.valueToTree(this.getNumberOfBrokerNodes()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_msk.ClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterProps.Jsii$Proxy that = (ClusterProps.Jsii$Proxy) o;

            if (!clusterName.equals(that.clusterName)) return false;
            if (!kafkaVersion.equals(that.kafkaVersion)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.clientAuthentication != null ? !this.clientAuthentication.equals(that.clientAuthentication) : that.clientAuthentication != null) return false;
            if (this.configurationInfo != null ? !this.configurationInfo.equals(that.configurationInfo) : that.configurationInfo != null) return false;
            if (this.ebsStorageInfo != null ? !this.ebsStorageInfo.equals(that.ebsStorageInfo) : that.ebsStorageInfo != null) return false;
            if (this.encryptionInTransit != null ? !this.encryptionInTransit.equals(that.encryptionInTransit) : that.encryptionInTransit != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
            if (this.numberOfBrokerNodes != null ? !this.numberOfBrokerNodes.equals(that.numberOfBrokerNodes) : that.numberOfBrokerNodes != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName.hashCode();
            result = 31 * result + (this.kafkaVersion.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.clientAuthentication != null ? this.clientAuthentication.hashCode() : 0);
            result = 31 * result + (this.configurationInfo != null ? this.configurationInfo.hashCode() : 0);
            result = 31 * result + (this.ebsStorageInfo != null ? this.ebsStorageInfo.hashCode() : 0);
            result = 31 * result + (this.encryptionInTransit != null ? this.encryptionInTransit.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
            result = 31 * result + (this.numberOfBrokerNodes != null ? this.numberOfBrokerNodes.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
