package software.amazon.awscdk.services.msk;

/**
 * (experimental) The settings for encrypting data in transit.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.sasl(SaslAuthProps.builder()
 *                 .scram(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/msk-encryption.html#msk-encryption-in-transit">https://docs.aws.amazon.com/msk/latest/developerguide/msk-encryption.html#msk-encryption-in-transit</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.806Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_msk.EncryptionInTransitConfig")
@software.amazon.jsii.Jsii.Proxy(EncryptionInTransitConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EncryptionInTransitConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Indicates the encryption setting for data in transit between clients and brokers.
     * <p>
     * Default: - TLS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.ClientBrokerEncryption getClientBroker() {
        return null;
    }

    /**
     * (experimental) Indicates that data communication among the broker nodes of the cluster is encrypted.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableInCluster() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EncryptionInTransitConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EncryptionInTransitConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<EncryptionInTransitConfig> {
        software.amazon.awscdk.services.msk.ClientBrokerEncryption clientBroker;
        java.lang.Boolean enableInCluster;

        /**
         * Sets the value of {@link EncryptionInTransitConfig#getClientBroker}
         * @param clientBroker Indicates the encryption setting for data in transit between clients and brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientBroker(software.amazon.awscdk.services.msk.ClientBrokerEncryption clientBroker) {
            this.clientBroker = clientBroker;
            return this;
        }

        /**
         * Sets the value of {@link EncryptionInTransitConfig#getEnableInCluster}
         * @param enableInCluster Indicates that data communication among the broker nodes of the cluster is encrypted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableInCluster(java.lang.Boolean enableInCluster) {
            this.enableInCluster = enableInCluster;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EncryptionInTransitConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public EncryptionInTransitConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EncryptionInTransitConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionInTransitConfig {
        private final software.amazon.awscdk.services.msk.ClientBrokerEncryption clientBroker;
        private final java.lang.Boolean enableInCluster;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientBroker = software.amazon.jsii.Kernel.get(this, "clientBroker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.ClientBrokerEncryption.class));
            this.enableInCluster = software.amazon.jsii.Kernel.get(this, "enableInCluster", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientBroker = builder.clientBroker;
            this.enableInCluster = builder.enableInCluster;
        }

        @Override
        public final software.amazon.awscdk.services.msk.ClientBrokerEncryption getClientBroker() {
            return this.clientBroker;
        }

        @Override
        public final java.lang.Boolean getEnableInCluster() {
            return this.enableInCluster;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClientBroker() != null) {
                data.set("clientBroker", om.valueToTree(this.getClientBroker()));
            }
            if (this.getEnableInCluster() != null) {
                data.set("enableInCluster", om.valueToTree(this.getEnableInCluster()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_msk.EncryptionInTransitConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EncryptionInTransitConfig.Jsii$Proxy that = (EncryptionInTransitConfig.Jsii$Proxy) o;

            if (this.clientBroker != null ? !this.clientBroker.equals(that.clientBroker) : that.clientBroker != null) return false;
            return this.enableInCluster != null ? this.enableInCluster.equals(that.enableInCluster) : that.enableInCluster == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientBroker != null ? this.clientBroker.hashCode() : 0;
            result = 31 * result + (this.enableInCluster != null ? this.enableInCluster.hashCode() : 0);
            return result;
        }
    }
}
