package software.amazon.awscdk.services.neptune;

/**
 * (experimental) Properties for a new database cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.R5_LARGE)
 *         .instances(2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.884Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_neptune.DatabaseClusterProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DatabaseClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) What type of instance to start for the replicas.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.InstanceType getInstanceType();

    /**
     * (experimental) What subnets to run the Neptune instances in.
     * <p>
     * Must be at least 2 subnets in two different AZs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * (experimental) A list of AWS Identity and Access Management (IAM) role that can be used by the cluster to access other AWS services.
     * <p>
     * Default: - No role is attached to the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IRole> getAssociatedRoles() {
        return null;
    }

    /**
     * (experimental) If set to true, Neptune will automatically update the engine of the entire cluster to the latest minor version after a stabilization window of 2 to 3 weeks.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * (experimental) How many days to retain the backup.
     * <p>
     * Default: - cdk.Duration.days(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getBackupRetention() {
        return null;
    }

    /**
     * (experimental) Additional parameters to pass to the database engine.
     * <p>
     * Default: - No parameter group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.neptune.IClusterParameterGroup getClusterParameterGroup() {
        return null;
    }

    /**
     * (experimental) An optional identifier for the cluster.
     * <p>
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterName() {
        return null;
    }

    /**
     * (experimental) Indicates whether the DB cluster should have deletion protection enabled.
     * <p>
     * Default: - true if ``removalPolicy`` is RETAIN, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeletionProtection() {
        return null;
    }

    /**
     * (experimental) What version of the database to start.
     * <p>
     * Default: - The default engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.neptune.EngineVersion getEngineVersion() {
        return null;
    }

    /**
     * (experimental) Map AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * Default: - `false`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIamAuthentication() {
        return null;
    }

    /**
     * (experimental) Base identifier for instances.
     * <p>
     * Every replica is named by appending the replica number to this string, 1-based.
     * <p>
     * Default: - `dbClusterName` is used with the word "Instance" appended. If `dbClusterName` is not provided, the
     * identifier is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceIdentifierBase() {
        return null;
    }

    /**
     * (experimental) Number of Neptune compute instances.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInstances() {
        return null;
    }

    /**
     * (experimental) The KMS key for storage encryption.
     * <p>
     * Default: - default master key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * (experimental) The DB parameter group to associate with the instance.
     * <p>
     * Default: no parameter group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.neptune.IParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * (experimental) The port the Neptune cluster will listen on.
     * <p>
     * Default: - The default engine port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) A daily time range in 24-hours UTC format in which backups preferably execute.
     * <p>
     * Must be at least 30 minutes long.
     * <p>
     * Example: '01:00-02:00'
     * <p>
     * Default: - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region. To see the time blocks available, see
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return null;
    }

    /**
     * (experimental) A weekly time range in which maintenance should preferably execute.
     * <p>
     * Must be at least 30 minutes long.
     * <p>
     * Example: 'tue:04:17-tue:04:47'
     * <p>
     * Default: - 30-minute window selected at random from an 8-hour block of time for
     * each AWS Region, occurring on a random day of the week.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * (experimental) The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted.
     * <p>
     * This
     * removal policy also applies to the implicit security group created for the
     * cluster if one is not supplied as a parameter.
     * <p>
     * Default: - Retain cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) Security group.
     * <p>
     * Default: a new security group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * (experimental) Whether to enable storage encryption.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStorageEncrypted() {
        return null;
    }

    /**
     * (experimental) Existing subnet group for the cluster.
     * <p>
     * Default: - a new subnet group will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.neptune.ISubnetGroup getSubnetGroup() {
        return null;
    }

    /**
     * (experimental) Where to place the instances within the VPC.
     * <p>
     * Default: private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseClusterProps> {
        software.amazon.awscdk.services.neptune.InstanceType instanceType;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.util.List<software.amazon.awscdk.services.iam.IRole> associatedRoles;
        java.lang.Boolean autoMinorVersionUpgrade;
        software.amazon.awscdk.core.Duration backupRetention;
        software.amazon.awscdk.services.neptune.IClusterParameterGroup clusterParameterGroup;
        java.lang.String dbClusterName;
        java.lang.Boolean deletionProtection;
        software.amazon.awscdk.services.neptune.EngineVersion engineVersion;
        java.lang.Boolean iamAuthentication;
        java.lang.String instanceIdentifierBase;
        java.lang.Number instances;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.services.neptune.IParameterGroup parameterGroup;
        java.lang.Number port;
        java.lang.String preferredBackupWindow;
        java.lang.String preferredMaintenanceWindow;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.lang.Boolean storageEncrypted;
        software.amazon.awscdk.services.neptune.ISubnetGroup subnetGroup;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstanceType}
         * @param instanceType What type of instance to start for the replicas. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.neptune.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getVpc}
         * @param vpc What subnets to run the Neptune instances in. This parameter is required.
         *            Must be at least 2 subnets in two different AZs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getAssociatedRoles}
         * @param associatedRoles A list of AWS Identity and Access Management (IAM) role that can be used by the cluster to access other AWS services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder associatedRoles(java.util.List<? extends software.amazon.awscdk.services.iam.IRole> associatedRoles) {
            this.associatedRoles = (java.util.List<software.amazon.awscdk.services.iam.IRole>)associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade If set to true, Neptune will automatically update the engine of the entire cluster to the latest minor version after a stabilization window of 2 to 3 weeks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getBackupRetention}
         * @param backupRetention How many days to retain the backup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backupRetention(software.amazon.awscdk.core.Duration backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getClusterParameterGroup}
         * @param clusterParameterGroup Additional parameters to pass to the database engine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterParameterGroup(software.amazon.awscdk.services.neptune.IClusterParameterGroup clusterParameterGroup) {
            this.clusterParameterGroup = clusterParameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getDbClusterName}
         * @param dbClusterName An optional identifier for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dbClusterName(java.lang.String dbClusterName) {
            this.dbClusterName = dbClusterName;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getDeletionProtection}
         * @param deletionProtection Indicates whether the DB cluster should have deletion protection enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getEngineVersion}
         * @param engineVersion What version of the database to start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder engineVersion(software.amazon.awscdk.services.neptune.EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getIamAuthentication}
         * @param iamAuthentication Map AWS Identity and Access Management (IAM) accounts to database accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder iamAuthentication(java.lang.Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstanceIdentifierBase}
         * @param instanceIdentifierBase Base identifier for instances.
         *                               Every replica is named by appending the replica number to this string, 1-based.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceIdentifierBase(java.lang.String instanceIdentifierBase) {
            this.instanceIdentifierBase = instanceIdentifierBase;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstances}
         * @param instances Number of Neptune compute instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instances(java.lang.Number instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getKmsKey}
         * @param kmsKey The KMS key for storage encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getParameterGroup}
         * @param parameterGroup The DB parameter group to associate with the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterGroup(software.amazon.awscdk.services.neptune.IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getPort}
         * @param port The port the Neptune cluster will listen on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getPreferredBackupWindow}
         * @param preferredBackupWindow A daily time range in 24-hours UTC format in which backups preferably execute.
         *                              Must be at least 30 minutes long.
         *                              <p>
         *                              Example: '01:00-02:00'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow A weekly time range in which maintenance should preferably execute.
         *                                   Must be at least 30 minutes long.
         *                                   <p>
         *                                   Example: 'tue:04:17-tue:04:47'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted.
         *                      This
         *                      removal policy also applies to the implicit security group created for the
         *                      cluster if one is not supplied as a parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getSecurityGroups}
         * @param securityGroups Security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getStorageEncrypted}
         * @param storageEncrypted Whether to enable storage encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getSubnetGroup}
         * @param subnetGroup Existing subnet group for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetGroup(software.amazon.awscdk.services.neptune.ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getVpcSubnets}
         * @param vpcSubnets Where to place the instances within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DatabaseClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseClusterProps {
        private final software.amazon.awscdk.services.neptune.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.util.List<software.amazon.awscdk.services.iam.IRole> associatedRoles;
        private final java.lang.Boolean autoMinorVersionUpgrade;
        private final software.amazon.awscdk.core.Duration backupRetention;
        private final software.amazon.awscdk.services.neptune.IClusterParameterGroup clusterParameterGroup;
        private final java.lang.String dbClusterName;
        private final java.lang.Boolean deletionProtection;
        private final software.amazon.awscdk.services.neptune.EngineVersion engineVersion;
        private final java.lang.Boolean iamAuthentication;
        private final java.lang.String instanceIdentifierBase;
        private final java.lang.Number instances;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.services.neptune.IParameterGroup parameterGroup;
        private final java.lang.Number port;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.lang.Boolean storageEncrypted;
        private final software.amazon.awscdk.services.neptune.ISubnetGroup subnetGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.InstanceType.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.associatedRoles = software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class)));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.backupRetention = software.amazon.jsii.Kernel.get(this, "backupRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.clusterParameterGroup = software.amazon.jsii.Kernel.get(this, "clusterParameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.IClusterParameterGroup.class));
            this.dbClusterName = software.amazon.jsii.Kernel.get(this, "dbClusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.EngineVersion.class));
            this.iamAuthentication = software.amazon.jsii.Kernel.get(this, "iamAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceIdentifierBase = software.amazon.jsii.Kernel.get(this, "instanceIdentifierBase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.IParameterGroup.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subnetGroup = software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.ISubnetGroup.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.associatedRoles = (java.util.List<software.amazon.awscdk.services.iam.IRole>)builder.associatedRoles;
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.backupRetention = builder.backupRetention;
            this.clusterParameterGroup = builder.clusterParameterGroup;
            this.dbClusterName = builder.dbClusterName;
            this.deletionProtection = builder.deletionProtection;
            this.engineVersion = builder.engineVersion;
            this.iamAuthentication = builder.iamAuthentication;
            this.instanceIdentifierBase = builder.instanceIdentifierBase;
            this.instances = builder.instances;
            this.kmsKey = builder.kmsKey;
            this.parameterGroup = builder.parameterGroup;
            this.port = builder.port;
            this.preferredBackupWindow = builder.preferredBackupWindow;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.removalPolicy = builder.removalPolicy;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.storageEncrypted = builder.storageEncrypted;
            this.subnetGroup = builder.subnetGroup;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.neptune.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IRole> getAssociatedRoles() {
            return this.associatedRoles;
        }

        @Override
        public final java.lang.Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getBackupRetention() {
            return this.backupRetention;
        }

        @Override
        public final software.amazon.awscdk.services.neptune.IClusterParameterGroup getClusterParameterGroup() {
            return this.clusterParameterGroup;
        }

        @Override
        public final java.lang.String getDbClusterName() {
            return this.dbClusterName;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final software.amazon.awscdk.services.neptune.EngineVersion getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.Boolean getIamAuthentication() {
            return this.iamAuthentication;
        }

        @Override
        public final java.lang.String getInstanceIdentifierBase() {
            return this.instanceIdentifierBase;
        }

        @Override
        public final java.lang.Number getInstances() {
            return this.instances;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.neptune.IParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final software.amazon.awscdk.services.neptune.ISubnetGroup getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAssociatedRoles() != null) {
                data.set("associatedRoles", om.valueToTree(this.getAssociatedRoles()));
            }
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getBackupRetention() != null) {
                data.set("backupRetention", om.valueToTree(this.getBackupRetention()));
            }
            if (this.getClusterParameterGroup() != null) {
                data.set("clusterParameterGroup", om.valueToTree(this.getClusterParameterGroup()));
            }
            if (this.getDbClusterName() != null) {
                data.set("dbClusterName", om.valueToTree(this.getDbClusterName()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getIamAuthentication() != null) {
                data.set("iamAuthentication", om.valueToTree(this.getIamAuthentication()));
            }
            if (this.getInstanceIdentifierBase() != null) {
                data.set("instanceIdentifierBase", om.valueToTree(this.getInstanceIdentifierBase()));
            }
            if (this.getInstances() != null) {
                data.set("instances", om.valueToTree(this.getInstances()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getSubnetGroup() != null) {
                data.set("subnetGroup", om.valueToTree(this.getSubnetGroup()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_neptune.DatabaseClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseClusterProps.Jsii$Proxy that = (DatabaseClusterProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.associatedRoles != null ? !this.associatedRoles.equals(that.associatedRoles) : that.associatedRoles != null) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.backupRetention != null ? !this.backupRetention.equals(that.backupRetention) : that.backupRetention != null) return false;
            if (this.clusterParameterGroup != null ? !this.clusterParameterGroup.equals(that.clusterParameterGroup) : that.clusterParameterGroup != null) return false;
            if (this.dbClusterName != null ? !this.dbClusterName.equals(that.dbClusterName) : that.dbClusterName != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.iamAuthentication != null ? !this.iamAuthentication.equals(that.iamAuthentication) : that.iamAuthentication != null) return false;
            if (this.instanceIdentifierBase != null ? !this.instanceIdentifierBase.equals(that.instanceIdentifierBase) : that.instanceIdentifierBase != null) return false;
            if (this.instances != null ? !this.instances.equals(that.instances) : that.instances != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            if (this.subnetGroup != null ? !this.subnetGroup.equals(that.subnetGroup) : that.subnetGroup != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.associatedRoles != null ? this.associatedRoles.hashCode() : 0);
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.backupRetention != null ? this.backupRetention.hashCode() : 0);
            result = 31 * result + (this.clusterParameterGroup != null ? this.clusterParameterGroup.hashCode() : 0);
            result = 31 * result + (this.dbClusterName != null ? this.dbClusterName.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.iamAuthentication != null ? this.iamAuthentication.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifierBase != null ? this.instanceIdentifierBase.hashCode() : 0);
            result = 31 * result + (this.instances != null ? this.instances.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.subnetGroup != null ? this.subnetGroup.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
