package software.amazon.awscdk.services.neptune;

/**
 * (experimental) A database instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DatabaseInstance replica1 = DatabaseInstance.Builder.create(this, "Instance")
 *         .cluster(cluster)
 *         .instanceType(InstanceType.R5_LARGE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.886Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_neptune.DatabaseInstance")
public class DatabaseInstance extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.neptune.IDatabaseInstance {

    protected DatabaseInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DatabaseInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.DatabaseInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing database instance.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.IDatabaseInstance fromDatabaseInstanceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.DatabaseInstanceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.neptune.DatabaseInstance.class, "fromDatabaseInstanceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.IDatabaseInstance.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) The instance's database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.IDatabaseCluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.IDatabaseCluster.class));
    }

    /**
     * (experimental) The instance endpoint address.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The instance endpoint port.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The instance endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.Endpoint getInstanceEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "instanceEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.Endpoint.class));
    }

    /**
     * (experimental) The instance identifier.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.neptune.DatabaseInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.neptune.DatabaseInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.neptune.DatabaseInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.neptune.DatabaseInstanceProps.Builder();
        }

        /**
         * (experimental) The Neptune database cluster the instance should launch into.
         * <p>
         * @return {@code this}
         * @param cluster The Neptune database cluster the instance should launch into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(final software.amazon.awscdk.services.neptune.IDatabaseCluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * (experimental) What type of instance to start for the replicas.
         * <p>
         * @return {@code this}
         * @param instanceType What type of instance to start for the replicas. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(final software.amazon.awscdk.services.neptune.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * (experimental) The name of the Availability Zone where the DB instance will be located.
         * <p>
         * Default: - no preference
         * <p>
         * @return {@code this}
         * @param availabilityZone The name of the Availability Zone where the DB instance will be located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * (experimental) A name for the DB instance.
         * <p>
         * If you specify a name, AWS CloudFormation
         * converts it to lowercase.
         * <p>
         * Default: - a CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param dbInstanceName A name for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dbInstanceName(final java.lang.String dbInstanceName) {
            this.props.dbInstanceName(dbInstanceName);
            return this;
        }

        /**
         * (experimental) The DB parameter group to associate with the instance.
         * <p>
         * Default: no parameter group
         * <p>
         * @return {@code this}
         * @param parameterGroup The DB parameter group to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterGroup(final software.amazon.awscdk.services.neptune.IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        /**
         * (experimental) The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
         * <p>
         * Default: RemovalPolicy.Retain
         * <p>
         * @return {@code this}
         * @param removalPolicy The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.neptune.DatabaseInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.neptune.DatabaseInstance build() {
            return new software.amazon.awscdk.services.neptune.DatabaseInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
