package software.amazon.awscdk.services.pinpointemail;

/**
 * Properties for defining a `CfnIdentity`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpointemail.*;
 * CfnIdentityProps cfnIdentityProps = CfnIdentityProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .dkimSigningEnabled(false)
 *         .feedbackForwardingEnabled(false)
 *         .mailFromAttributes(MailFromAttributesProperty.builder()
 *                 .behaviorOnMxFailure("behaviorOnMxFailure")
 *                 .mailFromDomain("mailFromDomain")
 *                 .build())
 *         .tags(List.of(TagsProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:07.649Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pinpointemail.CfnIdentityProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdentityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdentityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The address or domain of the identity, such as *sender@example.com* or *example.co.uk* .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain.
     * <p>
     * If the value is <code>true</code> , then the messages that you send from the domain are signed using both the DKIM keys for your domain, as well as the keys for the <code>amazonses.com</code> domain. If the value is <code>false</code> , then the messages that you send are only signed using the DKIM keys for the <code>amazonses.com</code> domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDkimSigningEnabled() {
        return null;
    }

    /**
     * Used to enable or disable feedback forwarding for an identity.
     * <p>
     * This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
     * <p>
     * When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
     * <p>
     * When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFeedbackForwardingEnabled() {
        return null;
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMailFromAttributes() {
        return null;
    }

    /**
     * An object that defines the tags (keys and values) that you want to associate with the email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdentityProps> {
        java.lang.String name;
        java.lang.Object dkimSigningEnabled;
        java.lang.Object feedbackForwardingEnabled;
        java.lang.Object mailFromAttributes;
        java.util.List<software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty> tags;

        /**
         * Sets the value of {@link CfnIdentityProps#getName}
         * @param name The address or domain of the identity, such as *sender@example.com* or *example.co.uk* . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProps#getDkimSigningEnabled}
         * @param dkimSigningEnabled For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain.
         *                           If the value is <code>true</code> , then the messages that you send from the domain are signed using both the DKIM keys for your domain, as well as the keys for the <code>amazonses.com</code> domain. If the value is <code>false</code> , then the messages that you send are only signed using the DKIM keys for the <code>amazonses.com</code> domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningEnabled(java.lang.Boolean dkimSigningEnabled) {
            this.dkimSigningEnabled = dkimSigningEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProps#getDkimSigningEnabled}
         * @param dkimSigningEnabled For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain.
         *                           If the value is <code>true</code> , then the messages that you send from the domain are signed using both the DKIM keys for your domain, as well as the keys for the <code>amazonses.com</code> domain. If the value is <code>false</code> , then the messages that you send are only signed using the DKIM keys for the <code>amazonses.com</code> domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningEnabled(software.amazon.awscdk.core.IResolvable dkimSigningEnabled) {
            this.dkimSigningEnabled = dkimSigningEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProps#getFeedbackForwardingEnabled}
         * @param feedbackForwardingEnabled Used to enable or disable feedback forwarding for an identity.
         *                                  This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
         *                                  <p>
         *                                  When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
         *                                  <p>
         *                                  When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackForwardingEnabled(java.lang.Boolean feedbackForwardingEnabled) {
            this.feedbackForwardingEnabled = feedbackForwardingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProps#getFeedbackForwardingEnabled}
         * @param feedbackForwardingEnabled Used to enable or disable feedback forwarding for an identity.
         *                                  This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
         *                                  <p>
         *                                  When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
         *                                  <p>
         *                                  When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackForwardingEnabled(software.amazon.awscdk.core.IResolvable feedbackForwardingEnabled) {
            this.feedbackForwardingEnabled = feedbackForwardingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProps#getMailFromAttributes}
         * @param mailFromAttributes Used to enable or disable the custom Mail-From domain configuration for an email identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(software.amazon.awscdk.services.pinpointemail.CfnIdentity.MailFromAttributesProperty mailFromAttributes) {
            this.mailFromAttributes = mailFromAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProps#getMailFromAttributes}
         * @param mailFromAttributes Used to enable or disable the custom Mail-From domain configuration for an email identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(software.amazon.awscdk.core.IResolvable mailFromAttributes) {
            this.mailFromAttributes = mailFromAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProps#getTags}
         * @param tags An object that defines the tags (keys and values) that you want to associate with the email identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdentityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdentityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdentityProps {
        private final java.lang.String name;
        private final java.lang.Object dkimSigningEnabled;
        private final java.lang.Object feedbackForwardingEnabled;
        private final java.lang.Object mailFromAttributes;
        private final java.util.List<software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dkimSigningEnabled = software.amazon.jsii.Kernel.get(this, "dkimSigningEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.feedbackForwardingEnabled = software.amazon.jsii.Kernel.get(this, "feedbackForwardingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mailFromAttributes = software.amazon.jsii.Kernel.get(this, "mailFromAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.dkimSigningEnabled = builder.dkimSigningEnabled;
            this.feedbackForwardingEnabled = builder.feedbackForwardingEnabled;
            this.mailFromAttributes = builder.mailFromAttributes;
            this.tags = (java.util.List<software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getDkimSigningEnabled() {
            return this.dkimSigningEnabled;
        }

        @Override
        public final java.lang.Object getFeedbackForwardingEnabled() {
            return this.feedbackForwardingEnabled;
        }

        @Override
        public final java.lang.Object getMailFromAttributes() {
            return this.mailFromAttributes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getDkimSigningEnabled() != null) {
                data.set("dkimSigningEnabled", om.valueToTree(this.getDkimSigningEnabled()));
            }
            if (this.getFeedbackForwardingEnabled() != null) {
                data.set("feedbackForwardingEnabled", om.valueToTree(this.getFeedbackForwardingEnabled()));
            }
            if (this.getMailFromAttributes() != null) {
                data.set("mailFromAttributes", om.valueToTree(this.getMailFromAttributes()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_pinpointemail.CfnIdentityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdentityProps.Jsii$Proxy that = (CfnIdentityProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.dkimSigningEnabled != null ? !this.dkimSigningEnabled.equals(that.dkimSigningEnabled) : that.dkimSigningEnabled != null) return false;
            if (this.feedbackForwardingEnabled != null ? !this.feedbackForwardingEnabled.equals(that.feedbackForwardingEnabled) : that.feedbackForwardingEnabled != null) return false;
            if (this.mailFromAttributes != null ? !this.mailFromAttributes.equals(that.mailFromAttributes) : that.mailFromAttributes != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.dkimSigningEnabled != null ? this.dkimSigningEnabled.hashCode() : 0);
            result = 31 * result + (this.feedbackForwardingEnabled != null ? this.feedbackForwardingEnabled.hashCode() : 0);
            result = 31 * result + (this.mailFromAttributes != null ? this.mailFromAttributes.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
