package software.amazon.awscdk.services.quicksight;

/**
 * A CloudFormation `AWS::QuickSight::DataSet`.
 * <p>
 * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnDataSet cfnDataSet = CfnDataSet.Builder.create(this, "MyCfnDataSet")
 *         .awsAccountId("awsAccountId")
 *         .columnGroups(List.of(ColumnGroupProperty.builder()
 *                 .geoSpatialColumnGroup(GeoSpatialColumnGroupProperty.builder()
 *                         .columns(List.of("columns"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .countryCode("countryCode")
 *                         .build())
 *                 .build()))
 *         .columnLevelPermissionRules(List.of(ColumnLevelPermissionRuleProperty.builder()
 *                 .columnNames(List.of("columnNames"))
 *                 .principals(List.of("principals"))
 *                 .build()))
 *         .dataSetId("dataSetId")
 *         .dataSetUsageConfiguration(DataSetUsageConfigurationProperty.builder()
 *                 .disableUseAsDirectQuerySource(false)
 *                 .disableUseAsImportedSource(false)
 *                 .build())
 *         .fieldFolders(Map.of(
 *                 "fieldFoldersKey", FieldFolderProperty.builder()
 *                         .columns(List.of("columns"))
 *                         .description("description")
 *                         .build()))
 *         .importMode("importMode")
 *         .ingestionWaitPolicy(IngestionWaitPolicyProperty.builder()
 *                 .ingestionWaitTimeInHours(123)
 *                 .waitForSpiceIngestion(false)
 *                 .build())
 *         .logicalTableMap(Map.of(
 *                 "logicalTableMapKey", LogicalTableProperty.builder()
 *                         .alias("alias")
 *                         .source(LogicalTableSourceProperty.builder()
 *                                 .dataSetArn("dataSetArn")
 *                                 .joinInstruction(JoinInstructionProperty.builder()
 *                                         .leftOperand("leftOperand")
 *                                         .onClause("onClause")
 *                                         .rightOperand("rightOperand")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
 *                                                 .uniqueKey(false)
 *                                                 .build())
 *                                         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
 *                                                 .uniqueKey(false)
 *                                                 .build())
 *                                         .build())
 *                                 .physicalTableId("physicalTableId")
 *                                 .build())
 *                         // the properties below are optional
 *                         .dataTransforms(List.of(TransformOperationProperty.builder()
 *                                 .castColumnTypeOperation(CastColumnTypeOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .newColumnType("newColumnType")
 *                                         // the properties below are optional
 *                                         .format("format")
 *                                         .build())
 *                                 .createColumnsOperation(CreateColumnsOperationProperty.builder()
 *                                         .columns(List.of(CalculatedColumnProperty.builder()
 *                                                 .columnId("columnId")
 *                                                 .columnName("columnName")
 *                                                 .expression("expression")
 *                                                 .build()))
 *                                         .build())
 *                                 .filterOperation(FilterOperationProperty.builder()
 *                                         .conditionExpression("conditionExpression")
 *                                         .build())
 *                                 .projectOperation(ProjectOperationProperty.builder()
 *                                         .projectedColumns(List.of("projectedColumns"))
 *                                         .build())
 *                                 .renameColumnOperation(RenameColumnOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .newColumnName("newColumnName")
 *                                         .build())
 *                                 .tagColumnOperation(TagColumnOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .tags(List.of(ColumnTagProperty.builder()
 *                                                 .columnDescription(ColumnDescriptionProperty.builder()
 *                                                         .text("text")
 *                                                         .build())
 *                                                 .columnGeographicRole("columnGeographicRole")
 *                                                 .build()))
 *                                         .build())
 *                                 .build()))
 *                         .build()))
 *         .name("name")
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .physicalTableMap(Map.of(
 *                 "physicalTableMapKey", PhysicalTableProperty.builder()
 *                         .customSql(CustomSqlProperty.builder()
 *                                 .columns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         .build()))
 *                                 .dataSourceArn("dataSourceArn")
 *                                 .name("name")
 *                                 .sqlQuery("sqlQuery")
 *                                 .build())
 *                         .relationalTable(RelationalTableProperty.builder()
 *                                 .dataSourceArn("dataSourceArn")
 *                                 .inputColumns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         .build()))
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .catalog("catalog")
 *                                 .schema("schema")
 *                                 .build())
 *                         .s3Source(S3SourceProperty.builder()
 *                                 .dataSourceArn("dataSourceArn")
 *                                 .inputColumns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .uploadSettings(UploadSettingsProperty.builder()
 *                                         .containsHeader(false)
 *                                         .delimiter("delimiter")
 *                                         .format("format")
 *                                         .startFromRow(123)
 *                                         .textQualifier("textQualifier")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *         .rowLevelPermissionDataSet(RowLevelPermissionDataSetProperty.builder()
 *                 .arn("arn")
 *                 .permissionPolicy("permissionPolicy")
 *                 // the properties below are optional
 *                 .formatVersion("formatVersion")
 *                 .namespace("namespace")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:07.827Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet")
public class CfnDataSet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDataSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnDataSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::QuickSight::DataSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::QuickSight::DataSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrConsumedSpiceCapacityInBytes() {
        return software.amazon.jsii.Kernel.get(this, "attrConsumedSpiceCapacityInBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     * The time this dataset version was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time this dataset version was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrOutputColumns() {
        return software.amazon.jsii.Kernel.get(this, "attrOutputColumns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", value);
    }

    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     * <p>
     * Currently, only geospatial hierarchy is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getColumnGroups() {
        return software.amazon.jsii.Kernel.get(this, "columnGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     * <p>
     * Currently, only geospatial hierarchy is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "columnGroups", value);
    }

    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     * <p>
     * Currently, only geospatial hierarchy is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnGroupProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnGroupProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "columnGroups", value);
    }

    /**
     * A set of one or more definitions of a `ColumnLevelPermissionRule` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getColumnLevelPermissionRules() {
        return software.amazon.jsii.Kernel.get(this, "columnLevelPermissionRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of one or more definitions of a `ColumnLevelPermissionRule` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnLevelPermissionRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "columnLevelPermissionRules", value);
    }

    /**
     * A set of one or more definitions of a `ColumnLevelPermissionRule` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnLevelPermissionRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "columnLevelPermissionRules", value);
    }

    /**
     * An ID for the dataset that you want to create.
     * <p>
     * This ID is unique per AWS Region for each AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataSetId() {
        return software.amazon.jsii.Kernel.get(this, "dataSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An ID for the dataset that you want to create.
     * <p>
     * This ID is unique per AWS Region for each AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataSetId", value);
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSetUsageConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataSetUsageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetUsageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetUsageConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSetUsageConfiguration", value);
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetUsageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSetUsageConfiguration", value);
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFieldFolders() {
        return software.amazon.jsii.Kernel.get(this, "fieldFolders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFieldFolders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fieldFolders", value);
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFieldFolders(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.FieldFolderProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnDataSet.FieldFolderProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "fieldFolders", value);
    }

    /**
     * Indicates whether you want to import the data into SPICE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImportMode() {
        return software.amazon.jsii.Kernel.get(this, "importMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether you want to import the data into SPICE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImportMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "importMode", value);
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     * <p>
     * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIngestionWaitPolicy() {
        return software.amazon.jsii.Kernel.get(this, "ingestionWaitPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     * <p>
     * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestionWaitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.IngestionWaitPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "ingestionWaitPolicy", value);
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     * <p>
     * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestionWaitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ingestionWaitPolicy", value);
    }

    /**
     * Configures the combination and transformation of the data from the physical tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogicalTableMap() {
        return software.amazon.jsii.Kernel.get(this, "logicalTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures the combination and transformation of the data from the physical tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogicalTableMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logicalTableMap", value);
    }

    /**
     * Configures the combination and transformation of the data from the physical tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogicalTableMap(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "logicalTableMap", value);
    }

    /**
     * The display name for the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name for the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A list of resource permissions on the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of resource permissions on the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A list of resource permissions on the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ResourcePermissionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnDataSet.ResourcePermissionProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPhysicalTableMap() {
        return software.amazon.jsii.Kernel.get(this, "physicalTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhysicalTableMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "physicalTableMap", value);
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhysicalTableMap(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.PhysicalTableProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnDataSet.PhysicalTableProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "physicalTableMap", value);
    }

    /**
     * The row-level security configuration for the data that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRowLevelPermissionDataSet() {
        return software.amazon.jsii.Kernel.get(this, "rowLevelPermissionDataSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The row-level security configuration for the data that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRowLevelPermissionDataSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionDataSet", value);
    }

    /**
     * The row-level security configuration for the data that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRowLevelPermissionDataSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionDataSet", value);
    }
    /**
     * A calculated column for a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CalculatedColumnProperty calculatedColumnProperty = CalculatedColumnProperty.builder()
     *         .columnId("columnId")
     *         .columnName("columnName")
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.CalculatedColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(CalculatedColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CalculatedColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique ID to identify a calculated column.
         * <p>
         * During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnId();

        /**
         * Column name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * An expression that defines the calculated column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * @return a {@link Builder} of {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CalculatedColumnProperty> {
            java.lang.String columnId;
            java.lang.String columnName;
            java.lang.String expression;

            /**
             * Sets the value of {@link CalculatedColumnProperty#getColumnId}
             * @param columnId A unique ID to identify a calculated column. This parameter is required.
             *                 During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnId(java.lang.String columnId) {
                this.columnId = columnId;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedColumnProperty#getColumnName}
             * @param columnName Column name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedColumnProperty#getExpression}
             * @param expression An expression that defines the calculated column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CalculatedColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CalculatedColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CalculatedColumnProperty {
            private final java.lang.String columnId;
            private final java.lang.String columnName;
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnId = software.amazon.jsii.Kernel.get(this, "columnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnId = java.util.Objects.requireNonNull(builder.columnId, "columnId is required");
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
            }

            @Override
            public final java.lang.String getColumnId() {
                return this.columnId;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnId", om.valueToTree(this.getColumnId()));
                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("expression", om.valueToTree(this.getExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.CalculatedColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CalculatedColumnProperty.Jsii$Proxy that = (CalculatedColumnProperty.Jsii$Proxy) o;

                if (!columnId.equals(that.columnId)) return false;
                if (!columnName.equals(that.columnName)) return false;
                return this.expression.equals(that.expression);
            }

            @Override
            public final int hashCode() {
                int result = this.columnId.hashCode();
                result = 31 * result + (this.columnName.hashCode());
                result = 31 * result + (this.expression.hashCode());
                return result;
            }
        }
    }
    /**
     * A transform operation that casts a column to a different type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CastColumnTypeOperationProperty castColumnTypeOperationProperty = CastColumnTypeOperationProperty.builder()
     *         .columnName("columnName")
     *         .newColumnType("newColumnType")
     *         // the properties below are optional
     *         .format("format")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.CastColumnTypeOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(CastColumnTypeOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CastColumnTypeOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Column name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * New column data type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnType();

        /**
         * When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CastColumnTypeOperationProperty> {
            java.lang.String columnName;
            java.lang.String newColumnType;
            java.lang.String format;

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getColumnName}
             * @param columnName Column name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getNewColumnType}
             * @param newColumnType New column data type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnType(java.lang.String newColumnType) {
                this.newColumnType = newColumnType;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getFormat}
             * @param format When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CastColumnTypeOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CastColumnTypeOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CastColumnTypeOperationProperty {
            private final java.lang.String columnName;
            private final java.lang.String newColumnType;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnType = software.amazon.jsii.Kernel.get(this, "newColumnType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.newColumnType = java.util.Objects.requireNonNull(builder.newColumnType, "newColumnType is required");
                this.format = builder.format;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getNewColumnType() {
                return this.newColumnType;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("newColumnType", om.valueToTree(this.getNewColumnType()));
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.CastColumnTypeOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CastColumnTypeOperationProperty.Jsii$Proxy that = (CastColumnTypeOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                if (!newColumnType.equals(that.newColumnType)) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.newColumnType.hashCode());
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Metadata that contains a description for a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnDescriptionProperty columnDescriptionProperty = ColumnDescriptionProperty.builder()
     *         .text("text")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.ColumnDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text of a description for a column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnDescriptionProperty> {
            java.lang.String text;

            /**
             * Sets the value of {@link ColumnDescriptionProperty#getText}
             * @param text The text of a description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnDescriptionProperty {
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = builder.text;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.ColumnDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnDescriptionProperty.Jsii$Proxy that = (ColumnDescriptionProperty.Jsii$Proxy) o;

                return this.text != null ? this.text.equals(that.text) : that.text == null;
            }

            @Override
            public final int hashCode() {
                int result = this.text != null ? this.text.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnGroupProperty columnGroupProperty = ColumnGroupProperty.builder()
     *         .geoSpatialColumnGroup(GeoSpatialColumnGroupProperty.builder()
     *                 .columns(List.of("columns"))
     *                 .name("name")
     *                 // the properties below are optional
     *                 .countryCode("countryCode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.ColumnGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Geospatial column group that denotes a hierarchy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeoSpatialColumnGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnGroupProperty> {
            java.lang.Object geoSpatialColumnGroup;

            /**
             * Sets the value of {@link ColumnGroupProperty#getGeoSpatialColumnGroup}
             * @param geoSpatialColumnGroup Geospatial column group that denotes a hierarchy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoSpatialColumnGroup(software.amazon.awscdk.services.quicksight.CfnDataSet.GeoSpatialColumnGroupProperty geoSpatialColumnGroup) {
                this.geoSpatialColumnGroup = geoSpatialColumnGroup;
                return this;
            }

            /**
             * Sets the value of {@link ColumnGroupProperty#getGeoSpatialColumnGroup}
             * @param geoSpatialColumnGroup Geospatial column group that denotes a hierarchy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoSpatialColumnGroup(software.amazon.awscdk.core.IResolvable geoSpatialColumnGroup) {
                this.geoSpatialColumnGroup = geoSpatialColumnGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnGroupProperty {
            private final java.lang.Object geoSpatialColumnGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.geoSpatialColumnGroup = software.amazon.jsii.Kernel.get(this, "geoSpatialColumnGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.geoSpatialColumnGroup = builder.geoSpatialColumnGroup;
            }

            @Override
            public final java.lang.Object getGeoSpatialColumnGroup() {
                return this.geoSpatialColumnGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGeoSpatialColumnGroup() != null) {
                    data.set("geoSpatialColumnGroup", om.valueToTree(this.getGeoSpatialColumnGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.ColumnGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnGroupProperty.Jsii$Proxy that = (ColumnGroupProperty.Jsii$Proxy) o;

                return this.geoSpatialColumnGroup != null ? this.geoSpatialColumnGroup.equals(that.geoSpatialColumnGroup) : that.geoSpatialColumnGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.geoSpatialColumnGroup != null ? this.geoSpatialColumnGroup.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A rule defined to grant access on one or more restricted columns.
     * <p>
     * Each dataset can have multiple rules. To create a restricted column, you add it to one or more rules. Each rule must contain at least one column and at least one user or group. To be able to see a restricted column, a user or group needs to be added to a rule for that column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnLevelPermissionRuleProperty columnLevelPermissionRuleProperty = ColumnLevelPermissionRuleProperty.builder()
     *         .columnNames(List.of("columnNames"))
     *         .principals(List.of("principals"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnLevelPermissionRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnLevelPermissionRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of column names.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumnNames() {
            return null;
        }

        /**
         * An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrincipals() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnLevelPermissionRuleProperty> {
            java.util.List<java.lang.String> columnNames;
            java.util.List<java.lang.String> principals;

            /**
             * Sets the value of {@link ColumnLevelPermissionRuleProperty#getColumnNames}
             * @param columnNames An array of column names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnNames(java.util.List<java.lang.String> columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            /**
             * Sets the value of {@link ColumnLevelPermissionRuleProperty#getPrincipals}
             * @param principals An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principals(java.util.List<java.lang.String> principals) {
                this.principals = principals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnLevelPermissionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnLevelPermissionRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnLevelPermissionRuleProperty {
            private final java.util.List<java.lang.String> columnNames;
            private final java.util.List<java.lang.String> principals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnNames = software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principals = software.amazon.jsii.Kernel.get(this, "principals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnNames = builder.columnNames;
                this.principals = builder.principals;
            }

            @Override
            public final java.util.List<java.lang.String> getColumnNames() {
                return this.columnNames;
            }

            @Override
            public final java.util.List<java.lang.String> getPrincipals() {
                return this.principals;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnNames() != null) {
                    data.set("columnNames", om.valueToTree(this.getColumnNames()));
                }
                if (this.getPrincipals() != null) {
                    data.set("principals", om.valueToTree(this.getPrincipals()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnLevelPermissionRuleProperty.Jsii$Proxy that = (ColumnLevelPermissionRuleProperty.Jsii$Proxy) o;

                if (this.columnNames != null ? !this.columnNames.equals(that.columnNames) : that.columnNames != null) return false;
                return this.principals != null ? this.principals.equals(that.principals) : that.principals == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnNames != null ? this.columnNames.hashCode() : 0;
                result = 31 * result + (this.principals != null ? this.principals.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A tag for a column in a `[TagColumnOperation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagColumnOperation.html)` structure. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnTagProperty columnTagProperty = ColumnTagProperty.builder()
     *         .columnDescription(ColumnDescriptionProperty.builder()
     *                 .text("text")
     *                 .build())
     *         .columnGeographicRole("columnGeographicRole")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.ColumnTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description for a column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnDescription() {
            return null;
        }

        /**
         * A geospatial role for a column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnGeographicRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnTagProperty> {
            java.lang.Object columnDescription;
            java.lang.String columnGeographicRole;

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnDescription}
             * @param columnDescription A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDescription(software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnDescriptionProperty columnDescription) {
                this.columnDescription = columnDescription;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnDescription}
             * @param columnDescription A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDescription(software.amazon.awscdk.core.IResolvable columnDescription) {
                this.columnDescription = columnDescription;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnGeographicRole}
             * @param columnGeographicRole A geospatial role for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnGeographicRole(java.lang.String columnGeographicRole) {
                this.columnGeographicRole = columnGeographicRole;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnTagProperty {
            private final java.lang.Object columnDescription;
            private final java.lang.String columnGeographicRole;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnDescription = software.amazon.jsii.Kernel.get(this, "columnDescription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnGeographicRole = software.amazon.jsii.Kernel.get(this, "columnGeographicRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnDescription = builder.columnDescription;
                this.columnGeographicRole = builder.columnGeographicRole;
            }

            @Override
            public final java.lang.Object getColumnDescription() {
                return this.columnDescription;
            }

            @Override
            public final java.lang.String getColumnGeographicRole() {
                return this.columnGeographicRole;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnDescription() != null) {
                    data.set("columnDescription", om.valueToTree(this.getColumnDescription()));
                }
                if (this.getColumnGeographicRole() != null) {
                    data.set("columnGeographicRole", om.valueToTree(this.getColumnGeographicRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.ColumnTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnTagProperty.Jsii$Proxy that = (ColumnTagProperty.Jsii$Proxy) o;

                if (this.columnDescription != null ? !this.columnDescription.equals(that.columnDescription) : that.columnDescription != null) return false;
                return this.columnGeographicRole != null ? this.columnGeographicRole.equals(that.columnGeographicRole) : that.columnGeographicRole == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnDescription != null ? this.columnDescription.hashCode() : 0;
                result = 31 * result + (this.columnGeographicRole != null ? this.columnGeographicRole.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that creates calculated columns.
     * <p>
     * Columns created in one such operation form a lexical closure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CreateColumnsOperationProperty createColumnsOperationProperty = CreateColumnsOperationProperty.builder()
     *         .columns(List.of(CalculatedColumnProperty.builder()
     *                 .columnId("columnId")
     *                 .columnName("columnName")
     *                 .expression("expression")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.CreateColumnsOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateColumnsOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateColumnsOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Calculated columns to create.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumns();

        /**
         * @return a {@link Builder} of {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateColumnsOperationProperty> {
            java.lang.Object columns;

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getColumns}
             * @param columns Calculated columns to create. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.core.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getColumns}
             * @param columns Calculated columns to create. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateColumnsOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateColumnsOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateColumnsOperationProperty {
            private final java.lang.Object columns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = java.util.Objects.requireNonNull(builder.columns, "columns is required");
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columns", om.valueToTree(this.getColumns()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.CreateColumnsOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateColumnsOperationProperty.Jsii$Proxy that = (CreateColumnsOperationProperty.Jsii$Proxy) o;

                return this.columns.equals(that.columns);
            }

            @Override
            public final int hashCode() {
                int result = this.columns.hashCode();
                return result;
            }
        }
    }
    /**
     * A physical table type built from the results of the custom SQL query.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CustomSqlProperty customSqlProperty = CustomSqlProperty.builder()
     *         .columns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .dataSourceArn("dataSourceArn")
     *         .name("name")
     *         .sqlQuery("sqlQuery")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.CustomSqlProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomSqlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomSqlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column schema from the SQL query result set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumns();

        /**
         * The Amazon Resource Name (ARN) of the data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceArn();

        /**
         * A display name for the SQL query result.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The SQL query.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlQuery();

        /**
         * @return a {@link Builder} of {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomSqlProperty> {
            java.lang.Object columns;
            java.lang.String dataSourceArn;
            java.lang.String name;
            java.lang.String sqlQuery;

            /**
             * Sets the value of {@link CustomSqlProperty#getColumns}
             * @param columns The column schema from the SQL query result set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.core.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getColumns}
             * @param columns The column schema from the SQL query result set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getDataSourceArn}
             * @param dataSourceArn The Amazon Resource Name (ARN) of the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceArn(java.lang.String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getName}
             * @param name A display name for the SQL query result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getSqlQuery}
             * @param sqlQuery The SQL query. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlQuery(java.lang.String sqlQuery) {
                this.sqlQuery = sqlQuery;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomSqlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomSqlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomSqlProperty {
            private final java.lang.Object columns;
            private final java.lang.String dataSourceArn;
            private final java.lang.String name;
            private final java.lang.String sqlQuery;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataSourceArn = software.amazon.jsii.Kernel.get(this, "dataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqlQuery = software.amazon.jsii.Kernel.get(this, "sqlQuery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = java.util.Objects.requireNonNull(builder.columns, "columns is required");
                this.dataSourceArn = java.util.Objects.requireNonNull(builder.dataSourceArn, "dataSourceArn is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.sqlQuery = java.util.Objects.requireNonNull(builder.sqlQuery, "sqlQuery is required");
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getDataSourceArn() {
                return this.dataSourceArn;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSqlQuery() {
                return this.sqlQuery;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columns", om.valueToTree(this.getColumns()));
                data.set("dataSourceArn", om.valueToTree(this.getDataSourceArn()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("sqlQuery", om.valueToTree(this.getSqlQuery()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.CustomSqlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomSqlProperty.Jsii$Proxy that = (CustomSqlProperty.Jsii$Proxy) o;

                if (!columns.equals(that.columns)) return false;
                if (!dataSourceArn.equals(that.dataSourceArn)) return false;
                if (!name.equals(that.name)) return false;
                return this.sqlQuery.equals(that.sqlQuery);
            }

            @Override
            public final int hashCode() {
                int result = this.columns.hashCode();
                result = 31 * result + (this.dataSourceArn.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.sqlQuery.hashCode());
                return result;
            }
        }
    }
    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetUsageConfigurationProperty dataSetUsageConfigurationProperty = DataSetUsageConfigurationProperty.builder()
     *         .disableUseAsDirectQuerySource(false)
     *         .disableUseAsImportedSource(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.DataSetUsageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetUsageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetUsageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An option that controls whether a child dataset of a direct query can use this dataset as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableUseAsDirectQuerySource() {
            return null;
        }

        /**
         * An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableUseAsImportedSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetUsageConfigurationProperty> {
            java.lang.Object disableUseAsDirectQuerySource;
            java.lang.Object disableUseAsImportedSource;

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsDirectQuerySource}
             * @param disableUseAsDirectQuerySource An option that controls whether a child dataset of a direct query can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsDirectQuerySource(java.lang.Boolean disableUseAsDirectQuerySource) {
                this.disableUseAsDirectQuerySource = disableUseAsDirectQuerySource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsDirectQuerySource}
             * @param disableUseAsDirectQuerySource An option that controls whether a child dataset of a direct query can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsDirectQuerySource(software.amazon.awscdk.core.IResolvable disableUseAsDirectQuerySource) {
                this.disableUseAsDirectQuerySource = disableUseAsDirectQuerySource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsImportedSource}
             * @param disableUseAsImportedSource An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsImportedSource(java.lang.Boolean disableUseAsImportedSource) {
                this.disableUseAsImportedSource = disableUseAsImportedSource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsImportedSource}
             * @param disableUseAsImportedSource An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsImportedSource(software.amazon.awscdk.core.IResolvable disableUseAsImportedSource) {
                this.disableUseAsImportedSource = disableUseAsImportedSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetUsageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetUsageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetUsageConfigurationProperty {
            private final java.lang.Object disableUseAsDirectQuerySource;
            private final java.lang.Object disableUseAsImportedSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.disableUseAsDirectQuerySource = software.amazon.jsii.Kernel.get(this, "disableUseAsDirectQuerySource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableUseAsImportedSource = software.amazon.jsii.Kernel.get(this, "disableUseAsImportedSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.disableUseAsDirectQuerySource = builder.disableUseAsDirectQuerySource;
                this.disableUseAsImportedSource = builder.disableUseAsImportedSource;
            }

            @Override
            public final java.lang.Object getDisableUseAsDirectQuerySource() {
                return this.disableUseAsDirectQuerySource;
            }

            @Override
            public final java.lang.Object getDisableUseAsImportedSource() {
                return this.disableUseAsImportedSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDisableUseAsDirectQuerySource() != null) {
                    data.set("disableUseAsDirectQuerySource", om.valueToTree(this.getDisableUseAsDirectQuerySource()));
                }
                if (this.getDisableUseAsImportedSource() != null) {
                    data.set("disableUseAsImportedSource", om.valueToTree(this.getDisableUseAsImportedSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.DataSetUsageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetUsageConfigurationProperty.Jsii$Proxy that = (DataSetUsageConfigurationProperty.Jsii$Proxy) o;

                if (this.disableUseAsDirectQuerySource != null ? !this.disableUseAsDirectQuerySource.equals(that.disableUseAsDirectQuerySource) : that.disableUseAsDirectQuerySource != null) return false;
                return this.disableUseAsImportedSource != null ? this.disableUseAsImportedSource.equals(that.disableUseAsImportedSource) : that.disableUseAsImportedSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.disableUseAsDirectQuerySource != null ? this.disableUseAsDirectQuerySource.hashCode() : 0;
                result = 31 * result + (this.disableUseAsImportedSource != null ? this.disableUseAsImportedSource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A FieldFolder element is a folder that contains fields and nested subfolders.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * FieldFolderProperty fieldFolderProperty = FieldFolderProperty.builder()
     *         .columns(List.of("columns"))
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.FieldFolderProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldFolderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldFolderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A folder has a list of columns.
         * <p>
         * A column can only be in one folder.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumns() {
            return null;
        }

        /**
         * The description for a field folder.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldFolderProperty> {
            java.util.List<java.lang.String> columns;
            java.lang.String description;

            /**
             * Sets the value of {@link FieldFolderProperty#getColumns}
             * @param columns A folder has a list of columns.
             *                A column can only be in one folder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<java.lang.String> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link FieldFolderProperty#getDescription}
             * @param description The description for a field folder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldFolderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldFolderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldFolderProperty {
            private final java.util.List<java.lang.String> columns;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = builder.columns;
                this.description = builder.description;
            }

            @Override
            public final java.util.List<java.lang.String> getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.FieldFolderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldFolderProperty.Jsii$Proxy that = (FieldFolderProperty.Jsii$Proxy) o;

                if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns != null ? this.columns.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that filters rows based on a condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * FilterOperationProperty filterOperationProperty = FilterOperationProperty.builder()
     *         .conditionExpression("conditionExpression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.FilterOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that must evaluate to a Boolean value.
         * <p>
         * Rows for which the expression evaluates to true are kept in the dataset.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConditionExpression();

        /**
         * @return a {@link Builder} of {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterOperationProperty> {
            java.lang.String conditionExpression;

            /**
             * Sets the value of {@link FilterOperationProperty#getConditionExpression}
             * @param conditionExpression An expression that must evaluate to a Boolean value. This parameter is required.
             *                            Rows for which the expression evaluates to true are kept in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionExpression(java.lang.String conditionExpression) {
                this.conditionExpression = conditionExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterOperationProperty {
            private final java.lang.String conditionExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditionExpression = software.amazon.jsii.Kernel.get(this, "conditionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditionExpression = java.util.Objects.requireNonNull(builder.conditionExpression, "conditionExpression is required");
            }

            @Override
            public final java.lang.String getConditionExpression() {
                return this.conditionExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("conditionExpression", om.valueToTree(this.getConditionExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.FilterOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterOperationProperty.Jsii$Proxy that = (FilterOperationProperty.Jsii$Proxy) o;

                return this.conditionExpression.equals(that.conditionExpression);
            }

            @Override
            public final int hashCode() {
                int result = this.conditionExpression.hashCode();
                return result;
            }
        }
    }
    /**
     * Geospatial column group that denotes a hierarchy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * GeoSpatialColumnGroupProperty geoSpatialColumnGroupProperty = GeoSpatialColumnGroupProperty.builder()
     *         .columns(List.of("columns"))
     *         .name("name")
     *         // the properties below are optional
     *         .countryCode("countryCode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.GeoSpatialColumnGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoSpatialColumnGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoSpatialColumnGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Columns in this hierarchy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getColumns();

        /**
         * A display name for the hierarchy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Country code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountryCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoSpatialColumnGroupProperty> {
            java.util.List<java.lang.String> columns;
            java.lang.String name;
            java.lang.String countryCode;

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getColumns}
             * @param columns Columns in this hierarchy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<java.lang.String> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getName}
             * @param name A display name for the hierarchy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getCountryCode}
             * @param countryCode Country code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCode(java.lang.String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoSpatialColumnGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoSpatialColumnGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoSpatialColumnGroupProperty {
            private final java.util.List<java.lang.String> columns;
            private final java.lang.String name;
            private final java.lang.String countryCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.countryCode = software.amazon.jsii.Kernel.get(this, "countryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = java.util.Objects.requireNonNull(builder.columns, "columns is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.countryCode = builder.countryCode;
            }

            @Override
            public final java.util.List<java.lang.String> getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCountryCode() {
                return this.countryCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columns", om.valueToTree(this.getColumns()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getCountryCode() != null) {
                    data.set("countryCode", om.valueToTree(this.getCountryCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.GeoSpatialColumnGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoSpatialColumnGroupProperty.Jsii$Proxy that = (GeoSpatialColumnGroupProperty.Jsii$Proxy) o;

                if (!columns.equals(that.columns)) return false;
                if (!name.equals(that.name)) return false;
                return this.countryCode != null ? this.countryCode.equals(that.countryCode) : that.countryCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.countryCode != null ? this.countryCode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The wait policy to use when creating or updating a Dataset.
     * <p>
     * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IngestionWaitPolicyProperty ingestionWaitPolicyProperty = IngestionWaitPolicyProperty.builder()
     *         .ingestionWaitTimeInHours(123)
     *         .waitForSpiceIngestion(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.IngestionWaitPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(IngestionWaitPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngestionWaitPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum time (in hours) to wait for Ingestion to complete.
         * <p>
         * Default timeout is 36 hours. Applicable only when <code>DataSetImportMode</code> mode is set to SPICE and <code>WaitForSpiceIngestion</code> is set to true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIngestionWaitTimeInHours() {
            return null;
        }

        /**
         * Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
         * <p>
         * Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWaitForSpiceIngestion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngestionWaitPolicyProperty> {
            java.lang.Number ingestionWaitTimeInHours;
            java.lang.Object waitForSpiceIngestion;

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getIngestionWaitTimeInHours}
             * @param ingestionWaitTimeInHours The maximum time (in hours) to wait for Ingestion to complete.
             *                                 Default timeout is 36 hours. Applicable only when <code>DataSetImportMode</code> mode is set to SPICE and <code>WaitForSpiceIngestion</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingestionWaitTimeInHours(java.lang.Number ingestionWaitTimeInHours) {
                this.ingestionWaitTimeInHours = ingestionWaitTimeInHours;
                return this;
            }

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getWaitForSpiceIngestion}
             * @param waitForSpiceIngestion Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
             *                              Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitForSpiceIngestion(java.lang.Boolean waitForSpiceIngestion) {
                this.waitForSpiceIngestion = waitForSpiceIngestion;
                return this;
            }

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getWaitForSpiceIngestion}
             * @param waitForSpiceIngestion Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
             *                              Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitForSpiceIngestion(software.amazon.awscdk.core.IResolvable waitForSpiceIngestion) {
                this.waitForSpiceIngestion = waitForSpiceIngestion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngestionWaitPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngestionWaitPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngestionWaitPolicyProperty {
            private final java.lang.Number ingestionWaitTimeInHours;
            private final java.lang.Object waitForSpiceIngestion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ingestionWaitTimeInHours = software.amazon.jsii.Kernel.get(this, "ingestionWaitTimeInHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.waitForSpiceIngestion = software.amazon.jsii.Kernel.get(this, "waitForSpiceIngestion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ingestionWaitTimeInHours = builder.ingestionWaitTimeInHours;
                this.waitForSpiceIngestion = builder.waitForSpiceIngestion;
            }

            @Override
            public final java.lang.Number getIngestionWaitTimeInHours() {
                return this.ingestionWaitTimeInHours;
            }

            @Override
            public final java.lang.Object getWaitForSpiceIngestion() {
                return this.waitForSpiceIngestion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIngestionWaitTimeInHours() != null) {
                    data.set("ingestionWaitTimeInHours", om.valueToTree(this.getIngestionWaitTimeInHours()));
                }
                if (this.getWaitForSpiceIngestion() != null) {
                    data.set("waitForSpiceIngestion", om.valueToTree(this.getWaitForSpiceIngestion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.IngestionWaitPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngestionWaitPolicyProperty.Jsii$Proxy that = (IngestionWaitPolicyProperty.Jsii$Proxy) o;

                if (this.ingestionWaitTimeInHours != null ? !this.ingestionWaitTimeInHours.equals(that.ingestionWaitTimeInHours) : that.ingestionWaitTimeInHours != null) return false;
                return this.waitForSpiceIngestion != null ? this.waitForSpiceIngestion.equals(that.waitForSpiceIngestion) : that.waitForSpiceIngestion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ingestionWaitTimeInHours != null ? this.ingestionWaitTimeInHours.hashCode() : 0;
                result = 31 * result + (this.waitForSpiceIngestion != null ? this.waitForSpiceIngestion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Metadata for a column that is used as the input of a transform operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * InputColumnProperty inputColumnProperty = InputColumnProperty.builder()
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.InputColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(InputColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of this column in the underlying data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The data type of the column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputColumnProperty> {
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link InputColumnProperty#getName}
             * @param name The name of this column in the underlying data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link InputColumnProperty#getType}
             * @param type The data type of the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputColumnProperty {
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.InputColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputColumnProperty.Jsii$Proxy that = (InputColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * The instructions associated with a join.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * JoinInstructionProperty joinInstructionProperty = JoinInstructionProperty.builder()
     *         .leftOperand("leftOperand")
     *         .onClause("onClause")
     *         .rightOperand("rightOperand")
     *         .type("type")
     *         // the properties below are optional
     *         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                 .uniqueKey(false)
     *                 .build())
     *         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                 .uniqueKey(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.JoinInstructionProperty")
    @software.amazon.jsii.Jsii.Proxy(JoinInstructionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JoinInstructionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operand on the left side of a join.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLeftOperand();

        /**
         * The join instructions provided in the `ON` clause of a join.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOnClause();

        /**
         * The operand on the right side of a join.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRightOperand();

        /**
         * The type of join that it is.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Join key properties of the left operand.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLeftJoinKeyProperties() {
            return null;
        }

        /**
         * Join key properties of the right operand.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRightJoinKeyProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JoinInstructionProperty> {
            java.lang.String leftOperand;
            java.lang.String onClause;
            java.lang.String rightOperand;
            java.lang.String type;
            java.lang.Object leftJoinKeyProperties;
            java.lang.Object rightJoinKeyProperties;

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftOperand}
             * @param leftOperand The operand on the left side of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOperand(java.lang.String leftOperand) {
                this.leftOperand = leftOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getOnClause}
             * @param onClause The join instructions provided in the `ON` clause of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onClause(java.lang.String onClause) {
                this.onClause = onClause;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightOperand}
             * @param rightOperand The operand on the right side of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightOperand(java.lang.String rightOperand) {
                this.rightOperand = rightOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getType}
             * @param type The type of join that it is. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftJoinKeyProperties}
             * @param leftJoinKeyProperties Join key properties of the left operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftJoinKeyProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinKeyPropertiesProperty leftJoinKeyProperties) {
                this.leftJoinKeyProperties = leftJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftJoinKeyProperties}
             * @param leftJoinKeyProperties Join key properties of the left operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftJoinKeyProperties(software.amazon.awscdk.core.IResolvable leftJoinKeyProperties) {
                this.leftJoinKeyProperties = leftJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightJoinKeyProperties}
             * @param rightJoinKeyProperties Join key properties of the right operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightJoinKeyProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinKeyPropertiesProperty rightJoinKeyProperties) {
                this.rightJoinKeyProperties = rightJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightJoinKeyProperties}
             * @param rightJoinKeyProperties Join key properties of the right operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightJoinKeyProperties(software.amazon.awscdk.core.IResolvable rightJoinKeyProperties) {
                this.rightJoinKeyProperties = rightJoinKeyProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JoinInstructionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JoinInstructionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JoinInstructionProperty {
            private final java.lang.String leftOperand;
            private final java.lang.String onClause;
            private final java.lang.String rightOperand;
            private final java.lang.String type;
            private final java.lang.Object leftJoinKeyProperties;
            private final java.lang.Object rightJoinKeyProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.leftOperand = software.amazon.jsii.Kernel.get(this, "leftOperand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onClause = software.amazon.jsii.Kernel.get(this, "onClause", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rightOperand = software.amazon.jsii.Kernel.get(this, "rightOperand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.leftJoinKeyProperties = software.amazon.jsii.Kernel.get(this, "leftJoinKeyProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rightJoinKeyProperties = software.amazon.jsii.Kernel.get(this, "rightJoinKeyProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.leftOperand = java.util.Objects.requireNonNull(builder.leftOperand, "leftOperand is required");
                this.onClause = java.util.Objects.requireNonNull(builder.onClause, "onClause is required");
                this.rightOperand = java.util.Objects.requireNonNull(builder.rightOperand, "rightOperand is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.leftJoinKeyProperties = builder.leftJoinKeyProperties;
                this.rightJoinKeyProperties = builder.rightJoinKeyProperties;
            }

            @Override
            public final java.lang.String getLeftOperand() {
                return this.leftOperand;
            }

            @Override
            public final java.lang.String getOnClause() {
                return this.onClause;
            }

            @Override
            public final java.lang.String getRightOperand() {
                return this.rightOperand;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getLeftJoinKeyProperties() {
                return this.leftJoinKeyProperties;
            }

            @Override
            public final java.lang.Object getRightJoinKeyProperties() {
                return this.rightJoinKeyProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("leftOperand", om.valueToTree(this.getLeftOperand()));
                data.set("onClause", om.valueToTree(this.getOnClause()));
                data.set("rightOperand", om.valueToTree(this.getRightOperand()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getLeftJoinKeyProperties() != null) {
                    data.set("leftJoinKeyProperties", om.valueToTree(this.getLeftJoinKeyProperties()));
                }
                if (this.getRightJoinKeyProperties() != null) {
                    data.set("rightJoinKeyProperties", om.valueToTree(this.getRightJoinKeyProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.JoinInstructionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JoinInstructionProperty.Jsii$Proxy that = (JoinInstructionProperty.Jsii$Proxy) o;

                if (!leftOperand.equals(that.leftOperand)) return false;
                if (!onClause.equals(that.onClause)) return false;
                if (!rightOperand.equals(that.rightOperand)) return false;
                if (!type.equals(that.type)) return false;
                if (this.leftJoinKeyProperties != null ? !this.leftJoinKeyProperties.equals(that.leftJoinKeyProperties) : that.leftJoinKeyProperties != null) return false;
                return this.rightJoinKeyProperties != null ? this.rightJoinKeyProperties.equals(that.rightJoinKeyProperties) : that.rightJoinKeyProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.leftOperand.hashCode();
                result = 31 * result + (this.onClause.hashCode());
                result = 31 * result + (this.rightOperand.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.leftJoinKeyProperties != null ? this.leftJoinKeyProperties.hashCode() : 0);
                result = 31 * result + (this.rightJoinKeyProperties != null ? this.rightJoinKeyProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Properties associated with the columns participating in a join.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * JoinKeyPropertiesProperty joinKeyPropertiesProperty = JoinKeyPropertiesProperty.builder()
     *         .uniqueKey(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.JoinKeyPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(JoinKeyPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JoinKeyPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that indicates that a row in a table is uniquely identified by the columns in a join key.
         * <p>
         * This is used by Amazon QuickSight to optimize query performance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUniqueKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JoinKeyPropertiesProperty> {
            java.lang.Object uniqueKey;

            /**
             * Sets the value of {@link JoinKeyPropertiesProperty#getUniqueKey}
             * @param uniqueKey A value that indicates that a row in a table is uniquely identified by the columns in a join key.
             *                  This is used by Amazon QuickSight to optimize query performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKey(java.lang.Boolean uniqueKey) {
                this.uniqueKey = uniqueKey;
                return this;
            }

            /**
             * Sets the value of {@link JoinKeyPropertiesProperty#getUniqueKey}
             * @param uniqueKey A value that indicates that a row in a table is uniquely identified by the columns in a join key.
             *                  This is used by Amazon QuickSight to optimize query performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKey(software.amazon.awscdk.core.IResolvable uniqueKey) {
                this.uniqueKey = uniqueKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JoinKeyPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JoinKeyPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JoinKeyPropertiesProperty {
            private final java.lang.Object uniqueKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.uniqueKey = software.amazon.jsii.Kernel.get(this, "uniqueKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.uniqueKey = builder.uniqueKey;
            }

            @Override
            public final java.lang.Object getUniqueKey() {
                return this.uniqueKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUniqueKey() != null) {
                    data.set("uniqueKey", om.valueToTree(this.getUniqueKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.JoinKeyPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JoinKeyPropertiesProperty.Jsii$Proxy that = (JoinKeyPropertiesProperty.Jsii$Proxy) o;

                return this.uniqueKey != null ? this.uniqueKey.equals(that.uniqueKey) : that.uniqueKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.uniqueKey != null ? this.uniqueKey.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A *logical table* is a unit that joins and that data transformations operate on.
     * <p>
     * A logical table has a source, which can be either a physical table or result of a join. When a logical table points to a physical table, the logical table acts as a mutable copy of that physical table through transform operations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * LogicalTableProperty logicalTableProperty = LogicalTableProperty.builder()
     *         .alias("alias")
     *         .source(LogicalTableSourceProperty.builder()
     *                 .dataSetArn("dataSetArn")
     *                 .joinInstruction(JoinInstructionProperty.builder()
     *                         .leftOperand("leftOperand")
     *                         .onClause("onClause")
     *                         .rightOperand("rightOperand")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                                 .uniqueKey(false)
     *                                 .build())
     *                         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                                 .uniqueKey(false)
     *                                 .build())
     *                         .build())
     *                 .physicalTableId("physicalTableId")
     *                 .build())
     *         // the properties below are optional
     *         .dataTransforms(List.of(TransformOperationProperty.builder()
     *                 .castColumnTypeOperation(CastColumnTypeOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .newColumnType("newColumnType")
     *                         // the properties below are optional
     *                         .format("format")
     *                         .build())
     *                 .createColumnsOperation(CreateColumnsOperationProperty.builder()
     *                         .columns(List.of(CalculatedColumnProperty.builder()
     *                                 .columnId("columnId")
     *                                 .columnName("columnName")
     *                                 .expression("expression")
     *                                 .build()))
     *                         .build())
     *                 .filterOperation(FilterOperationProperty.builder()
     *                         .conditionExpression("conditionExpression")
     *                         .build())
     *                 .projectOperation(ProjectOperationProperty.builder()
     *                         .projectedColumns(List.of("projectedColumns"))
     *                         .build())
     *                 .renameColumnOperation(RenameColumnOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .newColumnName("newColumnName")
     *                         .build())
     *                 .tagColumnOperation(TagColumnOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .tags(List.of(ColumnTagProperty.builder()
     *                                 .columnDescription(ColumnDescriptionProperty.builder()
     *                                         .text("text")
     *                                         .build())
     *                                 .columnGeographicRole("columnGeographicRole")
     *                                 .build()))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.LogicalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(LogicalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogicalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for the logical table.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * Source of this logical table.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * Transform operations that act on this logical table.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTransforms() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogicalTableProperty> {
            java.lang.String alias;
            java.lang.Object source;
            java.lang.Object dataTransforms;

            /**
             * Sets the value of {@link LogicalTableProperty#getAlias}
             * @param alias A display name for the logical table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getSource}
             * @param source Source of this logical table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getSource}
             * @param source Source of this logical table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.core.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getDataTransforms}
             * @param dataTransforms Transform operations that act on this logical table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransforms(software.amazon.awscdk.core.IResolvable dataTransforms) {
                this.dataTransforms = dataTransforms;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getDataTransforms}
             * @param dataTransforms Transform operations that act on this logical table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransforms(java.util.List<? extends java.lang.Object> dataTransforms) {
                this.dataTransforms = dataTransforms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogicalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogicalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogicalTableProperty {
            private final java.lang.String alias;
            private final java.lang.Object source;
            private final java.lang.Object dataTransforms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataTransforms = software.amazon.jsii.Kernel.get(this, "dataTransforms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.dataTransforms = builder.dataTransforms;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            public final java.lang.Object getDataTransforms() {
                return this.dataTransforms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("source", om.valueToTree(this.getSource()));
                if (this.getDataTransforms() != null) {
                    data.set("dataTransforms", om.valueToTree(this.getDataTransforms()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.LogicalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogicalTableProperty.Jsii$Proxy that = (LogicalTableProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (!source.equals(that.source)) return false;
                return this.dataTransforms != null ? this.dataTransforms.equals(that.dataTransforms) : that.dataTransforms == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.dataTransforms != null ? this.dataTransforms.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the source of a logical table.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * LogicalTableSourceProperty logicalTableSourceProperty = LogicalTableSourceProperty.builder()
     *         .dataSetArn("dataSetArn")
     *         .joinInstruction(JoinInstructionProperty.builder()
     *                 .leftOperand("leftOperand")
     *                 .onClause("onClause")
     *                 .rightOperand("rightOperand")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                         .uniqueKey(false)
     *                         .build())
     *                 .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                         .uniqueKey(false)
     *                         .build())
     *                 .build())
     *         .physicalTableId("physicalTableId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.LogicalTableSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(LogicalTableSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogicalTableSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Number (ARN) of the parent dataset.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataSetArn() {
            return null;
        }

        /**
         * Specifies the result of a join of two logical tables.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJoinInstruction() {
            return null;
        }

        /**
         * Physical table ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPhysicalTableId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogicalTableSourceProperty> {
            java.lang.String dataSetArn;
            java.lang.Object joinInstruction;
            java.lang.String physicalTableId;

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getDataSetArn}
             * @param dataSetArn The Amazon Resource Number (ARN) of the parent dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetArn(java.lang.String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getJoinInstruction}
             * @param joinInstruction Specifies the result of a join of two logical tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinInstruction(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinInstructionProperty joinInstruction) {
                this.joinInstruction = joinInstruction;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getJoinInstruction}
             * @param joinInstruction Specifies the result of a join of two logical tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinInstruction(software.amazon.awscdk.core.IResolvable joinInstruction) {
                this.joinInstruction = joinInstruction;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getPhysicalTableId}
             * @param physicalTableId Physical table ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalTableId(java.lang.String physicalTableId) {
                this.physicalTableId = physicalTableId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogicalTableSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogicalTableSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogicalTableSourceProperty {
            private final java.lang.String dataSetArn;
            private final java.lang.Object joinInstruction;
            private final java.lang.String physicalTableId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetArn = software.amazon.jsii.Kernel.get(this, "dataSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.joinInstruction = software.amazon.jsii.Kernel.get(this, "joinInstruction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.physicalTableId = software.amazon.jsii.Kernel.get(this, "physicalTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetArn = builder.dataSetArn;
                this.joinInstruction = builder.joinInstruction;
                this.physicalTableId = builder.physicalTableId;
            }

            @Override
            public final java.lang.String getDataSetArn() {
                return this.dataSetArn;
            }

            @Override
            public final java.lang.Object getJoinInstruction() {
                return this.joinInstruction;
            }

            @Override
            public final java.lang.String getPhysicalTableId() {
                return this.physicalTableId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataSetArn() != null) {
                    data.set("dataSetArn", om.valueToTree(this.getDataSetArn()));
                }
                if (this.getJoinInstruction() != null) {
                    data.set("joinInstruction", om.valueToTree(this.getJoinInstruction()));
                }
                if (this.getPhysicalTableId() != null) {
                    data.set("physicalTableId", om.valueToTree(this.getPhysicalTableId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.LogicalTableSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogicalTableSourceProperty.Jsii$Proxy that = (LogicalTableSourceProperty.Jsii$Proxy) o;

                if (this.dataSetArn != null ? !this.dataSetArn.equals(that.dataSetArn) : that.dataSetArn != null) return false;
                if (this.joinInstruction != null ? !this.joinInstruction.equals(that.joinInstruction) : that.joinInstruction != null) return false;
                return this.physicalTableId != null ? this.physicalTableId.equals(that.physicalTableId) : that.physicalTableId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetArn != null ? this.dataSetArn.hashCode() : 0;
                result = 31 * result + (this.joinInstruction != null ? this.joinInstruction.hashCode() : 0);
                result = 31 * result + (this.physicalTableId != null ? this.physicalTableId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Output column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * OutputColumnProperty outputColumnProperty = OutputColumnProperty.builder()
     *         .description("description")
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.OutputColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description for a column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A display name for the dataset.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputColumnProperty> {
            java.lang.String description;
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link OutputColumnProperty#getDescription}
             * @param description A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getName}
             * @param name A display name for the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getType}
             * @param type Type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputColumnProperty {
            private final java.lang.String description;
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.name = builder.name;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.OutputColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputColumnProperty.Jsii$Proxy that = (OutputColumnProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A view of a data source that contains information about the shape of the data in the underlying source.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PhysicalTableProperty physicalTableProperty = PhysicalTableProperty.builder()
     *         .customSql(CustomSqlProperty.builder()
     *                 .columns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 .dataSourceArn("dataSourceArn")
     *                 .name("name")
     *                 .sqlQuery("sqlQuery")
     *                 .build())
     *         .relationalTable(RelationalTableProperty.builder()
     *                 .dataSourceArn("dataSourceArn")
     *                 .inputColumns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 .name("name")
     *                 // the properties below are optional
     *                 .catalog("catalog")
     *                 .schema("schema")
     *                 .build())
     *         .s3Source(S3SourceProperty.builder()
     *                 .dataSourceArn("dataSourceArn")
     *                 .inputColumns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 // the properties below are optional
     *                 .uploadSettings(UploadSettingsProperty.builder()
     *                         .containsHeader(false)
     *                         .delimiter("delimiter")
     *                         .format("format")
     *                         .startFromRow(123)
     *                         .textQualifier("textQualifier")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.PhysicalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(PhysicalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PhysicalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A physical table type built from the results of the custom SQL query.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomSql() {
            return null;
        }

        /**
         * A physical table type for relational data sources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelationalTable() {
            return null;
        }

        /**
         * A physical table type for as S3 data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Source() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PhysicalTableProperty> {
            java.lang.Object customSql;
            java.lang.Object relationalTable;
            java.lang.Object s3Source;

            /**
             * Sets the value of {@link PhysicalTableProperty#getCustomSql}
             * @param customSql A physical table type built from the results of the custom SQL query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customSql(software.amazon.awscdk.services.quicksight.CfnDataSet.CustomSqlProperty customSql) {
                this.customSql = customSql;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getCustomSql}
             * @param customSql A physical table type built from the results of the custom SQL query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customSql(software.amazon.awscdk.core.IResolvable customSql) {
                this.customSql = customSql;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getRelationalTable}
             * @param relationalTable A physical table type for relational data sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalTable(software.amazon.awscdk.services.quicksight.CfnDataSet.RelationalTableProperty relationalTable) {
                this.relationalTable = relationalTable;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getRelationalTable}
             * @param relationalTable A physical table type for relational data sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalTable(software.amazon.awscdk.core.IResolvable relationalTable) {
                this.relationalTable = relationalTable;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getS3Source}
             * @param s3Source A physical table type for as S3 data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Source(software.amazon.awscdk.services.quicksight.CfnDataSet.S3SourceProperty s3Source) {
                this.s3Source = s3Source;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getS3Source}
             * @param s3Source A physical table type for as S3 data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Source(software.amazon.awscdk.core.IResolvable s3Source) {
                this.s3Source = s3Source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PhysicalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PhysicalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhysicalTableProperty {
            private final java.lang.Object customSql;
            private final java.lang.Object relationalTable;
            private final java.lang.Object s3Source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customSql = software.amazon.jsii.Kernel.get(this, "customSql", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relationalTable = software.amazon.jsii.Kernel.get(this, "relationalTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Source = software.amazon.jsii.Kernel.get(this, "s3Source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customSql = builder.customSql;
                this.relationalTable = builder.relationalTable;
                this.s3Source = builder.s3Source;
            }

            @Override
            public final java.lang.Object getCustomSql() {
                return this.customSql;
            }

            @Override
            public final java.lang.Object getRelationalTable() {
                return this.relationalTable;
            }

            @Override
            public final java.lang.Object getS3Source() {
                return this.s3Source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomSql() != null) {
                    data.set("customSql", om.valueToTree(this.getCustomSql()));
                }
                if (this.getRelationalTable() != null) {
                    data.set("relationalTable", om.valueToTree(this.getRelationalTable()));
                }
                if (this.getS3Source() != null) {
                    data.set("s3Source", om.valueToTree(this.getS3Source()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.PhysicalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PhysicalTableProperty.Jsii$Proxy that = (PhysicalTableProperty.Jsii$Proxy) o;

                if (this.customSql != null ? !this.customSql.equals(that.customSql) : that.customSql != null) return false;
                if (this.relationalTable != null ? !this.relationalTable.equals(that.relationalTable) : that.relationalTable != null) return false;
                return this.s3Source != null ? this.s3Source.equals(that.s3Source) : that.s3Source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customSql != null ? this.customSql.hashCode() : 0;
                result = 31 * result + (this.relationalTable != null ? this.relationalTable.hashCode() : 0);
                result = 31 * result + (this.s3Source != null ? this.s3Source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that projects columns.
     * <p>
     * Operations that come after a projection can only refer to projected columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ProjectOperationProperty projectOperationProperty = ProjectOperationProperty.builder()
     *         .projectedColumns(List.of("projectedColumns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.ProjectOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Projected columns.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getProjectedColumns();

        /**
         * @return a {@link Builder} of {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectOperationProperty> {
            java.util.List<java.lang.String> projectedColumns;

            /**
             * Sets the value of {@link ProjectOperationProperty#getProjectedColumns}
             * @param projectedColumns Projected columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectedColumns(java.util.List<java.lang.String> projectedColumns) {
                this.projectedColumns = projectedColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectOperationProperty {
            private final java.util.List<java.lang.String> projectedColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.projectedColumns = software.amazon.jsii.Kernel.get(this, "projectedColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.projectedColumns = java.util.Objects.requireNonNull(builder.projectedColumns, "projectedColumns is required");
            }

            @Override
            public final java.util.List<java.lang.String> getProjectedColumns() {
                return this.projectedColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("projectedColumns", om.valueToTree(this.getProjectedColumns()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.ProjectOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectOperationProperty.Jsii$Proxy that = (ProjectOperationProperty.Jsii$Proxy) o;

                return this.projectedColumns.equals(that.projectedColumns);
            }

            @Override
            public final int hashCode() {
                int result = this.projectedColumns.hashCode();
                return result;
            }
        }
    }
    /**
     * A physical table type for relational data sources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RelationalTableProperty relationalTableProperty = RelationalTableProperty.builder()
     *         .dataSourceArn("dataSourceArn")
     *         .inputColumns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .name("name")
     *         // the properties below are optional
     *         .catalog("catalog")
     *         .schema("schema")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.RelationalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceArn();

        /**
         * The column schema of the table.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInputColumns();

        /**
         * The name of the relational table.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnDataSet.RelationalTableProperty.Catalog`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalog() {
            return null;
        }

        /**
         * The schema name.
         * <p>
         * This name applies to certain relational database engines.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchema() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationalTableProperty> {
            java.lang.String dataSourceArn;
            java.lang.Object inputColumns;
            java.lang.String name;
            java.lang.String catalog;
            java.lang.String schema;

            /**
             * Sets the value of {@link RelationalTableProperty#getDataSourceArn}
             * @param dataSourceArn The Amazon Resource Name (ARN) for the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceArn(java.lang.String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getInputColumns}
             * @param inputColumns The column schema of the table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(software.amazon.awscdk.core.IResolvable inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getInputColumns}
             * @param inputColumns The column schema of the table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(java.util.List<? extends java.lang.Object> inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getName}
             * @param name The name of the relational table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getCatalog}
             * @param catalog `CfnDataSet.RelationalTableProperty.Catalog`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.String catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getSchema}
             * @param schema The schema name.
             *               This name applies to certain relational database engines.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schema(java.lang.String schema) {
                this.schema = schema;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationalTableProperty {
            private final java.lang.String dataSourceArn;
            private final java.lang.Object inputColumns;
            private final java.lang.String name;
            private final java.lang.String catalog;
            private final java.lang.String schema;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceArn = software.amazon.jsii.Kernel.get(this, "dataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputColumns = software.amazon.jsii.Kernel.get(this, "inputColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceArn = java.util.Objects.requireNonNull(builder.dataSourceArn, "dataSourceArn is required");
                this.inputColumns = java.util.Objects.requireNonNull(builder.inputColumns, "inputColumns is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.catalog = builder.catalog;
                this.schema = builder.schema;
            }

            @Override
            public final java.lang.String getDataSourceArn() {
                return this.dataSourceArn;
            }

            @Override
            public final java.lang.Object getInputColumns() {
                return this.inputColumns;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.String getSchema() {
                return this.schema;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceArn", om.valueToTree(this.getDataSourceArn()));
                data.set("inputColumns", om.valueToTree(this.getInputColumns()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getCatalog() != null) {
                    data.set("catalog", om.valueToTree(this.getCatalog()));
                }
                if (this.getSchema() != null) {
                    data.set("schema", om.valueToTree(this.getSchema()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.RelationalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationalTableProperty.Jsii$Proxy that = (RelationalTableProperty.Jsii$Proxy) o;

                if (!dataSourceArn.equals(that.dataSourceArn)) return false;
                if (!inputColumns.equals(that.inputColumns)) return false;
                if (!name.equals(that.name)) return false;
                if (this.catalog != null ? !this.catalog.equals(that.catalog) : that.catalog != null) return false;
                return this.schema != null ? this.schema.equals(that.schema) : that.schema == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceArn.hashCode();
                result = 31 * result + (this.inputColumns.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
                result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that renames a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RenameColumnOperationProperty renameColumnOperationProperty = RenameColumnOperationProperty.builder()
     *         .columnName("columnName")
     *         .newColumnName("newColumnName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.RenameColumnOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(RenameColumnOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenameColumnOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column to be renamed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The new name for the column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnName();

        /**
         * @return a {@link Builder} of {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenameColumnOperationProperty> {
            java.lang.String columnName;
            java.lang.String newColumnName;

            /**
             * Sets the value of {@link RenameColumnOperationProperty#getColumnName}
             * @param columnName The name of the column to be renamed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link RenameColumnOperationProperty#getNewColumnName}
             * @param newColumnName The new name for the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnName(java.lang.String newColumnName) {
                this.newColumnName = newColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenameColumnOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenameColumnOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenameColumnOperationProperty {
            private final java.lang.String columnName;
            private final java.lang.String newColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnName = software.amazon.jsii.Kernel.get(this, "newColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.newColumnName = java.util.Objects.requireNonNull(builder.newColumnName, "newColumnName is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getNewColumnName() {
                return this.newColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("newColumnName", om.valueToTree(this.getNewColumnName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.RenameColumnOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenameColumnOperationProperty.Jsii$Proxy that = (RenameColumnOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.newColumnName.equals(that.newColumnName);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.newColumnName.hashCode());
                return result;
            }
        }
    }
    /**
     * Permission for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
     *         .actions(List.of("actions"))
     *         .principal("principal")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM action to grand or revoke permisions on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         * <p>
         * <ul>
         * <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
         * <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
         * <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

        /**
         * @return a {@link Builder} of {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.String principal;

            /**
             * Sets the value of {@link ResourcePermissionProperty#getActions}
             * @param actions The IAM action to grand or revoke permisions on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getPrincipal}
             * @param principal The Amazon Resource Name (ARN) of the principal. This can be one of the following:. This parameter is required.
             *                  <ul>
             *                  <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
             *                  <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
             *                  <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(java.lang.String principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePermissionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.String principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.ResourcePermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePermissionProperty.Jsii$Proxy that = (ResourcePermissionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.principal.equals(that.principal);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about a dataset that contains permissions for row-level security (RLS).
     * <p>
     * The permissions dataset maps fields to users or groups. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <em>Amazon QuickSight User Guide</em> .
     * <p>
     * The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is not supported for new RLS datasets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RowLevelPermissionDataSetProperty rowLevelPermissionDataSetProperty = RowLevelPermissionDataSetProperty.builder()
     *         .arn("arn")
     *         .permissionPolicy("permissionPolicy")
     *         // the properties below are optional
     *         .formatVersion("formatVersion")
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.RowLevelPermissionDataSetProperty")
    @software.amazon.jsii.Jsii.Proxy(RowLevelPermissionDataSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RowLevelPermissionDataSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The type of permissions to use when interpreting the permissions for RLS.
         * <p>
         * <code>DENY_ACCESS</code> is included for backward compatibility only.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPermissionPolicy();

        /**
         * The user or group rules associated with the dataset that contains permissions for RLS.
         * <p>
         * By default, <code>FormatVersion</code> is <code>VERSION_1</code> . When <code>FormatVersion</code> is <code>VERSION_1</code> , <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code> , <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormatVersion() {
            return null;
        }

        /**
         * The namespace associated with the dataset that contains permissions for RLS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RowLevelPermissionDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RowLevelPermissionDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RowLevelPermissionDataSetProperty> {
            java.lang.String arn;
            java.lang.String permissionPolicy;
            java.lang.String formatVersion;
            java.lang.String namespace;

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getPermissionPolicy}
             * @param permissionPolicy The type of permissions to use when interpreting the permissions for RLS. This parameter is required.
             *                         <code>DENY_ACCESS</code> is included for backward compatibility only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permissionPolicy(java.lang.String permissionPolicy) {
                this.permissionPolicy = permissionPolicy;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getFormatVersion}
             * @param formatVersion The user or group rules associated with the dataset that contains permissions for RLS.
             *                      By default, <code>FormatVersion</code> is <code>VERSION_1</code> . When <code>FormatVersion</code> is <code>VERSION_1</code> , <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code> , <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatVersion(java.lang.String formatVersion) {
                this.formatVersion = formatVersion;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getNamespace}
             * @param namespace The namespace associated with the dataset that contains permissions for RLS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RowLevelPermissionDataSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RowLevelPermissionDataSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RowLevelPermissionDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RowLevelPermissionDataSetProperty {
            private final java.lang.String arn;
            private final java.lang.String permissionPolicy;
            private final java.lang.String formatVersion;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permissionPolicy = software.amazon.jsii.Kernel.get(this, "permissionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.formatVersion = software.amazon.jsii.Kernel.get(this, "formatVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.permissionPolicy = java.util.Objects.requireNonNull(builder.permissionPolicy, "permissionPolicy is required");
                this.formatVersion = builder.formatVersion;
                this.namespace = builder.namespace;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getPermissionPolicy() {
                return this.permissionPolicy;
            }

            @Override
            public final java.lang.String getFormatVersion() {
                return this.formatVersion;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("permissionPolicy", om.valueToTree(this.getPermissionPolicy()));
                if (this.getFormatVersion() != null) {
                    data.set("formatVersion", om.valueToTree(this.getFormatVersion()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.RowLevelPermissionDataSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RowLevelPermissionDataSetProperty.Jsii$Proxy that = (RowLevelPermissionDataSetProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                if (!permissionPolicy.equals(that.permissionPolicy)) return false;
                if (this.formatVersion != null ? !this.formatVersion.equals(that.formatVersion) : that.formatVersion != null) return false;
                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.permissionPolicy.hashCode());
                result = 31 * result + (this.formatVersion != null ? this.formatVersion.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A physical table type for an S3 data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * S3SourceProperty s3SourceProperty = S3SourceProperty.builder()
     *         .dataSourceArn("dataSourceArn")
     *         .inputColumns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         // the properties below are optional
     *         .uploadSettings(UploadSettingsProperty.builder()
     *                 .containsHeader(false)
     *                 .delimiter("delimiter")
     *                 .format("format")
     *                 .startFromRow(123)
     *                 .textQualifier("textQualifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.S3SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceArn();

        /**
         * A physical table type for an S3 data source.
         * <p>
         * <blockquote>
         * <p>
         * For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInputColumns();

        /**
         * Information about the format for the S3 source file or files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUploadSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SourceProperty> {
            java.lang.String dataSourceArn;
            java.lang.Object inputColumns;
            java.lang.Object uploadSettings;

            /**
             * Sets the value of {@link S3SourceProperty#getDataSourceArn}
             * @param dataSourceArn The Amazon Resource Name (ARN) for the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceArn(java.lang.String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceProperty#getInputColumns}
             * @param inputColumns A physical table type for an S3 data source. This parameter is required.
             *                     <blockquote>
             *                     <p>
             *                     For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(software.amazon.awscdk.core.IResolvable inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceProperty#getInputColumns}
             * @param inputColumns A physical table type for an S3 data source. This parameter is required.
             *                     <blockquote>
             *                     <p>
             *                     For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(java.util.List<? extends java.lang.Object> inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceProperty#getUploadSettings}
             * @param uploadSettings Information about the format for the S3 source file or files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uploadSettings(software.amazon.awscdk.services.quicksight.CfnDataSet.UploadSettingsProperty uploadSettings) {
                this.uploadSettings = uploadSettings;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceProperty#getUploadSettings}
             * @param uploadSettings Information about the format for the S3 source file or files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uploadSettings(software.amazon.awscdk.core.IResolvable uploadSettings) {
                this.uploadSettings = uploadSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourceProperty {
            private final java.lang.String dataSourceArn;
            private final java.lang.Object inputColumns;
            private final java.lang.Object uploadSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceArn = software.amazon.jsii.Kernel.get(this, "dataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputColumns = software.amazon.jsii.Kernel.get(this, "inputColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uploadSettings = software.amazon.jsii.Kernel.get(this, "uploadSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceArn = java.util.Objects.requireNonNull(builder.dataSourceArn, "dataSourceArn is required");
                this.inputColumns = java.util.Objects.requireNonNull(builder.inputColumns, "inputColumns is required");
                this.uploadSettings = builder.uploadSettings;
            }

            @Override
            public final java.lang.String getDataSourceArn() {
                return this.dataSourceArn;
            }

            @Override
            public final java.lang.Object getInputColumns() {
                return this.inputColumns;
            }

            @Override
            public final java.lang.Object getUploadSettings() {
                return this.uploadSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceArn", om.valueToTree(this.getDataSourceArn()));
                data.set("inputColumns", om.valueToTree(this.getInputColumns()));
                if (this.getUploadSettings() != null) {
                    data.set("uploadSettings", om.valueToTree(this.getUploadSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.S3SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SourceProperty.Jsii$Proxy that = (S3SourceProperty.Jsii$Proxy) o;

                if (!dataSourceArn.equals(that.dataSourceArn)) return false;
                if (!inputColumns.equals(that.inputColumns)) return false;
                return this.uploadSettings != null ? this.uploadSettings.equals(that.uploadSettings) : that.uploadSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceArn.hashCode();
                result = 31 * result + (this.inputColumns.hashCode());
                result = 31 * result + (this.uploadSettings != null ? this.uploadSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that tags a column with additional information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TagColumnOperationProperty tagColumnOperationProperty = TagColumnOperationProperty.builder()
     *         .columnName("columnName")
     *         .tags(List.of(ColumnTagProperty.builder()
     *                 .columnDescription(ColumnDescriptionProperty.builder()
     *                         .text("text")
     *                         .build())
     *                 .columnGeographicRole("columnGeographicRole")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.TagColumnOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagColumnOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagColumnOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column that this operation acts on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The dataset column tag, currently only used for geospatial type tagging.
         * <p>
         * <blockquote>
         * <p>
         * This is not tags for the AWS tagging feature.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> getTags();

        /**
         * @return a {@link Builder} of {@link TagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagColumnOperationProperty> {
            java.lang.String columnName;
            java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> tags;

            /**
             * Sets the value of {@link TagColumnOperationProperty#getColumnName}
             * @param columnName The column that this operation acts on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link TagColumnOperationProperty#getTags}
             * @param tags The dataset column tag, currently only used for geospatial type tagging. This parameter is required.
             *             <blockquote>
             *             <p>
             *             This is not tags for the AWS tagging feature.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagColumnOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagColumnOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagColumnOperationProperty {
            private final java.lang.String columnName;
            private final java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.tags = (java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty>)java.util.Objects.requireNonNull(builder.tags, "tags is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("tags", om.valueToTree(this.getTags()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.TagColumnOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagColumnOperationProperty.Jsii$Proxy that = (TagColumnOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.tags.equals(that.tags);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.tags.hashCode());
                return result;
            }
        }
    }
    /**
     * A data transformation on a logical table.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TransformOperationProperty transformOperationProperty = TransformOperationProperty.builder()
     *         .castColumnTypeOperation(CastColumnTypeOperationProperty.builder()
     *                 .columnName("columnName")
     *                 .newColumnType("newColumnType")
     *                 // the properties below are optional
     *                 .format("format")
     *                 .build())
     *         .createColumnsOperation(CreateColumnsOperationProperty.builder()
     *                 .columns(List.of(CalculatedColumnProperty.builder()
     *                         .columnId("columnId")
     *                         .columnName("columnName")
     *                         .expression("expression")
     *                         .build()))
     *                 .build())
     *         .filterOperation(FilterOperationProperty.builder()
     *                 .conditionExpression("conditionExpression")
     *                 .build())
     *         .projectOperation(ProjectOperationProperty.builder()
     *                 .projectedColumns(List.of("projectedColumns"))
     *                 .build())
     *         .renameColumnOperation(RenameColumnOperationProperty.builder()
     *                 .columnName("columnName")
     *                 .newColumnName("newColumnName")
     *                 .build())
     *         .tagColumnOperation(TagColumnOperationProperty.builder()
     *                 .columnName("columnName")
     *                 .tags(List.of(ColumnTagProperty.builder()
     *                         .columnDescription(ColumnDescriptionProperty.builder()
     *                                 .text("text")
     *                                 .build())
     *                         .columnGeographicRole("columnGeographicRole")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.TransformOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A transform operation that casts a column to a different type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCastColumnTypeOperation() {
            return null;
        }

        /**
         * An operation that creates calculated columns.
         * <p>
         * Columns created in one such operation form a lexical closure.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateColumnsOperation() {
            return null;
        }

        /**
         * An operation that filters rows based on some condition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterOperation() {
            return null;
        }

        /**
         * An operation that projects columns.
         * <p>
         * Operations that come after a projection can only refer to projected columns.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProjectOperation() {
            return null;
        }

        /**
         * An operation that renames a column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRenameColumnOperation() {
            return null;
        }

        /**
         * An operation that tags a column with additional information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagColumnOperation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransformOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformOperationProperty> {
            java.lang.Object castColumnTypeOperation;
            java.lang.Object createColumnsOperation;
            java.lang.Object filterOperation;
            java.lang.Object projectOperation;
            java.lang.Object renameColumnOperation;
            java.lang.Object tagColumnOperation;

            /**
             * Sets the value of {@link TransformOperationProperty#getCastColumnTypeOperation}
             * @param castColumnTypeOperation A transform operation that casts a column to a different type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder castColumnTypeOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.CastColumnTypeOperationProperty castColumnTypeOperation) {
                this.castColumnTypeOperation = castColumnTypeOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getCastColumnTypeOperation}
             * @param castColumnTypeOperation A transform operation that casts a column to a different type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder castColumnTypeOperation(software.amazon.awscdk.core.IResolvable castColumnTypeOperation) {
                this.castColumnTypeOperation = castColumnTypeOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getCreateColumnsOperation}
             * @param createColumnsOperation An operation that creates calculated columns.
             *                               Columns created in one such operation form a lexical closure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createColumnsOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.CreateColumnsOperationProperty createColumnsOperation) {
                this.createColumnsOperation = createColumnsOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getCreateColumnsOperation}
             * @param createColumnsOperation An operation that creates calculated columns.
             *                               Columns created in one such operation form a lexical closure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createColumnsOperation(software.amazon.awscdk.core.IResolvable createColumnsOperation) {
                this.createColumnsOperation = createColumnsOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getFilterOperation}
             * @param filterOperation An operation that filters rows based on some condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.FilterOperationProperty filterOperation) {
                this.filterOperation = filterOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getFilterOperation}
             * @param filterOperation An operation that filters rows based on some condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterOperation(software.amazon.awscdk.core.IResolvable filterOperation) {
                this.filterOperation = filterOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getProjectOperation}
             * @param projectOperation An operation that projects columns.
             *                         Operations that come after a projection can only refer to projected columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.ProjectOperationProperty projectOperation) {
                this.projectOperation = projectOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getProjectOperation}
             * @param projectOperation An operation that projects columns.
             *                         Operations that come after a projection can only refer to projected columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectOperation(software.amazon.awscdk.core.IResolvable projectOperation) {
                this.projectOperation = projectOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getRenameColumnOperation}
             * @param renameColumnOperation An operation that renames a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameColumnOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.RenameColumnOperationProperty renameColumnOperation) {
                this.renameColumnOperation = renameColumnOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getRenameColumnOperation}
             * @param renameColumnOperation An operation that renames a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameColumnOperation(software.amazon.awscdk.core.IResolvable renameColumnOperation) {
                this.renameColumnOperation = renameColumnOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getTagColumnOperation}
             * @param tagColumnOperation An operation that tags a column with additional information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagColumnOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.TagColumnOperationProperty tagColumnOperation) {
                this.tagColumnOperation = tagColumnOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getTagColumnOperation}
             * @param tagColumnOperation An operation that tags a column with additional information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagColumnOperation(software.amazon.awscdk.core.IResolvable tagColumnOperation) {
                this.tagColumnOperation = tagColumnOperation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformOperationProperty {
            private final java.lang.Object castColumnTypeOperation;
            private final java.lang.Object createColumnsOperation;
            private final java.lang.Object filterOperation;
            private final java.lang.Object projectOperation;
            private final java.lang.Object renameColumnOperation;
            private final java.lang.Object tagColumnOperation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.castColumnTypeOperation = software.amazon.jsii.Kernel.get(this, "castColumnTypeOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createColumnsOperation = software.amazon.jsii.Kernel.get(this, "createColumnsOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterOperation = software.amazon.jsii.Kernel.get(this, "filterOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.projectOperation = software.amazon.jsii.Kernel.get(this, "projectOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.renameColumnOperation = software.amazon.jsii.Kernel.get(this, "renameColumnOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagColumnOperation = software.amazon.jsii.Kernel.get(this, "tagColumnOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.castColumnTypeOperation = builder.castColumnTypeOperation;
                this.createColumnsOperation = builder.createColumnsOperation;
                this.filterOperation = builder.filterOperation;
                this.projectOperation = builder.projectOperation;
                this.renameColumnOperation = builder.renameColumnOperation;
                this.tagColumnOperation = builder.tagColumnOperation;
            }

            @Override
            public final java.lang.Object getCastColumnTypeOperation() {
                return this.castColumnTypeOperation;
            }

            @Override
            public final java.lang.Object getCreateColumnsOperation() {
                return this.createColumnsOperation;
            }

            @Override
            public final java.lang.Object getFilterOperation() {
                return this.filterOperation;
            }

            @Override
            public final java.lang.Object getProjectOperation() {
                return this.projectOperation;
            }

            @Override
            public final java.lang.Object getRenameColumnOperation() {
                return this.renameColumnOperation;
            }

            @Override
            public final java.lang.Object getTagColumnOperation() {
                return this.tagColumnOperation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCastColumnTypeOperation() != null) {
                    data.set("castColumnTypeOperation", om.valueToTree(this.getCastColumnTypeOperation()));
                }
                if (this.getCreateColumnsOperation() != null) {
                    data.set("createColumnsOperation", om.valueToTree(this.getCreateColumnsOperation()));
                }
                if (this.getFilterOperation() != null) {
                    data.set("filterOperation", om.valueToTree(this.getFilterOperation()));
                }
                if (this.getProjectOperation() != null) {
                    data.set("projectOperation", om.valueToTree(this.getProjectOperation()));
                }
                if (this.getRenameColumnOperation() != null) {
                    data.set("renameColumnOperation", om.valueToTree(this.getRenameColumnOperation()));
                }
                if (this.getTagColumnOperation() != null) {
                    data.set("tagColumnOperation", om.valueToTree(this.getTagColumnOperation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.TransformOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformOperationProperty.Jsii$Proxy that = (TransformOperationProperty.Jsii$Proxy) o;

                if (this.castColumnTypeOperation != null ? !this.castColumnTypeOperation.equals(that.castColumnTypeOperation) : that.castColumnTypeOperation != null) return false;
                if (this.createColumnsOperation != null ? !this.createColumnsOperation.equals(that.createColumnsOperation) : that.createColumnsOperation != null) return false;
                if (this.filterOperation != null ? !this.filterOperation.equals(that.filterOperation) : that.filterOperation != null) return false;
                if (this.projectOperation != null ? !this.projectOperation.equals(that.projectOperation) : that.projectOperation != null) return false;
                if (this.renameColumnOperation != null ? !this.renameColumnOperation.equals(that.renameColumnOperation) : that.renameColumnOperation != null) return false;
                return this.tagColumnOperation != null ? this.tagColumnOperation.equals(that.tagColumnOperation) : that.tagColumnOperation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.castColumnTypeOperation != null ? this.castColumnTypeOperation.hashCode() : 0;
                result = 31 * result + (this.createColumnsOperation != null ? this.createColumnsOperation.hashCode() : 0);
                result = 31 * result + (this.filterOperation != null ? this.filterOperation.hashCode() : 0);
                result = 31 * result + (this.projectOperation != null ? this.projectOperation.hashCode() : 0);
                result = 31 * result + (this.renameColumnOperation != null ? this.renameColumnOperation.hashCode() : 0);
                result = 31 * result + (this.tagColumnOperation != null ? this.tagColumnOperation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the format for a source file or files.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * UploadSettingsProperty uploadSettingsProperty = UploadSettingsProperty.builder()
     *         .containsHeader(false)
     *         .delimiter("delimiter")
     *         .format("format")
     *         .startFromRow(123)
     *         .textQualifier("textQualifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnDataSet.UploadSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(UploadSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UploadSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether the file has a header row, or the files each have a header row.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainsHeader() {
            return null;
        }

        /**
         * The delimiter between values in the file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * File format.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * A row number to start reading data from.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartFromRow() {
            return null;
        }

        /**
         * Text qualifier.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextQualifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UploadSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UploadSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UploadSettingsProperty> {
            java.lang.Object containsHeader;
            java.lang.String delimiter;
            java.lang.String format;
            java.lang.Number startFromRow;
            java.lang.String textQualifier;

            /**
             * Sets the value of {@link UploadSettingsProperty#getContainsHeader}
             * @param containsHeader Whether the file has a header row, or the files each have a header row.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsHeader(java.lang.Boolean containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getContainsHeader}
             * @param containsHeader Whether the file has a header row, or the files each have a header row.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsHeader(software.amazon.awscdk.core.IResolvable containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getDelimiter}
             * @param delimiter The delimiter between values in the file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getFormat}
             * @param format File format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getStartFromRow}
             * @param startFromRow A row number to start reading data from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startFromRow(java.lang.Number startFromRow) {
                this.startFromRow = startFromRow;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getTextQualifier}
             * @param textQualifier Text qualifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textQualifier(java.lang.String textQualifier) {
                this.textQualifier = textQualifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UploadSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UploadSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UploadSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UploadSettingsProperty {
            private final java.lang.Object containsHeader;
            private final java.lang.String delimiter;
            private final java.lang.String format;
            private final java.lang.Number startFromRow;
            private final java.lang.String textQualifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containsHeader = software.amazon.jsii.Kernel.get(this, "containsHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startFromRow = software.amazon.jsii.Kernel.get(this, "startFromRow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.textQualifier = software.amazon.jsii.Kernel.get(this, "textQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containsHeader = builder.containsHeader;
                this.delimiter = builder.delimiter;
                this.format = builder.format;
                this.startFromRow = builder.startFromRow;
                this.textQualifier = builder.textQualifier;
            }

            @Override
            public final java.lang.Object getContainsHeader() {
                return this.containsHeader;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.Number getStartFromRow() {
                return this.startFromRow;
            }

            @Override
            public final java.lang.String getTextQualifier() {
                return this.textQualifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainsHeader() != null) {
                    data.set("containsHeader", om.valueToTree(this.getContainsHeader()));
                }
                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }
                if (this.getStartFromRow() != null) {
                    data.set("startFromRow", om.valueToTree(this.getStartFromRow()));
                }
                if (this.getTextQualifier() != null) {
                    data.set("textQualifier", om.valueToTree(this.getTextQualifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnDataSet.UploadSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UploadSettingsProperty.Jsii$Proxy that = (UploadSettingsProperty.Jsii$Proxy) o;

                if (this.containsHeader != null ? !this.containsHeader.equals(that.containsHeader) : that.containsHeader != null) return false;
                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
                if (this.startFromRow != null ? !this.startFromRow.equals(that.startFromRow) : that.startFromRow != null) return false;
                return this.textQualifier != null ? this.textQualifier.equals(that.textQualifier) : that.textQualifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containsHeader != null ? this.containsHeader.hashCode() : 0;
                result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                result = 31 * result + (this.startFromRow != null ? this.startFromRow.hashCode() : 0);
                result = 31 * result + (this.textQualifier != null ? this.textQualifier.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnDataSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnDataSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.quicksight.CfnDataSetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The AWS account ID.
         * <p>
         * @return {@code this}
         * @param awsAccountId The AWS account ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props().awsAccountId(awsAccountId);
            return this;
        }

        /**
         * Groupings of columns that work together in certain Amazon QuickSight features.
         * <p>
         * Currently, only geospatial hierarchy is supported.
         * <p>
         * @return {@code this}
         * @param columnGroups Groupings of columns that work together in certain Amazon QuickSight features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnGroups(final software.amazon.awscdk.core.IResolvable columnGroups) {
            this.props().columnGroups(columnGroups);
            return this;
        }
        /**
         * Groupings of columns that work together in certain Amazon QuickSight features.
         * <p>
         * Currently, only geospatial hierarchy is supported.
         * <p>
         * @return {@code this}
         * @param columnGroups Groupings of columns that work together in certain Amazon QuickSight features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnGroups(final java.util.List<? extends java.lang.Object> columnGroups) {
            this.props().columnGroups(columnGroups);
            return this;
        }

        /**
         * A set of one or more definitions of a `ColumnLevelPermissionRule` .
         * <p>
         * @return {@code this}
         * @param columnLevelPermissionRules A set of one or more definitions of a `ColumnLevelPermissionRule` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnLevelPermissionRules(final software.amazon.awscdk.core.IResolvable columnLevelPermissionRules) {
            this.props().columnLevelPermissionRules(columnLevelPermissionRules);
            return this;
        }
        /**
         * A set of one or more definitions of a `ColumnLevelPermissionRule` .
         * <p>
         * @return {@code this}
         * @param columnLevelPermissionRules A set of one or more definitions of a `ColumnLevelPermissionRule` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnLevelPermissionRules(final java.util.List<? extends java.lang.Object> columnLevelPermissionRules) {
            this.props().columnLevelPermissionRules(columnLevelPermissionRules);
            return this;
        }

        /**
         * An ID for the dataset that you want to create.
         * <p>
         * This ID is unique per AWS Region for each AWS account.
         * <p>
         * @return {@code this}
         * @param dataSetId An ID for the dataset that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetId(final java.lang.String dataSetId) {
            this.props().dataSetId(dataSetId);
            return this;
        }

        /**
         * The usage configuration to apply to child datasets that reference this dataset as a source.
         * <p>
         * @return {@code this}
         * @param dataSetUsageConfiguration The usage configuration to apply to child datasets that reference this dataset as a source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetUsageConfiguration(final software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetUsageConfigurationProperty dataSetUsageConfiguration) {
            this.props().dataSetUsageConfiguration(dataSetUsageConfiguration);
            return this;
        }
        /**
         * The usage configuration to apply to child datasets that reference this dataset as a source.
         * <p>
         * @return {@code this}
         * @param dataSetUsageConfiguration The usage configuration to apply to child datasets that reference this dataset as a source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetUsageConfiguration(final software.amazon.awscdk.core.IResolvable dataSetUsageConfiguration) {
            this.props().dataSetUsageConfiguration(dataSetUsageConfiguration);
            return this;
        }

        /**
         * The folder that contains fields and nested subfolders for your dataset.
         * <p>
         * @return {@code this}
         * @param fieldFolders The folder that contains fields and nested subfolders for your dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldFolders(final software.amazon.awscdk.core.IResolvable fieldFolders) {
            this.props().fieldFolders(fieldFolders);
            return this;
        }
        /**
         * The folder that contains fields and nested subfolders for your dataset.
         * <p>
         * @return {@code this}
         * @param fieldFolders The folder that contains fields and nested subfolders for your dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldFolders(final java.util.Map<java.lang.String, ? extends java.lang.Object> fieldFolders) {
            this.props().fieldFolders(fieldFolders);
            return this;
        }

        /**
         * Indicates whether you want to import the data into SPICE.
         * <p>
         * @return {@code this}
         * @param importMode Indicates whether you want to import the data into SPICE. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importMode(final java.lang.String importMode) {
            this.props().importMode(importMode);
            return this;
        }

        /**
         * The wait policy to use when creating or updating a Dataset.
         * <p>
         * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
         * <p>
         * @return {@code this}
         * @param ingestionWaitPolicy The wait policy to use when creating or updating a Dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionWaitPolicy(final software.amazon.awscdk.services.quicksight.CfnDataSet.IngestionWaitPolicyProperty ingestionWaitPolicy) {
            this.props().ingestionWaitPolicy(ingestionWaitPolicy);
            return this;
        }
        /**
         * The wait policy to use when creating or updating a Dataset.
         * <p>
         * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
         * <p>
         * @return {@code this}
         * @param ingestionWaitPolicy The wait policy to use when creating or updating a Dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionWaitPolicy(final software.amazon.awscdk.core.IResolvable ingestionWaitPolicy) {
            this.props().ingestionWaitPolicy(ingestionWaitPolicy);
            return this;
        }

        /**
         * Configures the combination and transformation of the data from the physical tables.
         * <p>
         * @return {@code this}
         * @param logicalTableMap Configures the combination and transformation of the data from the physical tables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logicalTableMap(final software.amazon.awscdk.core.IResolvable logicalTableMap) {
            this.props().logicalTableMap(logicalTableMap);
            return this;
        }
        /**
         * Configures the combination and transformation of the data from the physical tables.
         * <p>
         * @return {@code this}
         * @param logicalTableMap Configures the combination and transformation of the data from the physical tables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logicalTableMap(final java.util.Map<java.lang.String, ? extends java.lang.Object> logicalTableMap) {
            this.props().logicalTableMap(logicalTableMap);
            return this;
        }

        /**
         * The display name for the dataset.
         * <p>
         * @return {@code this}
         * @param name The display name for the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * A list of resource permissions on the dataset.
         * <p>
         * @return {@code this}
         * @param permissions A list of resource permissions on the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final software.amazon.awscdk.core.IResolvable permissions) {
            this.props().permissions(permissions);
            return this;
        }
        /**
         * A list of resource permissions on the dataset.
         * <p>
         * @return {@code this}
         * @param permissions A list of resource permissions on the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<? extends java.lang.Object> permissions) {
            this.props().permissions(permissions);
            return this;
        }

        /**
         * Declares the physical tables that are available in the underlying data sources.
         * <p>
         * @return {@code this}
         * @param physicalTableMap Declares the physical tables that are available in the underlying data sources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalTableMap(final software.amazon.awscdk.core.IResolvable physicalTableMap) {
            this.props().physicalTableMap(physicalTableMap);
            return this;
        }
        /**
         * Declares the physical tables that are available in the underlying data sources.
         * <p>
         * @return {@code this}
         * @param physicalTableMap Declares the physical tables that are available in the underlying data sources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalTableMap(final java.util.Map<java.lang.String, ? extends java.lang.Object> physicalTableMap) {
            this.props().physicalTableMap(physicalTableMap);
            return this;
        }

        /**
         * The row-level security configuration for the data that you want to create.
         * <p>
         * @return {@code this}
         * @param rowLevelPermissionDataSet The row-level security configuration for the data that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionDataSet(final software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty rowLevelPermissionDataSet) {
            this.props().rowLevelPermissionDataSet(rowLevelPermissionDataSet);
            return this;
        }
        /**
         * The row-level security configuration for the data that you want to create.
         * <p>
         * @return {@code this}
         * @param rowLevelPermissionDataSet The row-level security configuration for the data that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionDataSet(final software.amazon.awscdk.core.IResolvable rowLevelPermissionDataSet) {
            this.props().rowLevelPermissionDataSet(rowLevelPermissionDataSet);
            return this;
        }

        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         * <p>
         * @return {@code this}
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnDataSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnDataSet build() {
            return new software.amazon.awscdk.services.quicksight.CfnDataSet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.quicksight.CfnDataSetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.quicksight.CfnDataSetProps.Builder();
            }
            return this.props;
        }
    }
}
