package software.amazon.awscdk.services.quicksight;

/**
 * A CloudFormation `AWS::QuickSight::Template`.
 * <p>
 * Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard.
 * <p>
 * A <em>template</em> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnTemplate cfnTemplate = CfnTemplate.Builder.create(this, "MyCfnTemplate")
 *         .awsAccountId("awsAccountId")
 *         .sourceEntity(TemplateSourceEntityProperty.builder()
 *                 .sourceAnalysis(TemplateSourceAnalysisProperty.builder()
 *                         .arn("arn")
 *                         .dataSetReferences(List.of(DataSetReferenceProperty.builder()
 *                                 .dataSetArn("dataSetArn")
 *                                 .dataSetPlaceholder("dataSetPlaceholder")
 *                                 .build()))
 *                         .build())
 *                 .sourceTemplate(TemplateSourceTemplateProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .build())
 *         .templateId("templateId")
 *         // the properties below are optional
 *         .name("name")
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .versionDescription("versionDescription")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:07.937Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate")
public class CfnTemplate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::QuickSight::Template`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time this template was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time this template was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrVersionDataSetConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionDataSetConfigurations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrVersionErrors() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrVersionSheets() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionSheets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionSourceEntityArn() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionSourceEntityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionThemeArn() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionThemeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrVersionVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionVersionNumber", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The ID for the AWS account that the group is in.
     * <p>
     * You use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID for the AWS account that the group is in.
     * <p>
     * You use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", java.util.Objects.requireNonNull(value, "awsAccountId is required"));
    }

    /**
     * The entity that you are using as a source when you create the template.
     * <p>
     * In <code>SourceEntity</code> , you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code> , specify the ARN of the source template. For <code>SourceAnalysis</code> , specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any AWS account and any Amazon QuickSight-supported AWS Region .
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSourceEntity() {
        return software.amazon.jsii.Kernel.get(this, "sourceEntity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The entity that you are using as a source when you create the template.
     * <p>
     * In <code>SourceEntity</code> , you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code> , specify the ARN of the source template. For <code>SourceAnalysis</code> , specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any AWS account and any Amazon QuickSight-supported AWS Region .
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEntity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnTemplate.TemplateSourceEntityProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceEntity", java.util.Objects.requireNonNull(value, "sourceEntity is required"));
    }

    /**
     * The entity that you are using as a source when you create the template.
     * <p>
     * In <code>SourceEntity</code> , you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code> , specify the ARN of the source template. For <code>SourceAnalysis</code> , specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any AWS account and any Amazon QuickSight-supported AWS Region .
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceEntity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceEntity", java.util.Objects.requireNonNull(value, "sourceEntity is required"));
    }

    /**
     * An ID for the template that you want to create.
     * <p>
     * This template is unique per AWS Region ; in each AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateId() {
        return software.amazon.jsii.Kernel.get(this, "templateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An ID for the template that you want to create.
     * <p>
     * This template is unique per AWS Region ; in each AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateId", java.util.Objects.requireNonNull(value, "templateId is required"));
    }

    /**
     * A display name for the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A display name for the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A list of resource permissions to be set on the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of resource permissions to be set on the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A list of resource permissions to be set on the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnTemplate.ResourcePermissionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnTemplate.ResourcePermissionProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A description of the current template version being created.
     * <p>
     * This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the current template version being created.
     * <p>
     * This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionDescription", value);
    }
    /**
     * A structure describing the name, data type, and geographic role of the columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnGroupColumnSchemaProperty columnGroupColumnSchemaProperty = ColumnGroupColumnSchemaProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.ColumnGroupColumnSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnGroupColumnSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnGroupColumnSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column group's column schema.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnGroupColumnSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnGroupColumnSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnGroupColumnSchemaProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link ColumnGroupColumnSchemaProperty#getName}
             * @param name The name of the column group's column schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnGroupColumnSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnGroupColumnSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnGroupColumnSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnGroupColumnSchemaProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.ColumnGroupColumnSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnGroupColumnSchemaProperty.Jsii$Proxy that = (ColumnGroupColumnSchemaProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The column group schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnGroupSchemaProperty columnGroupSchemaProperty = ColumnGroupSchemaProperty.builder()
     *         .columnGroupColumnSchemaList(List.of(ColumnGroupColumnSchemaProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.ColumnGroupSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnGroupSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnGroupSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure containing the list of schemas for column group columns.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnGroupColumnSchemaList() {
            return null;
        }

        /**
         * The name of the column group schema.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnGroupSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnGroupSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnGroupSchemaProperty> {
            java.lang.Object columnGroupColumnSchemaList;
            java.lang.String name;

            /**
             * Sets the value of {@link ColumnGroupSchemaProperty#getColumnGroupColumnSchemaList}
             * @param columnGroupColumnSchemaList A structure containing the list of schemas for column group columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnGroupColumnSchemaList(software.amazon.awscdk.core.IResolvable columnGroupColumnSchemaList) {
                this.columnGroupColumnSchemaList = columnGroupColumnSchemaList;
                return this;
            }

            /**
             * Sets the value of {@link ColumnGroupSchemaProperty#getColumnGroupColumnSchemaList}
             * @param columnGroupColumnSchemaList A structure containing the list of schemas for column group columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnGroupColumnSchemaList(java.util.List<? extends java.lang.Object> columnGroupColumnSchemaList) {
                this.columnGroupColumnSchemaList = columnGroupColumnSchemaList;
                return this;
            }

            /**
             * Sets the value of {@link ColumnGroupSchemaProperty#getName}
             * @param name The name of the column group schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnGroupSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnGroupSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnGroupSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnGroupSchemaProperty {
            private final java.lang.Object columnGroupColumnSchemaList;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnGroupColumnSchemaList = software.amazon.jsii.Kernel.get(this, "columnGroupColumnSchemaList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnGroupColumnSchemaList = builder.columnGroupColumnSchemaList;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getColumnGroupColumnSchemaList() {
                return this.columnGroupColumnSchemaList;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnGroupColumnSchemaList() != null) {
                    data.set("columnGroupColumnSchemaList", om.valueToTree(this.getColumnGroupColumnSchemaList()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.ColumnGroupSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnGroupSchemaProperty.Jsii$Proxy that = (ColumnGroupSchemaProperty.Jsii$Proxy) o;

                if (this.columnGroupColumnSchemaList != null ? !this.columnGroupColumnSchemaList.equals(that.columnGroupColumnSchemaList) : that.columnGroupColumnSchemaList != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnGroupColumnSchemaList != null ? this.columnGroupColumnSchemaList.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The column schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnSchemaProperty columnSchemaProperty = ColumnSchemaProperty.builder()
     *         .dataType("dataType")
     *         .geographicRole("geographicRole")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.ColumnSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data type of the column schema.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataType() {
            return null;
        }

        /**
         * The geographic role of the column schema.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGeographicRole() {
            return null;
        }

        /**
         * The name of the column schema.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnSchemaProperty> {
            java.lang.String dataType;
            java.lang.String geographicRole;
            java.lang.String name;

            /**
             * Sets the value of {@link ColumnSchemaProperty#getDataType}
             * @param dataType The data type of the column schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(java.lang.String dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link ColumnSchemaProperty#getGeographicRole}
             * @param geographicRole The geographic role of the column schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geographicRole(java.lang.String geographicRole) {
                this.geographicRole = geographicRole;
                return this;
            }

            /**
             * Sets the value of {@link ColumnSchemaProperty#getName}
             * @param name The name of the column schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnSchemaProperty {
            private final java.lang.String dataType;
            private final java.lang.String geographicRole;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.geographicRole = software.amazon.jsii.Kernel.get(this, "geographicRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataType = builder.dataType;
                this.geographicRole = builder.geographicRole;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.String getGeographicRole() {
                return this.geographicRole;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataType() != null) {
                    data.set("dataType", om.valueToTree(this.getDataType()));
                }
                if (this.getGeographicRole() != null) {
                    data.set("geographicRole", om.valueToTree(this.getGeographicRole()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.ColumnSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnSchemaProperty.Jsii$Proxy that = (ColumnSchemaProperty.Jsii$Proxy) o;

                if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) return false;
                if (this.geographicRole != null ? !this.geographicRole.equals(that.geographicRole) : that.geographicRole != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataType != null ? this.dataType.hashCode() : 0;
                result = 31 * result + (this.geographicRole != null ? this.geographicRole.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Dataset configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetConfigurationProperty dataSetConfigurationProperty = DataSetConfigurationProperty.builder()
     *         .columnGroupSchemaList(List.of(ColumnGroupSchemaProperty.builder()
     *                 .columnGroupColumnSchemaList(List.of(ColumnGroupColumnSchemaProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .name("name")
     *                 .build()))
     *         .dataSetSchema(DataSetSchemaProperty.builder()
     *                 .columnSchemaList(List.of(ColumnSchemaProperty.builder()
     *                         .dataType("dataType")
     *                         .geographicRole("geographicRole")
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .placeholder("placeholder")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.DataSetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure containing the list of column group schemas.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnGroupSchemaList() {
            return null;
        }

        /**
         * Dataset schema.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataSetSchema() {
            return null;
        }

        /**
         * Placeholder.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlaceholder() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetConfigurationProperty> {
            java.lang.Object columnGroupSchemaList;
            java.lang.Object dataSetSchema;
            java.lang.String placeholder;

            /**
             * Sets the value of {@link DataSetConfigurationProperty#getColumnGroupSchemaList}
             * @param columnGroupSchemaList A structure containing the list of column group schemas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnGroupSchemaList(software.amazon.awscdk.core.IResolvable columnGroupSchemaList) {
                this.columnGroupSchemaList = columnGroupSchemaList;
                return this;
            }

            /**
             * Sets the value of {@link DataSetConfigurationProperty#getColumnGroupSchemaList}
             * @param columnGroupSchemaList A structure containing the list of column group schemas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnGroupSchemaList(java.util.List<? extends java.lang.Object> columnGroupSchemaList) {
                this.columnGroupSchemaList = columnGroupSchemaList;
                return this;
            }

            /**
             * Sets the value of {@link DataSetConfigurationProperty#getDataSetSchema}
             * @param dataSetSchema Dataset schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetSchema(software.amazon.awscdk.services.quicksight.CfnTemplate.DataSetSchemaProperty dataSetSchema) {
                this.dataSetSchema = dataSetSchema;
                return this;
            }

            /**
             * Sets the value of {@link DataSetConfigurationProperty#getDataSetSchema}
             * @param dataSetSchema Dataset schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetSchema(software.amazon.awscdk.core.IResolvable dataSetSchema) {
                this.dataSetSchema = dataSetSchema;
                return this;
            }

            /**
             * Sets the value of {@link DataSetConfigurationProperty#getPlaceholder}
             * @param placeholder Placeholder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placeholder(java.lang.String placeholder) {
                this.placeholder = placeholder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetConfigurationProperty {
            private final java.lang.Object columnGroupSchemaList;
            private final java.lang.Object dataSetSchema;
            private final java.lang.String placeholder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnGroupSchemaList = software.amazon.jsii.Kernel.get(this, "columnGroupSchemaList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataSetSchema = software.amazon.jsii.Kernel.get(this, "dataSetSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placeholder = software.amazon.jsii.Kernel.get(this, "placeholder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnGroupSchemaList = builder.columnGroupSchemaList;
                this.dataSetSchema = builder.dataSetSchema;
                this.placeholder = builder.placeholder;
            }

            @Override
            public final java.lang.Object getColumnGroupSchemaList() {
                return this.columnGroupSchemaList;
            }

            @Override
            public final java.lang.Object getDataSetSchema() {
                return this.dataSetSchema;
            }

            @Override
            public final java.lang.String getPlaceholder() {
                return this.placeholder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnGroupSchemaList() != null) {
                    data.set("columnGroupSchemaList", om.valueToTree(this.getColumnGroupSchemaList()));
                }
                if (this.getDataSetSchema() != null) {
                    data.set("dataSetSchema", om.valueToTree(this.getDataSetSchema()));
                }
                if (this.getPlaceholder() != null) {
                    data.set("placeholder", om.valueToTree(this.getPlaceholder()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.DataSetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetConfigurationProperty.Jsii$Proxy that = (DataSetConfigurationProperty.Jsii$Proxy) o;

                if (this.columnGroupSchemaList != null ? !this.columnGroupSchemaList.equals(that.columnGroupSchemaList) : that.columnGroupSchemaList != null) return false;
                if (this.dataSetSchema != null ? !this.dataSetSchema.equals(that.dataSetSchema) : that.dataSetSchema != null) return false;
                return this.placeholder != null ? this.placeholder.equals(that.placeholder) : that.placeholder == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnGroupSchemaList != null ? this.columnGroupSchemaList.hashCode() : 0;
                result = 31 * result + (this.dataSetSchema != null ? this.dataSetSchema.hashCode() : 0);
                result = 31 * result + (this.placeholder != null ? this.placeholder.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Dataset reference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetReferenceProperty dataSetReferenceProperty = DataSetReferenceProperty.builder()
     *         .dataSetArn("dataSetArn")
     *         .dataSetPlaceholder("dataSetPlaceholder")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.DataSetReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Dataset Amazon Resource Name (ARN).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetArn();

        /**
         * Dataset placeholder.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetPlaceholder();

        /**
         * @return a {@link Builder} of {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetReferenceProperty> {
            java.lang.String dataSetArn;
            java.lang.String dataSetPlaceholder;

            /**
             * Sets the value of {@link DataSetReferenceProperty#getDataSetArn}
             * @param dataSetArn Dataset Amazon Resource Name (ARN). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetArn(java.lang.String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            /**
             * Sets the value of {@link DataSetReferenceProperty#getDataSetPlaceholder}
             * @param dataSetPlaceholder Dataset placeholder. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetPlaceholder(java.lang.String dataSetPlaceholder) {
                this.dataSetPlaceholder = dataSetPlaceholder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetReferenceProperty {
            private final java.lang.String dataSetArn;
            private final java.lang.String dataSetPlaceholder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetArn = software.amazon.jsii.Kernel.get(this, "dataSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetPlaceholder = software.amazon.jsii.Kernel.get(this, "dataSetPlaceholder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetArn = java.util.Objects.requireNonNull(builder.dataSetArn, "dataSetArn is required");
                this.dataSetPlaceholder = java.util.Objects.requireNonNull(builder.dataSetPlaceholder, "dataSetPlaceholder is required");
            }

            @Override
            public final java.lang.String getDataSetArn() {
                return this.dataSetArn;
            }

            @Override
            public final java.lang.String getDataSetPlaceholder() {
                return this.dataSetPlaceholder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSetArn", om.valueToTree(this.getDataSetArn()));
                data.set("dataSetPlaceholder", om.valueToTree(this.getDataSetPlaceholder()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.DataSetReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetReferenceProperty.Jsii$Proxy that = (DataSetReferenceProperty.Jsii$Proxy) o;

                if (!dataSetArn.equals(that.dataSetArn)) return false;
                return this.dataSetPlaceholder.equals(that.dataSetPlaceholder);
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetArn.hashCode();
                result = 31 * result + (this.dataSetPlaceholder.hashCode());
                return result;
            }
        }
    }
    /**
     * Dataset schema.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetSchemaProperty dataSetSchemaProperty = DataSetSchemaProperty.builder()
     *         .columnSchemaList(List.of(ColumnSchemaProperty.builder()
     *                 .dataType("dataType")
     *                 .geographicRole("geographicRole")
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.DataSetSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure containing the list of column schemas.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnSchemaList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetSchemaProperty> {
            java.lang.Object columnSchemaList;

            /**
             * Sets the value of {@link DataSetSchemaProperty#getColumnSchemaList}
             * @param columnSchemaList A structure containing the list of column schemas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnSchemaList(software.amazon.awscdk.core.IResolvable columnSchemaList) {
                this.columnSchemaList = columnSchemaList;
                return this;
            }

            /**
             * Sets the value of {@link DataSetSchemaProperty#getColumnSchemaList}
             * @param columnSchemaList A structure containing the list of column schemas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnSchemaList(java.util.List<? extends java.lang.Object> columnSchemaList) {
                this.columnSchemaList = columnSchemaList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetSchemaProperty {
            private final java.lang.Object columnSchemaList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnSchemaList = software.amazon.jsii.Kernel.get(this, "columnSchemaList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnSchemaList = builder.columnSchemaList;
            }

            @Override
            public final java.lang.Object getColumnSchemaList() {
                return this.columnSchemaList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnSchemaList() != null) {
                    data.set("columnSchemaList", om.valueToTree(this.getColumnSchemaList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.DataSetSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetSchemaProperty.Jsii$Proxy that = (DataSetSchemaProperty.Jsii$Proxy) o;

                return this.columnSchemaList != null ? this.columnSchemaList.equals(that.columnSchemaList) : that.columnSchemaList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnSchemaList != null ? this.columnSchemaList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Permission for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
     *         .actions(List.of("actions"))
     *         .principal("principal")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM action to grant or revoke permissions on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         * <p>
         * <ul>
         * <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
         * <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
         * <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

        /**
         * @return a {@link Builder} of {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.String principal;

            /**
             * Sets the value of {@link ResourcePermissionProperty#getActions}
             * @param actions The IAM action to grant or revoke permissions on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getPrincipal}
             * @param principal The Amazon Resource Name (ARN) of the principal. This can be one of the following:. This parameter is required.
             *                  <ul>
             *                  <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
             *                  <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
             *                  <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(java.lang.String principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePermissionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.String principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.ResourcePermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePermissionProperty.Jsii$Proxy that = (ResourcePermissionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.principal.equals(that.principal);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                return result;
            }
        }
    }
    /**
     * A *sheet* , which is an object that contains a set of visuals that are viewed together on one page in Amazon QuickSight.
     * <p>
     * Every analysis and dashboard contains at least one sheet. Each sheet contains at least one visualization widget, for example a chart, pivot table, or narrative insight. Sheets can be associated with other components, such as controls, filters, and so on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SheetProperty sheetProperty = SheetProperty.builder()
     *         .name("name")
     *         .sheetId("sheetId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.SheetProperty")
    @software.amazon.jsii.Jsii.Proxy(SheetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SheetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a sheet.
         * <p>
         * This name is displayed on the sheet's tab in the Amazon QuickSight console.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The unique identifier associated with a sheet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSheetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SheetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SheetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SheetProperty> {
            java.lang.String name;
            java.lang.String sheetId;

            /**
             * Sets the value of {@link SheetProperty#getName}
             * @param name The name of a sheet.
             *             This name is displayed on the sheet's tab in the Amazon QuickSight console.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SheetProperty#getSheetId}
             * @param sheetId The unique identifier associated with a sheet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheetId(java.lang.String sheetId) {
                this.sheetId = sheetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SheetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SheetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SheetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SheetProperty {
            private final java.lang.String name;
            private final java.lang.String sheetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sheetId = software.amazon.jsii.Kernel.get(this, "sheetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.sheetId = builder.sheetId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSheetId() {
                return this.sheetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSheetId() != null) {
                    data.set("sheetId", om.valueToTree(this.getSheetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.SheetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SheetProperty.Jsii$Proxy that = (SheetProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.sheetId != null ? this.sheetId.equals(that.sheetId) : that.sheetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.sheetId != null ? this.sheetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * List of errors that occurred when the template version creation failed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TemplateErrorProperty templateErrorProperty = TemplateErrorProperty.builder()
     *         .message("message")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.TemplateErrorProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateErrorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateErrorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Description of the error type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
            return null;
        }

        /**
         * Type of error.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateErrorProperty> {
            java.lang.String message;
            java.lang.String type;

            /**
             * Sets the value of {@link TemplateErrorProperty#getMessage}
             * @param message Description of the error type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link TemplateErrorProperty#getType}
             * @param type Type of error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateErrorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateErrorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateErrorProperty {
            private final java.lang.String message;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = builder.message;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessage() != null) {
                    data.set("message", om.valueToTree(this.getMessage()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.TemplateErrorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateErrorProperty.Jsii$Proxy that = (TemplateErrorProperty.Jsii$Proxy) o;

                if (this.message != null ? !this.message.equals(that.message) : that.message != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message != null ? this.message.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The source analysis of the template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TemplateSourceAnalysisProperty templateSourceAnalysisProperty = TemplateSourceAnalysisProperty.builder()
     *         .arn("arn")
     *         .dataSetReferences(List.of(DataSetReferenceProperty.builder()
     *                 .dataSetArn("dataSetArn")
     *                 .dataSetPlaceholder("dataSetPlaceholder")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.TemplateSourceAnalysisProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateSourceAnalysisProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateSourceAnalysisProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * A structure containing information about the dataset references used as placeholders in the template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDataSetReferences();

        /**
         * @return a {@link Builder} of {@link TemplateSourceAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateSourceAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateSourceAnalysisProperty> {
            java.lang.String arn;
            java.lang.Object dataSetReferences;

            /**
             * Sets the value of {@link TemplateSourceAnalysisProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link TemplateSourceAnalysisProperty#getDataSetReferences}
             * @param dataSetReferences A structure containing information about the dataset references used as placeholders in the template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetReferences(software.amazon.awscdk.core.IResolvable dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            /**
             * Sets the value of {@link TemplateSourceAnalysisProperty#getDataSetReferences}
             * @param dataSetReferences A structure containing information about the dataset references used as placeholders in the template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetReferences(java.util.List<? extends java.lang.Object> dataSetReferences) {
                this.dataSetReferences = dataSetReferences;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateSourceAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateSourceAnalysisProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateSourceAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateSourceAnalysisProperty {
            private final java.lang.String arn;
            private final java.lang.Object dataSetReferences;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetReferences = software.amazon.jsii.Kernel.get(this, "dataSetReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.dataSetReferences = java.util.Objects.requireNonNull(builder.dataSetReferences, "dataSetReferences is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Object getDataSetReferences() {
                return this.dataSetReferences;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("dataSetReferences", om.valueToTree(this.getDataSetReferences()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.TemplateSourceAnalysisProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateSourceAnalysisProperty.Jsii$Proxy that = (TemplateSourceAnalysisProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                return this.dataSetReferences.equals(that.dataSetReferences);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.dataSetReferences.hashCode());
                return result;
            }
        }
    }
    /**
     * The source entity of the template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TemplateSourceEntityProperty templateSourceEntityProperty = TemplateSourceEntityProperty.builder()
     *         .sourceAnalysis(TemplateSourceAnalysisProperty.builder()
     *                 .arn("arn")
     *                 .dataSetReferences(List.of(DataSetReferenceProperty.builder()
     *                         .dataSetArn("dataSetArn")
     *                         .dataSetPlaceholder("dataSetPlaceholder")
     *                         .build()))
     *                 .build())
     *         .sourceTemplate(TemplateSourceTemplateProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.TemplateSourceEntityProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateSourceEntityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateSourceEntityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source analysis, if it is based on an analysis.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceAnalysis() {
            return null;
        }

        /**
         * The source template, if it is based on an template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateSourceEntityProperty> {
            java.lang.Object sourceAnalysis;
            java.lang.Object sourceTemplate;

            /**
             * Sets the value of {@link TemplateSourceEntityProperty#getSourceAnalysis}
             * @param sourceAnalysis The source analysis, if it is based on an analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAnalysis(software.amazon.awscdk.services.quicksight.CfnTemplate.TemplateSourceAnalysisProperty sourceAnalysis) {
                this.sourceAnalysis = sourceAnalysis;
                return this;
            }

            /**
             * Sets the value of {@link TemplateSourceEntityProperty#getSourceAnalysis}
             * @param sourceAnalysis The source analysis, if it is based on an analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAnalysis(software.amazon.awscdk.core.IResolvable sourceAnalysis) {
                this.sourceAnalysis = sourceAnalysis;
                return this;
            }

            /**
             * Sets the value of {@link TemplateSourceEntityProperty#getSourceTemplate}
             * @param sourceTemplate The source template, if it is based on an template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTemplate(software.amazon.awscdk.services.quicksight.CfnTemplate.TemplateSourceTemplateProperty sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            /**
             * Sets the value of {@link TemplateSourceEntityProperty#getSourceTemplate}
             * @param sourceTemplate The source template, if it is based on an template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTemplate(software.amazon.awscdk.core.IResolvable sourceTemplate) {
                this.sourceTemplate = sourceTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateSourceEntityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateSourceEntityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateSourceEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateSourceEntityProperty {
            private final java.lang.Object sourceAnalysis;
            private final java.lang.Object sourceTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceAnalysis = software.amazon.jsii.Kernel.get(this, "sourceAnalysis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceTemplate = software.amazon.jsii.Kernel.get(this, "sourceTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceAnalysis = builder.sourceAnalysis;
                this.sourceTemplate = builder.sourceTemplate;
            }

            @Override
            public final java.lang.Object getSourceAnalysis() {
                return this.sourceAnalysis;
            }

            @Override
            public final java.lang.Object getSourceTemplate() {
                return this.sourceTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceAnalysis() != null) {
                    data.set("sourceAnalysis", om.valueToTree(this.getSourceAnalysis()));
                }
                if (this.getSourceTemplate() != null) {
                    data.set("sourceTemplate", om.valueToTree(this.getSourceTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.TemplateSourceEntityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateSourceEntityProperty.Jsii$Proxy that = (TemplateSourceEntityProperty.Jsii$Proxy) o;

                if (this.sourceAnalysis != null ? !this.sourceAnalysis.equals(that.sourceAnalysis) : that.sourceAnalysis != null) return false;
                return this.sourceTemplate != null ? this.sourceTemplate.equals(that.sourceTemplate) : that.sourceTemplate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceAnalysis != null ? this.sourceAnalysis.hashCode() : 0;
                result = 31 * result + (this.sourceTemplate != null ? this.sourceTemplate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The source template of the template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TemplateSourceTemplateProperty templateSourceTemplateProperty = TemplateSourceTemplateProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.TemplateSourceTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateSourceTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateSourceTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link TemplateSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateSourceTemplateProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link TemplateSourceTemplateProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateSourceTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateSourceTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateSourceTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateSourceTemplateProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.TemplateSourceTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateSourceTemplateProperty.Jsii$Proxy that = (TemplateSourceTemplateProperty.Jsii$Proxy) o;

                return this.arn.equals(that.arn);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                return result;
            }
        }
    }
    /**
     * A version of a template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TemplateVersionProperty templateVersionProperty = TemplateVersionProperty.builder()
     *         .createdTime("createdTime")
     *         .dataSetConfigurations(List.of(DataSetConfigurationProperty.builder()
     *                 .columnGroupSchemaList(List.of(ColumnGroupSchemaProperty.builder()
     *                         .columnGroupColumnSchemaList(List.of(ColumnGroupColumnSchemaProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .name("name")
     *                         .build()))
     *                 .dataSetSchema(DataSetSchemaProperty.builder()
     *                         .columnSchemaList(List.of(ColumnSchemaProperty.builder()
     *                                 .dataType("dataType")
     *                                 .geographicRole("geographicRole")
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .placeholder("placeholder")
     *                 .build()))
     *         .description("description")
     *         .errors(List.of(TemplateErrorProperty.builder()
     *                 .message("message")
     *                 .type("type")
     *                 .build()))
     *         .sheets(List.of(SheetProperty.builder()
     *                 .name("name")
     *                 .sheetId("sheetId")
     *                 .build()))
     *         .sourceEntityArn("sourceEntityArn")
     *         .status("status")
     *         .themeArn("themeArn")
     *         .versionNumber(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTemplate.TemplateVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time that this template version was created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedTime() {
            return null;
        }

        /**
         * Schema of the dataset identified by the placeholder.
         * <p>
         * Any dashboard created from this template should be bound to new datasets matching the same schema described through this API operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataSetConfigurations() {
            return null;
        }

        /**
         * The description of the template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Errors associated with this template version.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrors() {
            return null;
        }

        /**
         * A list of the associated sheets with the unique identifier and name of each sheet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSheets() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of an analysis or template that was used to create this template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceEntityArn() {
            return null;
        }

        /**
         * The HTTP status of the request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The ARN of the theme associated with this version of the template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThemeArn() {
            return null;
        }

        /**
         * The version number of the template version.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVersionNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateVersionProperty> {
            java.lang.String createdTime;
            java.lang.Object dataSetConfigurations;
            java.lang.String description;
            java.lang.Object errors;
            java.lang.Object sheets;
            java.lang.String sourceEntityArn;
            java.lang.String status;
            java.lang.String themeArn;
            java.lang.Number versionNumber;

            /**
             * Sets the value of {@link TemplateVersionProperty#getCreatedTime}
             * @param createdTime The time that this template version was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdTime(java.lang.String createdTime) {
                this.createdTime = createdTime;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getDataSetConfigurations}
             * @param dataSetConfigurations Schema of the dataset identified by the placeholder.
             *                              Any dashboard created from this template should be bound to new datasets matching the same schema described through this API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetConfigurations(software.amazon.awscdk.core.IResolvable dataSetConfigurations) {
                this.dataSetConfigurations = dataSetConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getDataSetConfigurations}
             * @param dataSetConfigurations Schema of the dataset identified by the placeholder.
             *                              Any dashboard created from this template should be bound to new datasets matching the same schema described through this API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetConfigurations(java.util.List<? extends java.lang.Object> dataSetConfigurations) {
                this.dataSetConfigurations = dataSetConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getDescription}
             * @param description The description of the template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getErrors}
             * @param errors Errors associated with this template version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errors(software.amazon.awscdk.core.IResolvable errors) {
                this.errors = errors;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getErrors}
             * @param errors Errors associated with this template version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errors(java.util.List<? extends java.lang.Object> errors) {
                this.errors = errors;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getSheets}
             * @param sheets A list of the associated sheets with the unique identifier and name of each sheet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheets(software.amazon.awscdk.core.IResolvable sheets) {
                this.sheets = sheets;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getSheets}
             * @param sheets A list of the associated sheets with the unique identifier and name of each sheet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheets(java.util.List<? extends java.lang.Object> sheets) {
                this.sheets = sheets;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getSourceEntityArn}
             * @param sourceEntityArn The Amazon Resource Name (ARN) of an analysis or template that was used to create this template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceEntityArn(java.lang.String sourceEntityArn) {
                this.sourceEntityArn = sourceEntityArn;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getStatus}
             * @param status The HTTP status of the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getThemeArn}
             * @param themeArn The ARN of the theme associated with this version of the template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder themeArn(java.lang.String themeArn) {
                this.themeArn = themeArn;
                return this;
            }

            /**
             * Sets the value of {@link TemplateVersionProperty#getVersionNumber}
             * @param versionNumber The version number of the template version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versionNumber(java.lang.Number versionNumber) {
                this.versionNumber = versionNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateVersionProperty {
            private final java.lang.String createdTime;
            private final java.lang.Object dataSetConfigurations;
            private final java.lang.String description;
            private final java.lang.Object errors;
            private final java.lang.Object sheets;
            private final java.lang.String sourceEntityArn;
            private final java.lang.String status;
            private final java.lang.String themeArn;
            private final java.lang.Number versionNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.createdTime = software.amazon.jsii.Kernel.get(this, "createdTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSetConfigurations = software.amazon.jsii.Kernel.get(this, "dataSetConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errors = software.amazon.jsii.Kernel.get(this, "errors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sheets = software.amazon.jsii.Kernel.get(this, "sheets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceEntityArn = software.amazon.jsii.Kernel.get(this, "sourceEntityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.themeArn = software.amazon.jsii.Kernel.get(this, "themeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.versionNumber = software.amazon.jsii.Kernel.get(this, "versionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.createdTime = builder.createdTime;
                this.dataSetConfigurations = builder.dataSetConfigurations;
                this.description = builder.description;
                this.errors = builder.errors;
                this.sheets = builder.sheets;
                this.sourceEntityArn = builder.sourceEntityArn;
                this.status = builder.status;
                this.themeArn = builder.themeArn;
                this.versionNumber = builder.versionNumber;
            }

            @Override
            public final java.lang.String getCreatedTime() {
                return this.createdTime;
            }

            @Override
            public final java.lang.Object getDataSetConfigurations() {
                return this.dataSetConfigurations;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getErrors() {
                return this.errors;
            }

            @Override
            public final java.lang.Object getSheets() {
                return this.sheets;
            }

            @Override
            public final java.lang.String getSourceEntityArn() {
                return this.sourceEntityArn;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getThemeArn() {
                return this.themeArn;
            }

            @Override
            public final java.lang.Number getVersionNumber() {
                return this.versionNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCreatedTime() != null) {
                    data.set("createdTime", om.valueToTree(this.getCreatedTime()));
                }
                if (this.getDataSetConfigurations() != null) {
                    data.set("dataSetConfigurations", om.valueToTree(this.getDataSetConfigurations()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getErrors() != null) {
                    data.set("errors", om.valueToTree(this.getErrors()));
                }
                if (this.getSheets() != null) {
                    data.set("sheets", om.valueToTree(this.getSheets()));
                }
                if (this.getSourceEntityArn() != null) {
                    data.set("sourceEntityArn", om.valueToTree(this.getSourceEntityArn()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getThemeArn() != null) {
                    data.set("themeArn", om.valueToTree(this.getThemeArn()));
                }
                if (this.getVersionNumber() != null) {
                    data.set("versionNumber", om.valueToTree(this.getVersionNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTemplate.TemplateVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateVersionProperty.Jsii$Proxy that = (TemplateVersionProperty.Jsii$Proxy) o;

                if (this.createdTime != null ? !this.createdTime.equals(that.createdTime) : that.createdTime != null) return false;
                if (this.dataSetConfigurations != null ? !this.dataSetConfigurations.equals(that.dataSetConfigurations) : that.dataSetConfigurations != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.errors != null ? !this.errors.equals(that.errors) : that.errors != null) return false;
                if (this.sheets != null ? !this.sheets.equals(that.sheets) : that.sheets != null) return false;
                if (this.sourceEntityArn != null ? !this.sourceEntityArn.equals(that.sourceEntityArn) : that.sourceEntityArn != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.themeArn != null ? !this.themeArn.equals(that.themeArn) : that.themeArn != null) return false;
                return this.versionNumber != null ? this.versionNumber.equals(that.versionNumber) : that.versionNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.createdTime != null ? this.createdTime.hashCode() : 0;
                result = 31 * result + (this.dataSetConfigurations != null ? this.dataSetConfigurations.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
                result = 31 * result + (this.sheets != null ? this.sheets.hashCode() : 0);
                result = 31 * result + (this.sourceEntityArn != null ? this.sourceEntityArn.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.themeArn != null ? this.themeArn.hashCode() : 0);
                result = 31 * result + (this.versionNumber != null ? this.versionNumber.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.quicksight.CfnTemplateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.quicksight.CfnTemplateProps.Builder();
        }

        /**
         * The ID for the AWS account that the group is in.
         * <p>
         * You use the ID for the AWS account that contains your Amazon QuickSight account.
         * <p>
         * @return {@code this}
         * @param awsAccountId The ID for the AWS account that the group is in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props.awsAccountId(awsAccountId);
            return this;
        }

        /**
         * The entity that you are using as a source when you create the template.
         * <p>
         * In <code>SourceEntity</code> , you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code> , specify the ARN of the source template. For <code>SourceAnalysis</code> , specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any AWS account and any Amazon QuickSight-supported AWS Region .
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * <p>
         * @return {@code this}
         * @param sourceEntity The entity that you are using as a source when you create the template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(final software.amazon.awscdk.services.quicksight.CfnTemplate.TemplateSourceEntityProperty sourceEntity) {
            this.props.sourceEntity(sourceEntity);
            return this;
        }
        /**
         * The entity that you are using as a source when you create the template.
         * <p>
         * In <code>SourceEntity</code> , you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code> , specify the ARN of the source template. For <code>SourceAnalysis</code> , specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any AWS account and any Amazon QuickSight-supported AWS Region .
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * <p>
         * @return {@code this}
         * @param sourceEntity The entity that you are using as a source when you create the template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEntity(final software.amazon.awscdk.core.IResolvable sourceEntity) {
            this.props.sourceEntity(sourceEntity);
            return this;
        }

        /**
         * An ID for the template that you want to create.
         * <p>
         * This template is unique per AWS Region ; in each AWS account.
         * <p>
         * @return {@code this}
         * @param templateId An ID for the template that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateId(final java.lang.String templateId) {
            this.props.templateId(templateId);
            return this;
        }

        /**
         * A display name for the template.
         * <p>
         * @return {@code this}
         * @param name A display name for the template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A list of resource permissions to be set on the template.
         * <p>
         * @return {@code this}
         * @param permissions A list of resource permissions to be set on the template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final software.amazon.awscdk.core.IResolvable permissions) {
            this.props.permissions(permissions);
            return this;
        }
        /**
         * A list of resource permissions to be set on the template.
         * <p>
         * @return {@code this}
         * @param permissions A list of resource permissions to be set on the template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<? extends java.lang.Object> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * <p>
         * @return {@code this}
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A description of the current template version being created.
         * <p>
         * This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.
         * <p>
         * @return {@code this}
         * @param versionDescription A description of the current template version being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(final java.lang.String versionDescription) {
            this.props.versionDescription(versionDescription);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnTemplate build() {
            return new software.amazon.awscdk.services.quicksight.CfnTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
