package software.amazon.awscdk.services.rds;

/**
 * (experimental) The versions for the Oracle instance engines (those returned by {@link DatabaseInstanceEngine.oracleSe2} and {@link DatabaseInstanceEngine.oracleEe}).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance instance = DatabaseInstance.Builder.create(this, "Instance")
 *         .engine(DatabaseInstanceEngine.oracleSe2(OracleSe2InstanceEngineProps.builder().version(OracleEngineVersion.VER_19_0_0_0_2020_04_R1).build()))
 *         // optional, defaults to m5.large
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE3, InstanceSize.SMALL))
 *         .credentials(Credentials.fromGeneratedSecret("syscdk")) // Optional - will default to 'admin' username and generated password
 *         .vpc(vpc)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PRIVATE_WITH_NAT)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:08.363Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.OracleEngineVersion")
public class OracleEngineVersion extends software.amazon.jsii.JsiiObject {

    protected OracleEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OracleEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_12_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_1_0_2_V9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_1_0_2_V9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2018_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2018_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2019_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2019_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2019_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2019_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2019_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2019_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2019_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2019_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2020_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2020_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2020_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2020_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2020_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2020_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2020_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2020_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2021_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2021_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_12_2_0_1_2021_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_12_2_0_1_2021_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2019_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2019_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2019_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2019_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2020_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2020_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2020_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2020_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_18_0_0_0_2020_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_18_0_0_0_2020_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2019_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2019_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2019_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2019_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2020_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2020_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2020_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2020_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2020_07_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2020_07_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2020_10_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2020_10_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2021_01_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2021_01_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2021_01_R2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2021_01_R2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        VER_19_0_0_0_2021_04_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "VER_19_0_0_0_2021_04_R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
    }

    /**
     * (experimental) Creates a new OracleEngineVersion with an arbitrary version.
     * <p>
     * @param oracleFullVersion the full version string, for example "19.0.0.0.ru-2019-10.rur-2019-10.r1". This parameter is required.
     * @param oracleMajorVersion the major version of the engine, for example "19". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String oracleFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String oracleMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.OracleEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(oracleFullVersion, "oracleFullVersion is required"), java.util.Objects.requireNonNull(oracleMajorVersion, "oracleMajorVersion is required") });
    }

    /**
     * (experimental) Version "12.1" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1;

    /**
     * (experimental) Version "12.1.0.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V1;

    /**
     * (experimental) Version "12.1.0.2.v10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V10;

    /**
     * (experimental) Version "12.1.0.2.v11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V11;

    /**
     * (experimental) Version "12.1.0.2.v12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V12;

    /**
     * (experimental) Version "12.1.0.2.v13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V13;

    /**
     * (experimental) Version "12.1.0.2.v14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V14;

    /**
     * (experimental) Version "12.1.0.2.v15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V15;

    /**
     * (experimental) Version "12.1.0.2.v16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V16;

    /**
     * (experimental) Version "12.1.0.2.v17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V17;

    /**
     * (experimental) Version "12.1.0.2.v18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V18;

    /**
     * (experimental) Version "12.1.0.2.v19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V19;

    /**
     * (experimental) Version "12.1.0.2.v2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V2;

    /**
     * (experimental) Version "12.1.0.2.v20".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V20;

    /**
     * (experimental) Version "12.1.0.2.v21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V21;

    /**
     * (experimental) Version "12.1.0.2.v22".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V22;

    /**
     * (experimental) Version "12.1.0.2.v23".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V23;

    /**
     * (experimental) Version "12.1.0.2.v24".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V24;

    /**
     * (experimental) Version "12.1.0.2.v3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V3;

    /**
     * (experimental) Version "12.1.0.2.v4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V4;

    /**
     * (experimental) Version "12.1.0.2.v5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V5;

    /**
     * (experimental) Version "12.1.0.2.v6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V6;

    /**
     * (experimental) Version "12.1.0.2.v7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V7;

    /**
     * (experimental) Version "12.1.0.2.v8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V8;

    /**
     * (experimental) Version "12.1.0.2.v9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_1_0_2_V9;

    /**
     * (experimental) Version "12.2" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2;

    /**
     * (experimental) Version "12.2.0.1.ru-2018-10.rur-2018-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2018_10_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2019-01.rur-2019-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2019_01_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2019-04.rur-2019-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2019_04_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2019-07.rur-2019-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2019_07_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2019-10.rur-2019-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2019_10_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2020-01.rur-2020-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2020_01_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2020-04.rur-2020-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2020_04_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2020-07.rur-2020-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2020_07_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2021-10.rur-2020-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2020_10_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2021-01.rur-2021-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2021_01_R1;

    /**
     * (experimental) Version "12.2.0.1.ru-2021-04.rur-2021-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_12_2_0_1_2021_04_R1;

    /**
     * (experimental) Version "18" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18;

    /**
     * (experimental) Version "18.0.0.0.ru-2019-07.rur-2019-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2019_07_R1;

    /**
     * (experimental) Version "18.0.0.0.ru-2019-10.rur-2019-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2019_10_R1;

    /**
     * (experimental) Version "18.0.0.0.ru-2020-01.rur-2020-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2020_01_R1;

    /**
     * (experimental) Version "18.0.0.0.ru-2020-04.rur-2020-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2020_04_R1;

    /**
     * (experimental) Version "18.0.0.0.ru-2020-07.rur-2020-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_18_0_0_0_2020_07_R1;

    /**
     * (experimental) Version "19" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19;

    /**
     * (experimental) Version "19.0.0.0.ru-2019-07.rur-2019-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2019_07_R1;

    /**
     * (experimental) Version "19.0.0.0.ru-2019-10.rur-2019-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2019_10_R1;

    /**
     * (experimental) Version "19.0.0.0.ru-2020-01.rur-2020-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2020_01_R1;

    /**
     * (experimental) Version "19.0.0.0.ru-2020-04.rur-2020-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2020_04_R1;

    /**
     * (experimental) Version "19.0.0.0.ru-2020-07.rur-2020-07.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2020_07_R1;

    /**
     * (experimental) Version "19.0.0.0.ru-2020-07.rur-2020-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2020_10_R1;

    /**
     * (experimental) Version "19.0.0.0.ru-2021-01.rur-2021-01.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2021_01_R1;

    /**
     * (experimental) Version "19.0.0.0.ru-2021-01.rur-2021-01.r2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2021_01_R2;

    /**
     * (experimental) Version "19.0.0.0.ru-2021-01.rur-2021-04.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.OracleEngineVersion VER_19_0_0_0_2021_04_R1;

    /**
     * (experimental) The full version string, for example, "19.0.0.0.ru-2019-10.rur-2019-10.r1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getOracleFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "oracleFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The major version of the engine, for example, "19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getOracleMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "oracleMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
