package software.amazon.awscdk.services.redshiftserverless;

/**
 * Properties for defining a `CfnNamespace`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * CfnNamespaceProps cfnNamespaceProps = CfnNamespaceProps.builder()
 *         .namespaceName("namespaceName")
 *         // the properties below are optional
 *         .adminUsername("adminUsername")
 *         .adminUserPassword("adminUserPassword")
 *         .dbName("dbName")
 *         .defaultIamRoleArn("defaultIamRoleArn")
 *         .finalSnapshotName("finalSnapshotName")
 *         .finalSnapshotRetentionPeriod(123)
 *         .iamRoles(List.of("iamRoles"))
 *         .kmsKeyId("kmsKeyId")
 *         .logExports(List.of("logExports"))
 *         .namespace(NamespaceProperty.builder()
 *                 .adminUsername("adminUsername")
 *                 .creationDate("creationDate")
 *                 .dbName("dbName")
 *                 .defaultIamRoleArn("defaultIamRoleArn")
 *                 .iamRoles(List.of("iamRoles"))
 *                 .kmsKeyId("kmsKeyId")
 *                 .logExports(List.of("logExports"))
 *                 .namespaceArn("namespaceArn")
 *                 .namespaceId("namespaceId")
 *                 .namespaceName("namespaceName")
 *                 .status("status")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:08.559Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_redshiftserverless.CfnNamespaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnNamespaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNamespaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNamespaceName();

    /**
     * The username of the administrator for the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdminUsername() {
        return null;
    }

    /**
     * The password of the administrator for the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdminUserPassword() {
        return null;
    }

    /**
     * The name of the primary database created in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultIamRoleArn() {
        return null;
    }

    /**
     * The name of the snapshot to be created before the namespace is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFinalSnapshotName() {
        return null;
    }

    /**
     * How long to retain the final snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFinalSnapshotRetentionPeriod() {
        return null;
    }

    /**
     * A list of IAM roles to associate with the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIamRoles() {
        return null;
    }

    /**
     * The ID of the AWS Key Management Service key used to encrypt your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The types of logs the namespace can export.
     * <p>
     * Available export types are <code>userlog</code> , <code>connectionlog</code> , and <code>useractivitylog</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogExports() {
        return null;
    }

    /**
     * `AWS::RedshiftServerless::Namespace.Namespace`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNamespace() {
        return null;
    }

    /**
     * The map of the key-value pairs used to tag the namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNamespaceProps> {
        java.lang.String namespaceName;
        java.lang.String adminUsername;
        java.lang.String adminUserPassword;
        java.lang.String dbName;
        java.lang.String defaultIamRoleArn;
        java.lang.String finalSnapshotName;
        java.lang.Number finalSnapshotRetentionPeriod;
        java.util.List<java.lang.String> iamRoles;
        java.lang.String kmsKeyId;
        java.util.List<java.lang.String> logExports;
        java.lang.Object namespace;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnNamespaceProps#getNamespaceName}
         * @param namespaceName The name of the namespace. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceName(java.lang.String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getAdminUsername}
         * @param adminUsername The username of the administrator for the primary database created in the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUsername(java.lang.String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getAdminUserPassword}
         * @param adminUserPassword The password of the administrator for the primary database created in the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminUserPassword(java.lang.String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getDbName}
         * @param dbName The name of the primary database created in the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(java.lang.String dbName) {
            this.dbName = dbName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getDefaultIamRoleArn}
         * @param defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIamRoleArn(java.lang.String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getFinalSnapshotName}
         * @param finalSnapshotName The name of the snapshot to be created before the namespace is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalSnapshotName(java.lang.String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getFinalSnapshotRetentionPeriod}
         * @param finalSnapshotRetentionPeriod How long to retain the final snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalSnapshotRetentionPeriod(java.lang.Number finalSnapshotRetentionPeriod) {
            this.finalSnapshotRetentionPeriod = finalSnapshotRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getIamRoles}
         * @param iamRoles A list of IAM roles to associate with the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoles(java.util.List<java.lang.String> iamRoles) {
            this.iamRoles = iamRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getKmsKeyId}
         * @param kmsKeyId The ID of the AWS Key Management Service key used to encrypt your data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getLogExports}
         * @param logExports The types of logs the namespace can export.
         *                   Available export types are <code>userlog</code> , <code>connectionlog</code> , and <code>useractivitylog</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logExports(java.util.List<java.lang.String> logExports) {
            this.logExports = logExports;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getNamespace}
         * @param namespace `AWS::RedshiftServerless::Namespace.Namespace`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(software.amazon.awscdk.services.redshiftserverless.CfnNamespace.NamespaceProperty namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getNamespace}
         * @param namespace `AWS::RedshiftServerless::Namespace.Namespace`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(software.amazon.awscdk.core.IResolvable namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnNamespaceProps#getTags}
         * @param tags The map of the key-value pairs used to tag the namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNamespaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNamespaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNamespaceProps {
        private final java.lang.String namespaceName;
        private final java.lang.String adminUsername;
        private final java.lang.String adminUserPassword;
        private final java.lang.String dbName;
        private final java.lang.String defaultIamRoleArn;
        private final java.lang.String finalSnapshotName;
        private final java.lang.Number finalSnapshotRetentionPeriod;
        private final java.util.List<java.lang.String> iamRoles;
        private final java.lang.String kmsKeyId;
        private final java.util.List<java.lang.String> logExports;
        private final java.lang.Object namespace;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.namespaceName = software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminUsername = software.amazon.jsii.Kernel.get(this, "adminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminUserPassword = software.amazon.jsii.Kernel.get(this, "adminUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbName = software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultIamRoleArn = software.amazon.jsii.Kernel.get(this, "defaultIamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.finalSnapshotName = software.amazon.jsii.Kernel.get(this, "finalSnapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.finalSnapshotRetentionPeriod = software.amazon.jsii.Kernel.get(this, "finalSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.iamRoles = software.amazon.jsii.Kernel.get(this, "iamRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logExports = software.amazon.jsii.Kernel.get(this, "logExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.namespaceName = java.util.Objects.requireNonNull(builder.namespaceName, "namespaceName is required");
            this.adminUsername = builder.adminUsername;
            this.adminUserPassword = builder.adminUserPassword;
            this.dbName = builder.dbName;
            this.defaultIamRoleArn = builder.defaultIamRoleArn;
            this.finalSnapshotName = builder.finalSnapshotName;
            this.finalSnapshotRetentionPeriod = builder.finalSnapshotRetentionPeriod;
            this.iamRoles = builder.iamRoles;
            this.kmsKeyId = builder.kmsKeyId;
            this.logExports = builder.logExports;
            this.namespace = builder.namespace;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public final java.lang.String getAdminUsername() {
            return this.adminUsername;
        }

        @Override
        public final java.lang.String getAdminUserPassword() {
            return this.adminUserPassword;
        }

        @Override
        public final java.lang.String getDbName() {
            return this.dbName;
        }

        @Override
        public final java.lang.String getDefaultIamRoleArn() {
            return this.defaultIamRoleArn;
        }

        @Override
        public final java.lang.String getFinalSnapshotName() {
            return this.finalSnapshotName;
        }

        @Override
        public final java.lang.Number getFinalSnapshotRetentionPeriod() {
            return this.finalSnapshotRetentionPeriod;
        }

        @Override
        public final java.util.List<java.lang.String> getIamRoles() {
            return this.iamRoles;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.util.List<java.lang.String> getLogExports() {
            return this.logExports;
        }

        @Override
        public final java.lang.Object getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("namespaceName", om.valueToTree(this.getNamespaceName()));
            if (this.getAdminUsername() != null) {
                data.set("adminUsername", om.valueToTree(this.getAdminUsername()));
            }
            if (this.getAdminUserPassword() != null) {
                data.set("adminUserPassword", om.valueToTree(this.getAdminUserPassword()));
            }
            if (this.getDbName() != null) {
                data.set("dbName", om.valueToTree(this.getDbName()));
            }
            if (this.getDefaultIamRoleArn() != null) {
                data.set("defaultIamRoleArn", om.valueToTree(this.getDefaultIamRoleArn()));
            }
            if (this.getFinalSnapshotName() != null) {
                data.set("finalSnapshotName", om.valueToTree(this.getFinalSnapshotName()));
            }
            if (this.getFinalSnapshotRetentionPeriod() != null) {
                data.set("finalSnapshotRetentionPeriod", om.valueToTree(this.getFinalSnapshotRetentionPeriod()));
            }
            if (this.getIamRoles() != null) {
                data.set("iamRoles", om.valueToTree(this.getIamRoles()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLogExports() != null) {
                data.set("logExports", om.valueToTree(this.getLogExports()));
            }
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_redshiftserverless.CfnNamespaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNamespaceProps.Jsii$Proxy that = (CfnNamespaceProps.Jsii$Proxy) o;

            if (!namespaceName.equals(that.namespaceName)) return false;
            if (this.adminUsername != null ? !this.adminUsername.equals(that.adminUsername) : that.adminUsername != null) return false;
            if (this.adminUserPassword != null ? !this.adminUserPassword.equals(that.adminUserPassword) : that.adminUserPassword != null) return false;
            if (this.dbName != null ? !this.dbName.equals(that.dbName) : that.dbName != null) return false;
            if (this.defaultIamRoleArn != null ? !this.defaultIamRoleArn.equals(that.defaultIamRoleArn) : that.defaultIamRoleArn != null) return false;
            if (this.finalSnapshotName != null ? !this.finalSnapshotName.equals(that.finalSnapshotName) : that.finalSnapshotName != null) return false;
            if (this.finalSnapshotRetentionPeriod != null ? !this.finalSnapshotRetentionPeriod.equals(that.finalSnapshotRetentionPeriod) : that.finalSnapshotRetentionPeriod != null) return false;
            if (this.iamRoles != null ? !this.iamRoles.equals(that.iamRoles) : that.iamRoles != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.logExports != null ? !this.logExports.equals(that.logExports) : that.logExports != null) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.namespaceName.hashCode();
            result = 31 * result + (this.adminUsername != null ? this.adminUsername.hashCode() : 0);
            result = 31 * result + (this.adminUserPassword != null ? this.adminUserPassword.hashCode() : 0);
            result = 31 * result + (this.dbName != null ? this.dbName.hashCode() : 0);
            result = 31 * result + (this.defaultIamRoleArn != null ? this.defaultIamRoleArn.hashCode() : 0);
            result = 31 * result + (this.finalSnapshotName != null ? this.finalSnapshotName.hashCode() : 0);
            result = 31 * result + (this.finalSnapshotRetentionPeriod != null ? this.finalSnapshotRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.iamRoles != null ? this.iamRoles.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.logExports != null ? this.logExports.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
