/**
 * <h1>Amazon Route53 Resolver Construct Library</h1>
 * <p>
 * <h2>DNS Firewall</h2>
 * <p>
 * With Route 53 Resolver DNS Firewall, you can filter and regulate outbound DNS traffic for your
 * virtual private connections (VPCs). To do this, you create reusable collections of filtering rules
 * in DNS Firewall rule groups and associate the rule groups to your VPC.
 * <p>
 * DNS Firewall provides protection for outbound DNS requests from your VPCs. These requests route
 * through Resolver for domain name resolution. A primary use of DNS Firewall protections is to help
 * prevent DNS exfiltration of your data. DNS exfiltration can happen when a bad actor compromises
 * an application instance in your VPC and then uses DNS lookup to send data out of the VPC to a domain
 * that they control. With DNS Firewall, you can monitor and control the domains that your applications
 * can query. You can deny access to the domains that you know to be bad and allow all other queries
 * to pass through. Alternately, you can deny access to all domains except for the ones that you
 * explicitly trust.
 * <p>
 * <h3>Domain lists</h3>
 * <p>
 * Domain lists can be created using a list of strings, a text file stored in Amazon S3 or a local
 * text file:
 * <p>
 * <blockquote><pre>
 * FirewallDomainList blockList = FirewallDomainList.Builder.create(this, "BlockList")
 *         .domains(FirewallDomains.fromList(List.of("bad-domain.com", "bot-domain.net")))
 *         .build();
 * 
 * FirewallDomainList s3List = FirewallDomainList.Builder.create(this, "S3List")
 *         .domains(FirewallDomains.fromS3Url("s3://bucket/prefix/object"))
 *         .build();
 * 
 * FirewallDomainList assetList = FirewallDomainList.Builder.create(this, "AssetList")
 *         .domains(FirewallDomains.fromAsset("/path/to/domains.txt"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * The file must be a text file and must contain a single domain per line.
 * <p>
 * Use <code>FirewallDomainList.fromFirewallDomainListId()</code> to import an existing or <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver-dns-firewall-managed-domain-lists.html">AWS managed domain list</a>:
 * <p>
 * <blockquote><pre>
 * // AWSManagedDomainsMalwareDomainList in us-east-1
 * IFirewallDomainList malwareList = FirewallDomainList.fromFirewallDomainListId(this, "Malware", "rslvr-fdl-2c46f2ecbfec4dcc");
 * </pre></blockquote>
 * <p>
 * <h3>Rule group</h3>
 * <p>
 * Create a rule group:
 * <p>
 * <blockquote><pre>
 * FirewallDomainList myBlockList;
 * 
 * FirewallRuleGroup.Builder.create(this, "RuleGroup")
 *         .rules(List.of(FirewallRule.builder()
 *                 .priority(10)
 *                 .firewallDomainList(myBlockList)
 *                 // block and reply with NODATA
 *                 .action(FirewallRuleAction.block())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Rules can be added at construction time or using <code>addRule()</code>:
 * <p>
 * <blockquote><pre>
 * FirewallDomainList myBlockList;
 * FirewallRuleGroup ruleGroup;
 * 
 * 
 * ruleGroup.addRule(FirewallRule.builder()
 *         .priority(10)
 *         .firewallDomainList(myBlockList)
 *         // block and reply with NXDOMAIN
 *         .action(FirewallRuleAction.block(DnsBlockResponse.nxDomain()))
 *         .build());
 * 
 * ruleGroup.addRule(FirewallRule.builder()
 *         .priority(20)
 *         .firewallDomainList(myBlockList)
 *         // block and override DNS response with a custom domain
 *         .action(FirewallRuleAction.block(DnsBlockResponse.override("amazon.com")))
 *         .build());
 * </pre></blockquote>
 * <p>
 * Use <code>associate()</code> to associate a rule group with a VPC:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * 
 * FirewallRuleGroup ruleGroup;
 * Vpc myVpc;
 * 
 * 
 * ruleGroup.associate("Association", FirewallRuleGroupAssociationOptions.builder()
 *         .priority(101)
 *         .vpc(myVpc)
 *         .build());
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.route53resolver;
