/**
 * <h1>AWS::S3ObjectLambda Construct Library</h1>
 * <p>
 * This construct library allows you to define S3 object lambda access points.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * 
 * 
 * Stack stack = new Stack();
 * Bucket bucket = new Bucket(stack, "MyBucket");
 * Function handler = Function.Builder.create(stack, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset("lambda.zip"))
 *         .build();
 * AccessPoint.Builder.create(stack, "MyObjectLambda")
 *         .bucket(bucket)
 *         .handler(handler)
 *         .accessPointName("my-access-point")
 *         .payload(Map.of(
 *                 "prop", "value"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Handling range and part number requests</h2>
 * <p>
 * Lambdas are currently limited to only transforming <code>GetObject</code> requests. However, they can additionally support <code>GetObject-Range</code> and <code>GetObject-PartNumber</code> requests, which needs to be specified in the access point configuration:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * 
 * 
 * Stack stack = new Stack();
 * Bucket bucket = new Bucket(stack, "MyBucket");
 * Function handler = Function.Builder.create(stack, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset("lambda.zip"))
 *         .build();
 * AccessPoint.Builder.create(stack, "MyObjectLambda")
 *         .bucket(bucket)
 *         .handler(handler)
 *         .accessPointName("my-access-point")
 *         .supportsGetObjectRange(true)
 *         .supportsGetObjectPartNumber(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Pass additional data to Lambda function</h2>
 * <p>
 * You can specify an additional object that provides supplemental data to the Lambda function used to transform objects. The data is delivered as a JSON payload to the Lambda:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * 
 * 
 * Stack stack = new Stack();
 * Bucket bucket = new Bucket(stack, "MyBucket");
 * Function handler = Function.Builder.create(stack, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset("lambda.zip"))
 *         .build();
 * AccessPoint.Builder.create(stack, "MyObjectLambda")
 *         .bucket(bucket)
 *         .handler(handler)
 *         .accessPointName("my-access-point")
 *         .payload(Map.of(
 *                 "prop", "value"))
 *         .build();
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.s3objectlambda;
