package software.amazon.awscdk.services.secretsmanager;

/**
 * (experimental) A secret rotation serverless application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Secret mySecret;
 * IConnectable myDatabase;
 * Vpc myVpc;
 * SecretRotation.Builder.create(this, "SecretRotation")
 *         .application(SecretRotationApplication.MYSQL_ROTATION_SINGLE_USER) // MySQL single user scheme
 *         .secret(mySecret)
 *         .target(myDatabase) // a Connectable
 *         .vpc(myVpc) // The VPC where the secret rotation application will be deployed
 *         .excludeCharacters(" %+:;{}")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:10.315Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_secretsmanager.SecretRotationApplication")
public class SecretRotationApplication extends software.amazon.jsii.JsiiObject {

    protected SecretRotationApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretRotationApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        MARIADB_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MARIADB_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MARIADB_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MARIADB_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MONGODB_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MONGODB_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MONGODB_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MONGODB_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MYSQL_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MYSQL_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        MYSQL_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "MYSQL_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        ORACLE_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "ORACLE_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        ORACLE_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "ORACLE_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        POSTGRES_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "POSTGRES_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        POSTGRES_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "POSTGRES_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        REDSHIFT_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "REDSHIFT_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        REDSHIFT_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "REDSHIFT_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        SQLSERVER_ROTATION_MULTI_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "SQLSERVER_ROTATION_MULTI_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        SQLSERVER_ROTATION_SINGLE_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class, "SQLSERVER_ROTATION_SINGLE_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
    }

    /**
     * @param applicationId This parameter is required.
     * @param semanticVersion This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SecretRotationApplication(final @org.jetbrains.annotations.NotNull java.lang.String applicationId, final @org.jetbrains.annotations.NotNull java.lang.String semanticVersion, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretRotationApplicationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(applicationId, "applicationId is required"), java.util.Objects.requireNonNull(semanticVersion, "semanticVersion is required"), options });
    }

    /**
     * @param applicationId This parameter is required.
     * @param semanticVersion This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SecretRotationApplication(final @org.jetbrains.annotations.NotNull java.lang.String applicationId, final @org.jetbrains.annotations.NotNull java.lang.String semanticVersion) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(applicationId, "applicationId is required"), java.util.Objects.requireNonNull(semanticVersion, "semanticVersion is required") });
    }

    /**
     * (experimental) Returns the application ARN for the current partition.
     * <p>
     * Can be used in combination with a <code>CfnMapping</code> to automatically select the correct ARN based on the current partition.
     * <p>
     * @param partition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String applicationArnForPartition(final @org.jetbrains.annotations.NotNull java.lang.String partition) {
        return software.amazon.jsii.Kernel.call(this, "applicationArnForPartition", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(partition, "partition is required") });
    }

    /**
     * (experimental) The semantic version of the app for the current partition.
     * <p>
     * Can be used in combination with a <code>CfnMapping</code> to automatically select the correct version based on the current partition.
     * <p>
     * @param partition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String semanticVersionForPartition(final @org.jetbrains.annotations.NotNull java.lang.String partition) {
        return software.amazon.jsii.Kernel.call(this, "semanticVersionForPartition", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(partition, "partition is required") });
    }

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MARIADB_ROTATION_MULTI_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MARIADB_ROTATION_SINGLE_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for MongoDB using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MONGODB_ROTATION_MULTI_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for MongoDB using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MONGODB_ROTATION_SINGLE_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS MySQL using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MYSQL_ROTATION_MULTI_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS MySQL using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication MYSQL_ROTATION_SINGLE_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS Oracle using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication ORACLE_ROTATION_MULTI_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS Oracle using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication ORACLE_ROTATION_SINGLE_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication POSTGRES_ROTATION_MULTI_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication POSTGRES_ROTATION_SINGLE_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication REDSHIFT_ROTATION_MULTI_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication REDSHIFT_ROTATION_SINGLE_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the multi user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication SQLSERVER_ROTATION_MULTI_USER;

    /**
     * (experimental) Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the single user rotation scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.secretsmanager.SecretRotationApplication SQLSERVER_ROTATION_SINGLE_USER;

    /**
     * (deprecated) The application identifier of the rotation application.
     * <p>
     * @deprecated only valid when deploying to the 'aws' partition. Use `applicationArnForPartition` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) The semantic version of the rotation application.
     * <p>
     * @deprecated only valid when deploying to the 'aws' partition. Use `semanticVersionForPartition` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getSemanticVersion() {
        return software.amazon.jsii.Kernel.get(this, "semanticVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Whether the rotation application uses the mutli user scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getIsMultiUser() {
        return software.amazon.jsii.Kernel.get(this, "isMultiUser", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.SecretRotationApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.SecretRotationApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param applicationId This parameter is required.
         * @param semanticVersion This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String applicationId, final java.lang.String semanticVersion) {
            return new Builder(applicationId, semanticVersion);
        }

        private final java.lang.String applicationId;
        private final java.lang.String semanticVersion;
        private software.amazon.awscdk.services.secretsmanager.SecretRotationApplicationOptions.Builder options;

        private Builder(final java.lang.String applicationId, final java.lang.String semanticVersion) {
            this.applicationId = applicationId;
            this.semanticVersion = semanticVersion;
        }

        /**
         * (experimental) Whether the rotation application uses the mutli user scheme.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param isMultiUser Whether the rotation application uses the mutli user scheme. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder isMultiUser(final java.lang.Boolean isMultiUser) {
            this.options().isMultiUser(isMultiUser);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.SecretRotationApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.secretsmanager.SecretRotationApplication build() {
            return new software.amazon.awscdk.services.secretsmanager.SecretRotationApplication(
                this.applicationId,
                this.semanticVersion,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.secretsmanager.SecretRotationApplicationOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.secretsmanager.SecretRotationApplicationOptions.Builder();
            }
            return this.options;
        }
    }
}
