package software.amazon.awscdk.services.servicediscovery;

/**
 * (experimental) Define a Service Discovery HTTP Namespace.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * // Cloud Map service discovery is currently required for host ejection by outlier detection
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .outlierDetection(OutlierDetection.builder()
 *                         .baseEjectionDuration(Duration.seconds(10))
 *                         .interval(Duration.seconds(30))
 *                         .maxEjectionPercent(50)
 *                         .maxServerErrors(5)
 *                         .build())
 *                 .build())))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:10.617Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_servicediscovery.PrivateDnsNamespace")
public class PrivateDnsNamespace extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.servicediscovery.IPrivateDnsNamespace {

    protected PrivateDnsNamespace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PrivateDnsNamespace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PrivateDnsNamespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IPrivateDnsNamespace fromPrivateDnsNamespaceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespaceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespace.class, "fromPrivateDnsNamespaceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IPrivateDnsNamespace.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Creates a service within the namespace.
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.Service createService(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.DnsServiceProps props) {
        return software.amazon.jsii.Kernel.call(this, "createService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * (experimental) Creates a service within the namespace.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.Service createService(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "createService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Namespace Arn of the namespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespaceArn() {
        return software.amazon.jsii.Kernel.get(this, "namespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Namespace Id of the PrivateDnsNamespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespaceId() {
        return software.amazon.jsii.Kernel.get(this, "namespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the PrivateDnsNamespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPrivateDnsNamespaceArn() {
        return software.amazon.jsii.Kernel.get(this, "privateDnsNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPrivateDnsNamespaceId() {
        return software.amazon.jsii.Kernel.get(this, "privateDnsNamespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPrivateDnsNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "privateDnsNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Type of the namespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.NamespaceType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.NamespaceType.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespaceProps.Builder();
        }

        /**
         * (experimental) A name for the Namespace.
         * <p>
         * @return {@code this}
         * @param name A name for the Namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * (experimental) A description of the Namespace.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description A description of the Namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) The Amazon VPC that you want to associate the namespace with.
         * <p>
         * @return {@code this}
         * @param vpc The Amazon VPC that you want to associate the namespace with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespace build() {
            return new software.amazon.awscdk.services.servicediscovery.PrivateDnsNamespace(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
