package software.amazon.awscdk.services.signer;

/**
 * (experimental) Defines a Signing Profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * SigningProfile signingProfile = SigningProfile.Builder.create(this, "SigningProfile")
 *         .platform(Platform.AWS_LAMBDA_SHA384_ECDSA)
 *         .build();
 * CodeSigningConfig codeSigningConfig = CodeSigningConfig.Builder.create(this, "CodeSigningConfig")
 *         .signingProfiles(List.of(signingProfile))
 *         .build();
 * Function.Builder.create(this, "Function")
 *         .codeSigningConfig(codeSigningConfig)
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:10.808Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_signer.SigningProfile")
public class SigningProfile extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.signer.ISigningProfile {

    protected SigningProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SigningProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SigningProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.signer.SigningProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Creates a Signing Profile construct that represents an external Signing Profile.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs A `SigningProfileAttributes` object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.signer.ISigningProfile fromSigningProfileAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.signer.SigningProfileAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.signer.SigningProfile.class, "fromSigningProfileAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.signer.ISigningProfile.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) The ARN of the signing profile.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSigningProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "signingProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of signing profile.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSigningProfileName() {
        return software.amazon.jsii.Kernel.get(this, "signingProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The version of signing profile.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSigningProfileVersion() {
        return software.amazon.jsii.Kernel.get(this, "signingProfileVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN of signing profile version.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSigningProfileVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "signingProfileVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.signer.SigningProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.signer.SigningProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.signer.SigningProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.signer.SigningProfileProps.Builder();
        }

        /**
         * (experimental) The Signing Platform available for signing profile.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html">https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html</a>
         * @param platform The Signing Platform available for signing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platform(final software.amazon.awscdk.services.signer.Platform platform) {
            this.props.platform(platform);
            return this;
        }

        /**
         * (experimental) The validity period for signatures generated using this signing profile.
         * <p>
         * Default: - 135 months
         * <p>
         * @return {@code this}
         * @param signatureValidity The validity period for signatures generated using this signing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signatureValidity(final software.amazon.awscdk.core.Duration signatureValidity) {
            this.props.signatureValidity(signatureValidity);
            return this;
        }

        /**
         * (experimental) Physical name of this Signing Profile.
         * <p>
         * Default: - Assigned by CloudFormation (recommended).
         * <p>
         * @return {@code this}
         * @param signingProfileName Physical name of this Signing Profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signingProfileName(final java.lang.String signingProfileName) {
            this.props.signingProfileName(signingProfileName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.signer.SigningProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.signer.SigningProfile build() {
            return new software.amazon.awscdk.services.signer.SigningProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
