package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) The data type set for the SNS message attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic topic = new Topic(this, "Topic");
 * // Use a field from the execution data as message.
 * SnsPublish task1 = SnsPublish.Builder.create(this, "Publish1")
 *         .topic(topic)
 *         .integrationPattern(IntegrationPattern.REQUEST_RESPONSE)
 *         .message(TaskInput.fromDataAt("$.state.message"))
 *         .messageAttributes(Map.of(
 *                 "place", MessageAttribute.builder()
 *                         .value(JsonPath.stringAt("$.place"))
 *                         .build(),
 *                 "pic", MessageAttribute.builder()
 *                         // BINARY must be explicitly set
 *                         .dataType(MessageAttributeDataType.BINARY)
 *                         .value(JsonPath.stringAt("$.pic"))
 *                         .build(),
 *                 "people", MessageAttribute.builder()
 *                         .value(4)
 *                         .build(),
 *                 "handles", MessageAttribute.builder()
 *                         .value(List.of("&#64;kslater", "&#64;jjf", null, "&#64;mfanning"))
 *                         .build()))
 *         .build();
 * // Combine a field from the execution data with
 * // a literal object.
 * SnsPublish task2 = SnsPublish.Builder.create(this, "Publish2")
 *         .topic(topic)
 *         .message(TaskInput.fromObject(Map.of(
 *                 "field1", "somedata",
 *                 "field2", JsonPath.stringAt("$.field2"))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes">https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.642Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.MessageAttributeDataType")
public enum MessageAttributeDataType {
    /**
     * (experimental) Strings are Unicode with UTF-8 binary encoding.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STRING,
    /**
     * (experimental) An array, formatted as a string.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes">https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STRING_ARRAY,
    /**
     * (experimental) Numbers are positive or negative integers or floating-point numbers.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes">https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NUMBER,
    /**
     * (experimental) Binary type attributes can store any binary data.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes">https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BINARY,
}
