package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) Configures the timeout and maximum number of retries for processing a transform job invocation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTransformJob.Builder.create(this, "Batch Inference")
 *         .transformJobName("MyTransformJob")
 *         .modelName("MyModelName")
 *         .modelClientOptions(ModelClientOptions.builder()
 *                 .invocationsMaxRetries(3) // default is 0
 *                 .invocationsTimeout(Duration.minutes(5))
 *                 .build())
 *         .transformInput(TransformInput.builder()
 *                 .transformDataSource(TransformDataSource.builder()
 *                         .s3DataSource(TransformS3DataSource.builder()
 *                                 .s3Uri("s3://inputbucket/train")
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .transformOutput(TransformOutput.builder()
 *                 .s3OutputPath("s3://outputbucket/TransformJobOutputPath")
 *                 .build())
 *         .transformResources(TransformResources.builder()
 *                 .instanceCount(1)
 *                 .instanceType(InstanceType.of(InstanceClass.M4, InstanceSize.XLARGE))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.645Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.ModelClientOptions")
@software.amazon.jsii.Jsii.Proxy(ModelClientOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ModelClientOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The maximum number of retries when invocation requests are failing.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInvocationsMaxRetries() {
        return null;
    }

    /**
     * (experimental) The timeout duration for an invocation request.
     * <p>
     * Default: Duration.minutes(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getInvocationsTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ModelClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ModelClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ModelClientOptions> {
        java.lang.Number invocationsMaxRetries;
        software.amazon.awscdk.core.Duration invocationsTimeout;

        /**
         * Sets the value of {@link ModelClientOptions#getInvocationsMaxRetries}
         * @param invocationsMaxRetries The maximum number of retries when invocation requests are failing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invocationsMaxRetries(java.lang.Number invocationsMaxRetries) {
            this.invocationsMaxRetries = invocationsMaxRetries;
            return this;
        }

        /**
         * Sets the value of {@link ModelClientOptions#getInvocationsTimeout}
         * @param invocationsTimeout The timeout duration for an invocation request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invocationsTimeout(software.amazon.awscdk.core.Duration invocationsTimeout) {
            this.invocationsTimeout = invocationsTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ModelClientOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ModelClientOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ModelClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelClientOptions {
        private final java.lang.Number invocationsMaxRetries;
        private final software.amazon.awscdk.core.Duration invocationsTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.invocationsMaxRetries = software.amazon.jsii.Kernel.get(this, "invocationsMaxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.invocationsTimeout = software.amazon.jsii.Kernel.get(this, "invocationsTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.invocationsMaxRetries = builder.invocationsMaxRetries;
            this.invocationsTimeout = builder.invocationsTimeout;
        }

        @Override
        public final java.lang.Number getInvocationsMaxRetries() {
            return this.invocationsMaxRetries;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getInvocationsTimeout() {
            return this.invocationsTimeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInvocationsMaxRetries() != null) {
                data.set("invocationsMaxRetries", om.valueToTree(this.getInvocationsMaxRetries()));
            }
            if (this.getInvocationsTimeout() != null) {
                data.set("invocationsTimeout", om.valueToTree(this.getInvocationsTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.ModelClientOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ModelClientOptions.Jsii$Proxy that = (ModelClientOptions.Jsii$Proxy) o;

            if (this.invocationsMaxRetries != null ? !this.invocationsMaxRetries.equals(that.invocationsMaxRetries) : that.invocationsMaxRetries != null) return false;
            return this.invocationsTimeout != null ? this.invocationsTimeout.equals(that.invocationsTimeout) : that.invocationsTimeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.invocationsMaxRetries != null ? this.invocationsMaxRetries.hashCode() : 0;
            result = 31 * result + (this.invocationsTimeout != null ? this.invocationsTimeout.hashCode() : 0);
            return result;
        }
    }
}
