package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) The Amazon EMR release version to use for the job run.
 * <p>
 * Can be extended to include new EMR releases
 * <p>
 * For example, <code>new ReleaseLabel('emr-x.xx.x-latest');</code>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrContainersStartJobRun.Builder.create(this, "EMR Containers Start Job Run")
 *         .virtualCluster(VirtualClusterInput.fromVirtualClusterId("de92jdei2910fwedz"))
 *         .releaseLabel(ReleaseLabel.EMR_6_2_0)
 *         .jobName("EMR-Containers-Job")
 *         .jobDriver(JobDriver.builder()
 *                 .sparkSubmitJobDriver(SparkSubmitJobDriver.builder()
 *                         .entryPoint(TaskInput.fromText("local:///usr/lib/spark/examples/src/main/python/pi.py"))
 *                         .build())
 *                 .build())
 *         .applicationConfig(List.of(ApplicationConfiguration.builder()
 *                 .classification(Classification.SPARK_DEFAULTS)
 *                 .properties(Map.of(
 *                         "spark.executor.instances", "1",
 *                         "spark.executor.memory", "512M"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.656Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.ReleaseLabel")
public class ReleaseLabel extends software.amazon.jsii.JsiiObject {

    protected ReleaseLabel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReleaseLabel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        EMR_5_32_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel.class, "EMR_5_32_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel.class));
        EMR_5_33_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel.class, "EMR_5_33_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel.class));
        EMR_6_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel.class, "EMR_6_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel.class));
        EMR_6_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel.class, "EMR_6_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel.class));
    }

    /**
     * (experimental) Initializes the label string.
     * <p>
     * @param label A literal string that contains the release-version ex. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ReleaseLabel(final @org.jetbrains.annotations.NotNull java.lang.String label) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(label, "label is required") });
    }

    /**
     * (experimental) EMR Release version 5.32.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel EMR_5_32_0;

    /**
     * (experimental) EMR Release version 5.33.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel EMR_5_33_0;

    /**
     * (experimental) EMR Release version 6.2.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel EMR_6_2_0;

    /**
     * (experimental) EMR Release version 6.3.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.ReleaseLabel EMR_6_3_0;

    /**
     * (experimental) A literal string that contains the release-version ex.
     * <p>
     * 'emr-x.x.x-latest'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getLabel() {
        return software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
