package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) Dataset to be transformed and the Amazon S3 location where it is stored.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTransformJob.Builder.create(this, "Batch Inference")
 *         .transformJobName("MyTransformJob")
 *         .modelName("MyModelName")
 *         .modelClientOptions(ModelClientOptions.builder()
 *                 .invocationsMaxRetries(3) // default is 0
 *                 .invocationsTimeout(Duration.minutes(5))
 *                 .build())
 *         .transformInput(TransformInput.builder()
 *                 .transformDataSource(TransformDataSource.builder()
 *                         .s3DataSource(TransformS3DataSource.builder()
 *                                 .s3Uri("s3://inputbucket/train")
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .transformOutput(TransformOutput.builder()
 *                 .s3OutputPath("s3://outputbucket/TransformJobOutputPath")
 *                 .build())
 *         .transformResources(TransformResources.builder()
 *                 .instanceCount(1)
 *                 .instanceType(InstanceType.of(InstanceClass.M4, InstanceSize.XLARGE))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.758Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.TransformInput")
@software.amazon.jsii.Jsii.Proxy(TransformInput.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TransformInput extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) S3 location of the channel data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource getTransformDataSource();

    /**
     * (experimental) The compression type of the transform data.
     * <p>
     * Default: NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
        return null;
    }

    /**
     * (experimental) Multipurpose internet mail extension (MIME) type of the data.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * (experimental) Method to use to split the transform job's data files into smaller batches.
     * <p>
     * Default: NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.SplitType getSplitType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TransformInput> {
        software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource;
        software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        java.lang.String contentType;
        software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType;

        /**
         * Sets the value of {@link TransformInput#getTransformDataSource}
         * @param transformDataSource S3 location of the channel data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformDataSource(software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource) {
            this.transformDataSource = transformDataSource;
            return this;
        }

        /**
         * Sets the value of {@link TransformInput#getCompressionType}
         * @param compressionType The compression type of the transform data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compressionType(software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        /**
         * Sets the value of {@link TransformInput#getContentType}
         * @param contentType Multipurpose internet mail extension (MIME) type of the data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link TransformInput#getSplitType}
         * @param splitType Method to use to split the transform job's data files into smaller batches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder splitType(software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType) {
            this.splitType = splitType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransformInput}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TransformInput build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformInput {
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource;
        private final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        private final java.lang.String contentType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.transformDataSource = software.amazon.jsii.Kernel.get(this, "transformDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource.class));
            this.compressionType = software.amazon.jsii.Kernel.get(this, "compressionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.CompressionType.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.splitType = software.amazon.jsii.Kernel.get(this, "splitType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.SplitType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.transformDataSource = java.util.Objects.requireNonNull(builder.transformDataSource, "transformDataSource is required");
            this.compressionType = builder.compressionType;
            this.contentType = builder.contentType;
            this.splitType = builder.splitType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource getTransformDataSource() {
            return this.transformDataSource;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
            return this.compressionType;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.SplitType getSplitType() {
            return this.splitType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("transformDataSource", om.valueToTree(this.getTransformDataSource()));
            if (this.getCompressionType() != null) {
                data.set("compressionType", om.valueToTree(this.getCompressionType()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getSplitType() != null) {
                data.set("splitType", om.valueToTree(this.getSplitType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.TransformInput"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransformInput.Jsii$Proxy that = (TransformInput.Jsii$Proxy) o;

            if (!transformDataSource.equals(that.transformDataSource)) return false;
            if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            return this.splitType != null ? this.splitType.equals(that.splitType) : that.splitType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.transformDataSource.hashCode();
            result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.splitType != null ? this.splitType.hashCode() : 0);
            return result;
        }
    }
}
