package software.amazon.awscdk.services.waf.regional;

/**
 * Properties for defining a `CfnRegexPatternSet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnRegexPatternSetProps cfnRegexPatternSetProps = CfnRegexPatternSetProps.builder()
 *         .name("name")
 *         .regexPatternStrings(List.of("regexPatternStrings"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.069Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_wafregional.CfnRegexPatternSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnRegexPatternSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRegexPatternSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A friendly name or description of the `RegexPatternSet` .
     * <p>
     * You can't change <code>Name</code> after you create a <code>RegexPatternSet</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegexPatternStrings();

    /**
     * @return a {@link Builder} of {@link CfnRegexPatternSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRegexPatternSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRegexPatternSetProps> {
        java.lang.String name;
        java.util.List<java.lang.String> regexPatternStrings;

        /**
         * Sets the value of {@link CfnRegexPatternSetProps#getName}
         * @param name A friendly name or description of the `RegexPatternSet` . This parameter is required.
         *             You can't change <code>Name</code> after you create a <code>RegexPatternSet</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRegexPatternSetProps#getRegexPatternStrings}
         * @param regexPatternStrings Specifies the regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t` . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regexPatternStrings(java.util.List<java.lang.String> regexPatternStrings) {
            this.regexPatternStrings = regexPatternStrings;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRegexPatternSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRegexPatternSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRegexPatternSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRegexPatternSetProps {
        private final java.lang.String name;
        private final java.util.List<java.lang.String> regexPatternStrings;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regexPatternStrings = software.amazon.jsii.Kernel.get(this, "regexPatternStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.regexPatternStrings = java.util.Objects.requireNonNull(builder.regexPatternStrings, "regexPatternStrings is required");
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getRegexPatternStrings() {
            return this.regexPatternStrings;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("regexPatternStrings", om.valueToTree(this.getRegexPatternStrings()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_wafregional.CfnRegexPatternSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRegexPatternSetProps.Jsii$Proxy that = (CfnRegexPatternSetProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            return this.regexPatternStrings.equals(that.regexPatternStrings);
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.regexPatternStrings.hashCode());
            return result;
        }
    }
}
