package software.amazon.awscdk.services.wafv2;

/**
 * Properties for defining a `CfnWebACLAssociation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * CfnWebACLAssociationProps cfnWebACLAssociationProps = CfnWebACLAssociationProps.builder()
 *         .resourceArn("resourceArn")
 *         .webAclArn("webAclArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.601Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_wafv2.CfnWebACLAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnWebACLAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWebACLAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the resource to associate with the web ACL.
     * <p>
     * The ARN must be in one of the following formats:
     * <p>
     * <ul>
     * <li>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing: *region* : *account-id* :loadbalancer/app/ *load-balancer-name* / *load-balancer-id*</code></li>
     * <li>For an Amazon API Gateway REST API: <code>arn:aws:apigateway: *region* ::/restapis/ *api-id* /stages/ *stage-name*</code></li>
     * <li>For an AWS AppSync GraphQL API: <code>arn:aws:appsync: *region* : *account-id* :apis/ *GraphQLApiId*</code></li>
     * <li>For an Amazon Cognito user pool: <code>arn:aws:cognito-idp: *region* : *account-id* :userpool/ *user-pool-id*</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebAclArn();

    /**
     * @return a {@link Builder} of {@link CfnWebACLAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWebACLAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWebACLAssociationProps> {
        java.lang.String resourceArn;
        java.lang.String webAclArn;

        /**
         * Sets the value of {@link CfnWebACLAssociationProps#getResourceArn}
         * @param resourceArn The Amazon Resource Name (ARN) of the resource to associate with the web ACL. This parameter is required.
         *                    The ARN must be in one of the following formats:
         *                    <p>
         *                    <ul>
         *                    <li>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing: *region* : *account-id* :loadbalancer/app/ *load-balancer-name* / *load-balancer-id*</code></li>
         *                    <li>For an Amazon API Gateway REST API: <code>arn:aws:apigateway: *region* ::/restapis/ *api-id* /stages/ *stage-name*</code></li>
         *                    <li>For an AWS AppSync GraphQL API: <code>arn:aws:appsync: *region* : *account-id* :apis/ *GraphQLApiId*</code></li>
         *                    <li>For an Amazon Cognito user pool: <code>arn:aws:cognito-idp: *region* : *account-id* :userpool/ *user-pool-id*</code></li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(java.lang.String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLAssociationProps#getWebAclArn}
         * @param webAclArn The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclArn(java.lang.String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWebACLAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWebACLAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWebACLAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWebACLAssociationProps {
        private final java.lang.String resourceArn;
        private final java.lang.String webAclArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webAclArn = software.amazon.jsii.Kernel.get(this, "webAclArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            this.webAclArn = java.util.Objects.requireNonNull(builder.webAclArn, "webAclArn is required");
        }

        @Override
        public final java.lang.String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final java.lang.String getWebAclArn() {
            return this.webAclArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceArn", om.valueToTree(this.getResourceArn()));
            data.set("webAclArn", om.valueToTree(this.getWebAclArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_wafv2.CfnWebACLAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWebACLAssociationProps.Jsii$Proxy that = (CfnWebACLAssociationProps.Jsii$Proxy) o;

            if (!resourceArn.equals(that.resourceArn)) return false;
            return this.webAclArn.equals(that.webAclArn);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceArn.hashCode();
            result = 31 * result + (this.webAclArn.hashCode());
            return result;
        }
    }
}
