package software.amazon.awscdk.appdelivery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * public class MyServiceStackA extends Stack {
 * }
 * public class MyServiceStackB extends Stack {
 * }
 * App app = new App();
 * // We define a stack that contains the CodePipeline
 * Stack pipelineStack = new Stack(app, "PipelineStack");
 * Pipeline pipeline = Pipeline.Builder.create(pipelineStack, "CodePipeline")
 *         // Mutating a CodePipeline can cause the currently propagating state to be
 *         // "lost". Ensure we re-run the latest change through the pipeline after it's
 *         // been mutated so we're sure the latest state is fully deployed through.
 *         .restartExecutionOnUpdate(true)
 *         .build();
 * // Configure the CodePipeline source - where your CDK App's source code is hosted
 * Artifact sourceOutput = new Artifact();
 * GitHubSourceAction source = GitHubSourceAction.Builder.create()
 *         .actionName("GitHub")
 *         .output(sourceOutput)
 *         .owner("myName")
 *         .repo("myRepo")
 *         .oauthToken(SecretValue.unsafePlainText("secret"))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("source")
 *         .actions(List.of(source))
 *         .build());
 * PipelineProject project = PipelineProject.Builder.create(pipelineStack, "CodeBuild").build();
 * Artifact synthesizedApp = new Artifact();
 * CodeBuildAction buildAction = CodeBuildAction.Builder.create()
 *         .actionName("CodeBuild")
 *         .project(project)
 *         .input(sourceOutput)
 *         .outputs(List.of(synthesizedApp))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("build")
 *         .actions(List.of(buildAction))
 *         .build());
 * // Optionally, self-update the pipeline stack
 * IStage selfUpdateStage = pipeline.addStage(StageOptions.builder().stageName("SelfUpdate").build());
 * selfUpdateStage.addAction(PipelineDeployStackAction.Builder.create()
 *         .stack(pipelineStack)
 *         .input(synthesizedApp)
 *         .adminPermissions(true)
 *         .build());
 * // Now add our service stacks
 * IStage deployStage = pipeline.addStage(StageOptions.builder().stageName("Deploy").build());
 * MyServiceStackA serviceStackA = MyServiceStackA.Builder.create(app, "ServiceStackA").build();
 * // Add actions to deploy the stacks in the deploy stage:
 * PipelineDeployStackAction deployServiceAAction = PipelineDeployStackAction.Builder.create()
 *         .stack(serviceStackA)
 *         .input(synthesizedApp)
 *         // See the note below for details about this option.
 *         .adminPermissions(false)
 *         .build();
 * deployStage.addAction(deployServiceAAction);
 * // Add the necessary permissions for you service deploy action. This role is
 * // is passed to CloudFormation and needs the permissions necessary to deploy
 * // stack. Alternatively you can enable [Administrator](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_job-functions.html#jf_administrator) permissions above,
 * // users should understand the privileged nature of this role.
 * String myResourceArn = "arn:partition:service:region:account-id:resource-id";
 * deployServiceAAction.addToDeploymentRolePolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("service:SomeAction"))
 *         .resources(List.of(myResourceArn))
 *         .build());
 * MyServiceStackB serviceStackB = MyServiceStackB.Builder.create(app, "ServiceStackB").build();
 * deployStage.addAction(PipelineDeployStackAction.Builder.create()
 *         .stack(serviceStackB)
 *         .input(synthesizedApp)
 *         .createChangeSetRunOrder(998)
 *         .adminPermissions(true)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:53.067Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.app_delivery.PipelineDeployStackActionProps")
@software.amazon.jsii.Jsii.Proxy(PipelineDeployStackActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PipelineDeployStackActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Whether to grant admin permissions to CloudFormation while deploying this template.
     * <p>
     * Setting this to <code>true</code> affects the defaults for <code>role</code> and <code>capabilities</code>, if you
     * don't specify any alternatives.
     * <p>
     * The default role that will be created for you will have admin (i.e., <code>*</code>)
     * permissions on all resources, and the deployment will have named IAM
     * capabilities (i.e., able to create all IAM resources).
     * <p>
     * This is a shorthand that you can use if you fully trust the templates that
     * are deployed in this pipeline. If you want more fine-grained permissions,
     * use <code>addToRolePolicy</code> and <code>capabilities</code> to control what the CloudFormation
     * deployment is allowed to do.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getAdminPermissions();

    /**
     * (experimental) The CodePipeline artifact that holds the synthesized app, which is the contents of the ``<directory>`` when running ``cdk synth -o <directory>``.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getInput();

    /**
     * (experimental) The CDK stack to be deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack();

    /**
     * (experimental) Acknowledge certain changes made as part of deployment.
     * <p>
     * For stacks that contain certain resources, explicit acknowledgement that AWS CloudFormation
     * might create or update those resources. For example, you must specify AnonymousIAM if your
     * stack template contains AWS Identity and Access Management (IAM) resources. For more
     * information
     * <p>
     * Default: [AnonymousIAM, AutoExpand], unless `adminPermissions` is true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> getCapabilities() {
        return null;
    }

    /**
     * (experimental) The name to use when creating a ChangeSet for the stack.
     * <p>
     * Default: CDK-CodePipeline-ChangeSet
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getChangeSetName() {
        return null;
    }

    /**
     * (experimental) The name of the CodePipeline action creating the ChangeSet.
     * <p>
     * Default: 'ChangeSet'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCreateChangeSetActionName() {
        return null;
    }

    /**
     * (experimental) The runOrder for the CodePipeline action creating the ChangeSet.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCreateChangeSetRunOrder() {
        return null;
    }

    /**
     * (experimental) The name of the CodePipeline action creating the ChangeSet.
     * <p>
     * Default: 'Execute'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecuteChangeSetActionName() {
        return null;
    }

    /**
     * (experimental) The runOrder for the CodePipeline action executing the ChangeSet.
     * <p>
     * Default: ``createChangeSetRunOrder + 1``
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getExecuteChangeSetRunOrder() {
        return null;
    }

    /**
     * (experimental) IAM role to assume when deploying changes.
     * <p>
     * If not specified, a fresh role is created. The role is created with zero
     * permissions unless <code>adminPermissions</code> is true, in which case the role will have
     * admin permissions.
     * <p>
     * Default: A fresh role with admin or no permissions (depending on the value of `adminPermissions`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PipelineDeployStackActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineDeployStackActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PipelineDeployStackActionProps> {
        java.lang.Boolean adminPermissions;
        software.amazon.awscdk.services.codepipeline.Artifact input;
        software.amazon.awscdk.core.Stack stack;
        java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities;
        java.lang.String changeSetName;
        java.lang.String createChangeSetActionName;
        java.lang.Number createChangeSetRunOrder;
        java.lang.String executeChangeSetActionName;
        java.lang.Number executeChangeSetRunOrder;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getAdminPermissions}
         * @param adminPermissions Whether to grant admin permissions to CloudFormation while deploying this template. This parameter is required.
         *                         Setting this to <code>true</code> affects the defaults for <code>role</code> and <code>capabilities</code>, if you
         *                         don't specify any alternatives.
         *                         <p>
         *                         The default role that will be created for you will have admin (i.e., <code>*</code>)
         *                         permissions on all resources, and the deployment will have named IAM
         *                         capabilities (i.e., able to create all IAM resources).
         *                         <p>
         *                         This is a shorthand that you can use if you fully trust the templates that
         *                         are deployed in this pipeline. If you want more fine-grained permissions,
         *                         use <code>addToRolePolicy</code> and <code>capabilities</code> to control what the CloudFormation
         *                         deployment is allowed to do.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminPermissions(java.lang.Boolean adminPermissions) {
            this.adminPermissions = adminPermissions;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getInput}
         * @param input The CodePipeline artifact that holds the synthesized app, which is the contents of the ``<directory>`` when running ``cdk synth -o <directory>``. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder input(software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getStack}
         * @param stack The CDK stack to be deployed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stack(software.amazon.awscdk.core.Stack stack) {
            this.stack = stack;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getCapabilities}
         * @param capabilities Acknowledge certain changes made as part of deployment.
         *                     For stacks that contain certain resources, explicit acknowledgement that AWS CloudFormation
         *                     might create or update those resources. For example, you must specify AnonymousIAM if your
         *                     stack template contains AWS Identity and Access Management (IAM) resources. For more
         *                     information
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder capabilities(java.util.List<? extends software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities) {
            this.capabilities = (java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities>)capabilities;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getChangeSetName}
         * @param changeSetName The name to use when creating a ChangeSet for the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder changeSetName(java.lang.String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getCreateChangeSetActionName}
         * @param createChangeSetActionName The name of the CodePipeline action creating the ChangeSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder createChangeSetActionName(java.lang.String createChangeSetActionName) {
            this.createChangeSetActionName = createChangeSetActionName;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getCreateChangeSetRunOrder}
         * @param createChangeSetRunOrder The runOrder for the CodePipeline action creating the ChangeSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder createChangeSetRunOrder(java.lang.Number createChangeSetRunOrder) {
            this.createChangeSetRunOrder = createChangeSetRunOrder;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getExecuteChangeSetActionName}
         * @param executeChangeSetActionName The name of the CodePipeline action creating the ChangeSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executeChangeSetActionName(java.lang.String executeChangeSetActionName) {
            this.executeChangeSetActionName = executeChangeSetActionName;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getExecuteChangeSetRunOrder}
         * @param executeChangeSetRunOrder The runOrder for the CodePipeline action executing the ChangeSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executeChangeSetRunOrder(java.lang.Number executeChangeSetRunOrder) {
            this.executeChangeSetRunOrder = executeChangeSetRunOrder;
            return this;
        }

        /**
         * Sets the value of {@link PipelineDeployStackActionProps#getRole}
         * @param role IAM role to assume when deploying changes.
         *             If not specified, a fresh role is created. The role is created with zero
         *             permissions unless <code>adminPermissions</code> is true, in which case the role will have
         *             admin permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineDeployStackActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PipelineDeployStackActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PipelineDeployStackActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineDeployStackActionProps {
        private final java.lang.Boolean adminPermissions;
        private final software.amazon.awscdk.services.codepipeline.Artifact input;
        private final software.amazon.awscdk.core.Stack stack;
        private final java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities;
        private final java.lang.String changeSetName;
        private final java.lang.String createChangeSetActionName;
        private final java.lang.Number createChangeSetRunOrder;
        private final java.lang.String executeChangeSetActionName;
        private final java.lang.Number executeChangeSetRunOrder;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.adminPermissions = software.amazon.jsii.Kernel.get(this, "adminPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.stack = software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
            this.capabilities = software.amazon.jsii.Kernel.get(this, "capabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities.class)));
            this.changeSetName = software.amazon.jsii.Kernel.get(this, "changeSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.createChangeSetActionName = software.amazon.jsii.Kernel.get(this, "createChangeSetActionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.createChangeSetRunOrder = software.amazon.jsii.Kernel.get(this, "createChangeSetRunOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.executeChangeSetActionName = software.amazon.jsii.Kernel.get(this, "executeChangeSetActionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executeChangeSetRunOrder = software.amazon.jsii.Kernel.get(this, "executeChangeSetRunOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adminPermissions = java.util.Objects.requireNonNull(builder.adminPermissions, "adminPermissions is required");
            this.input = java.util.Objects.requireNonNull(builder.input, "input is required");
            this.stack = java.util.Objects.requireNonNull(builder.stack, "stack is required");
            this.capabilities = (java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities>)builder.capabilities;
            this.changeSetName = builder.changeSetName;
            this.createChangeSetActionName = builder.createChangeSetActionName;
            this.createChangeSetRunOrder = builder.createChangeSetRunOrder;
            this.executeChangeSetActionName = builder.executeChangeSetActionName;
            this.executeChangeSetRunOrder = builder.executeChangeSetRunOrder;
            this.role = builder.role;
        }

        @Override
        public final java.lang.Boolean getAdminPermissions() {
            return this.adminPermissions;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getInput() {
            return this.input;
        }

        @Override
        public final software.amazon.awscdk.core.Stack getStack() {
            return this.stack;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final java.lang.String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final java.lang.String getCreateChangeSetActionName() {
            return this.createChangeSetActionName;
        }

        @Override
        public final java.lang.Number getCreateChangeSetRunOrder() {
            return this.createChangeSetRunOrder;
        }

        @Override
        public final java.lang.String getExecuteChangeSetActionName() {
            return this.executeChangeSetActionName;
        }

        @Override
        public final java.lang.Number getExecuteChangeSetRunOrder() {
            return this.executeChangeSetRunOrder;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("adminPermissions", om.valueToTree(this.getAdminPermissions()));
            data.set("input", om.valueToTree(this.getInput()));
            data.set("stack", om.valueToTree(this.getStack()));
            if (this.getCapabilities() != null) {
                data.set("capabilities", om.valueToTree(this.getCapabilities()));
            }
            if (this.getChangeSetName() != null) {
                data.set("changeSetName", om.valueToTree(this.getChangeSetName()));
            }
            if (this.getCreateChangeSetActionName() != null) {
                data.set("createChangeSetActionName", om.valueToTree(this.getCreateChangeSetActionName()));
            }
            if (this.getCreateChangeSetRunOrder() != null) {
                data.set("createChangeSetRunOrder", om.valueToTree(this.getCreateChangeSetRunOrder()));
            }
            if (this.getExecuteChangeSetActionName() != null) {
                data.set("executeChangeSetActionName", om.valueToTree(this.getExecuteChangeSetActionName()));
            }
            if (this.getExecuteChangeSetRunOrder() != null) {
                data.set("executeChangeSetRunOrder", om.valueToTree(this.getExecuteChangeSetRunOrder()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.app_delivery.PipelineDeployStackActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineDeployStackActionProps.Jsii$Proxy that = (PipelineDeployStackActionProps.Jsii$Proxy) o;

            if (!adminPermissions.equals(that.adminPermissions)) return false;
            if (!input.equals(that.input)) return false;
            if (!stack.equals(that.stack)) return false;
            if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) return false;
            if (this.changeSetName != null ? !this.changeSetName.equals(that.changeSetName) : that.changeSetName != null) return false;
            if (this.createChangeSetActionName != null ? !this.createChangeSetActionName.equals(that.createChangeSetActionName) : that.createChangeSetActionName != null) return false;
            if (this.createChangeSetRunOrder != null ? !this.createChangeSetRunOrder.equals(that.createChangeSetRunOrder) : that.createChangeSetRunOrder != null) return false;
            if (this.executeChangeSetActionName != null ? !this.executeChangeSetActionName.equals(that.executeChangeSetActionName) : that.executeChangeSetActionName != null) return false;
            if (this.executeChangeSetRunOrder != null ? !this.executeChangeSetRunOrder.equals(that.executeChangeSetRunOrder) : that.executeChangeSetRunOrder != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.adminPermissions.hashCode();
            result = 31 * result + (this.input.hashCode());
            result = 31 * result + (this.stack.hashCode());
            result = 31 * result + (this.capabilities != null ? this.capabilities.hashCode() : 0);
            result = 31 * result + (this.changeSetName != null ? this.changeSetName.hashCode() : 0);
            result = 31 * result + (this.createChangeSetActionName != null ? this.createChangeSetActionName.hashCode() : 0);
            result = 31 * result + (this.createChangeSetRunOrder != null ? this.createChangeSetRunOrder.hashCode() : 0);
            result = 31 * result + (this.executeChangeSetActionName != null ? this.executeChangeSetActionName.hashCode() : 0);
            result = 31 * result + (this.executeChangeSetRunOrder != null ? this.executeChangeSetRunOrder.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
