package software.amazon.awscdk.cloudassembly.schema;

/**
 * (experimental) Query input for looking up a load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * LoadBalancerContextQuery loadBalancerContextQuery = LoadBalancerContextQuery.builder()
 *         .account("account")
 *         .loadBalancerType(LoadBalancerType.NETWORK)
 *         .region("region")
 *         // the properties below are optional
 *         .loadBalancerArn("loadBalancerArn")
 *         .loadBalancerTags(List.of(Tag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .lookupRoleArn("lookupRoleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.003Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.cloud_assembly_schema.LoadBalancerContextQuery")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerContextQuery.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LoadBalancerContextQuery extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloudassembly.schema.LoadBalancerFilter {

    /**
     * (experimental) Query account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAccount();

    /**
     * (experimental) Query region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getRegion();

    /**
     * (experimental) The ARN of the role that should be used to look up the missing values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getLookupRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerContextQuery> {
        java.lang.String account;
        java.lang.String region;
        java.lang.String lookupRoleArn;
        software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType;
        java.lang.String loadBalancerArn;
        java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags;

        /**
         * Sets the value of {@link LoadBalancerContextQuery#getAccount}
         * @param account Query account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextQuery#getRegion}
         * @param region Query region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextQuery#getLookupRoleArn}
         * @param lookupRoleArn The ARN of the role that should be used to look up the missing values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextQuery#getLoadBalancerType}
         * @param loadBalancerType Filter load balancers by their type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loadBalancerType(software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType) {
            this.loadBalancerType = loadBalancerType;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextQuery#getLoadBalancerArn}
         * @param loadBalancerArn Find by load balancer's ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextQuery#getLoadBalancerTags}
         * @param loadBalancerTags Match load balancer tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder loadBalancerTags(java.util.List<? extends software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags) {
            this.loadBalancerTags = (java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag>)loadBalancerTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LoadBalancerContextQuery build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadBalancerContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerContextQuery {
        private final java.lang.String account;
        private final java.lang.String region;
        private final java.lang.String lookupRoleArn;
        private final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType;
        private final java.lang.String loadBalancerArn;
        private final java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerType = software.amazon.jsii.Kernel.get(this, "loadBalancerType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.LoadBalancerType.class));
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerTags = software.amazon.jsii.Kernel.get(this, "loadBalancerTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.Tag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = java.util.Objects.requireNonNull(builder.account, "account is required");
            this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            this.lookupRoleArn = builder.lookupRoleArn;
            this.loadBalancerType = java.util.Objects.requireNonNull(builder.loadBalancerType, "loadBalancerType is required");
            this.loadBalancerArn = builder.loadBalancerArn;
            this.loadBalancerTags = (java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag>)builder.loadBalancerTags;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> getLoadBalancerTags() {
            return this.loadBalancerTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("account", om.valueToTree(this.getAccount()));
            data.set("region", om.valueToTree(this.getRegion()));
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            data.set("loadBalancerType", om.valueToTree(this.getLoadBalancerType()));
            if (this.getLoadBalancerArn() != null) {
                data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            }
            if (this.getLoadBalancerTags() != null) {
                data.set("loadBalancerTags", om.valueToTree(this.getLoadBalancerTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.cloud_assembly_schema.LoadBalancerContextQuery"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerContextQuery.Jsii$Proxy that = (LoadBalancerContextQuery.Jsii$Proxy) o;

            if (!account.equals(that.account)) return false;
            if (!region.equals(that.region)) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            if (!loadBalancerType.equals(that.loadBalancerType)) return false;
            if (this.loadBalancerArn != null ? !this.loadBalancerArn.equals(that.loadBalancerArn) : that.loadBalancerArn != null) return false;
            return this.loadBalancerTags != null ? this.loadBalancerTags.equals(that.loadBalancerTags) : that.loadBalancerTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.account.hashCode();
            result = 31 * result + (this.region.hashCode());
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.loadBalancerType.hashCode());
            result = 31 * result + (this.loadBalancerArn != null ? this.loadBalancerArn.hashCode() : 0);
            result = 31 * result + (this.loadBalancerTags != null ? this.loadBalancerTags.hashCode() : 0);
            return result;
        }
    }
}
