package software.amazon.awscdk.cloudassembly.schema;

/**
 * (experimental) In what scenarios should the CLI ask for approval.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app = new App();
 * Stack stackUnderTest = new Stack(app, "StackUnderTest");
 * Stack stack = new Stack(app, "stack");
 * IntegTest testCase = IntegTest.Builder.create(app, "CustomizedDeploymentWorkflow")
 *         .testCases(List.of(stackUnderTest))
 *         .diffAssets(true)
 *         .stackUpdateWorkflow(true)
 *         .cdkCommandOptions(CdkCommands.builder()
 *                 .deploy(DeployCommand.builder()
 *                         .args(DeployOptions.builder()
 *                                 .requireApproval(RequireApproval.NEVER)
 *                                 .json(true)
 *                                 .build())
 *                         .build())
 *                 .destroy(DestroyCommand.builder()
 *                         .args(DestroyOptions.builder()
 *                                 .force(true)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.012Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.cloud_assembly_schema.RequireApproval")
public enum RequireApproval {
    /**
     * (experimental) Never ask for approval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NEVER,
    /**
     * (experimental) Prompt for approval for any type  of change to the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ANYCHANGE,
    /**
     * (experimental) Only prompt for approval if there are security related changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BROADENING,
}
