package software.amazon.awscdk.core;

/**
 * (experimental) Includes API for attaching annotations such as warning messages to constructs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.constructs.Construct;
 * import software.constructs.IConstruct;
 * public class MyAspect implements IAspect {
 *     public void visit(IConstruct node) {
 *         if (node instanceof CfnResource &amp;&amp; node.getCfnResourceType() == "Foo::Bar") {
 *             this.error(node, "we do not want a Foo::Bar resource");
 *         }
 *     }
 *     public void error(IConstruct node, String message) {
 *         Annotations.of(node).addError(message);
 *     }
 * }
 * public class MyStack extends Stack {
 *     public MyStack(Construct scope, String id) {
 *         super(scope, id);
 *         Stack stack = new Stack();
 *         CfnResource.Builder.create(stack, "Foo")
 *                 .type("Foo::Bar")
 *                 .properties(Map.of(
 *                         "Fred", "Thud"))
 *                 .build();
 *         Aspects.of(stack).add(new MyAspect());
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:52.713Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.Annotations")
public class Annotations extends software.amazon.jsii.JsiiObject {

    protected Annotations(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Annotations(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Returns the annotations API for a construct scope.
     * <p>
     * @param scope The scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Annotations of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Annotations.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Annotations.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * (experimental) Adds a deprecation warning for a specific API.
     * <p>
     * Deprecations will be added only once per construct as a warning and will be
     * deduplicated based on the <code>api</code>.
     * <p>
     * If the environment variable <code>CDK_BLOCK_DEPRECATIONS</code> is set, this method
     * will throw an error instead with the deprecation message.
     * <p>
     * @param api The API being deprecated in the format `module.Class.property` (e.g. `@aws-cdk/core.Construct.node`). This parameter is required.
     * @param message The deprecation message to display, with information about alternatives. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addDeprecation(final @org.jetbrains.annotations.NotNull java.lang.String api, final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addDeprecation", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(api, "api is required"), java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * (experimental) Adds an { "error": <message> } metadata entry to this construct.
     * <p>
     * The toolkit will fail deployment of any stack that has errors reported against it.
     * <p>
     * @param message The error message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addError(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addError", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * (experimental) Adds an info metadata entry to this construct.
     * <p>
     * The CLI will display the info message when apps are synthesized.
     * <p>
     * @param message The info message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addInfo(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addInfo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * (experimental) Adds a warning metadata entry to this construct.
     * <p>
     * The CLI will display the warning when an app is synthesized, or fail if run
     * in --strict mode.
     * <p>
     * @param message The warning message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addWarning(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addWarning", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }
}
