package software.amazon.awscdk.core;

/**
 * (experimental) A CloudFormation Hook for CodeDeploy blue-green ECS deployments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnInclude cfnTemplate;
 * // mutating the hook
 * Role myRole;
 * CfnHook hook = cfnTemplate.getHook("MyOutput");
 * CfnCodeDeployBlueGreenHook codeDeployHook = (CfnCodeDeployBlueGreenHook)hook;
 * codeDeployHook.getServiceRole() = myRole.getRoleArn();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html#blue-green-template-reference">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html#blue-green-template-reference</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:52.742Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnCodeDeployBlueGreenHook")
public class CfnCodeDeployBlueGreenHook extends software.amazon.awscdk.core.CfnHook {

    protected CfnCodeDeployBlueGreenHook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCodeDeployBlueGreenHook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Creates a new CodeDeploy blue-green ECS Hook.
     * <p>
     * @param scope the scope to create the hook in (usually the containing Stack object). This parameter is required.
     * @param id the identifier of the construct - will be used to generate the logical ID of the Hook. This parameter is required.
     * @param props the properties of the Hook. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CfnCodeDeployBlueGreenHook(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnCodeDeployBlueGreenHookProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param _props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> _props) {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { _props }))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> getApplications() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication.class))));
    }

    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setApplications(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> value) {
        software.amazon.jsii.Kernel.set(this, "applications", java.util.Objects.requireNonNull(value, "applications is required"));
    }

    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setServiceRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRole", java.util.Objects.requireNonNull(value, "serviceRole is required"));
    }

    /**
     * (experimental) Additional options for the blue/green deployment.
     * <p>
     * Default: - no additional options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions getAdditionalOptions() {
        return software.amazon.jsii.Kernel.get(this, "additionalOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions.class));
    }

    /**
     * (experimental) Additional options for the blue/green deployment.
     * <p>
     * Default: - no additional options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setAdditionalOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions value) {
        software.amazon.jsii.Kernel.set(this, "additionalOptions", value);
    }

    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     * <p>
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {&#64;link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     * <p>
     * Default: - no lifecycle event hooks
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks getLifecycleEventHooks() {
        return software.amazon.jsii.Kernel.get(this, "lifecycleEventHooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks.class));
    }

    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     * <p>
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {&#64;link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     * <p>
     * Default: - no lifecycle event hooks
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setLifecycleEventHooks(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleEventHooks", value);
    }

    /**
     * (experimental) Traffic routing configuration settings.
     * <p>
     * Default: - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnTrafficRoutingConfig getTrafficRoutingConfig() {
        return software.amazon.jsii.Kernel.get(this, "trafficRoutingConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTrafficRoutingConfig.class));
    }

    /**
     * (experimental) Traffic routing configuration settings.
     * <p>
     * Default: - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setTrafficRoutingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnTrafficRoutingConfig value) {
        software.amazon.jsii.Kernel.set(this, "trafficRoutingConfig", value);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope the scope to create the hook in (usually the containing Stack object). This parameter is required.
         * @param id the identifier of the construct - will be used to generate the logical ID of the Hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.CfnCodeDeployBlueGreenHookProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.core.CfnCodeDeployBlueGreenHookProps.Builder();
        }

        /**
         * (experimental) Properties of the Amazon ECS applications being deployed.
         * <p>
         * @return {@code this}
         * @param applications Properties of the Amazon ECS applications being deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applications(final java.util.List<? extends software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> applications) {
            this.props.applications(applications);
            return this;
        }

        /**
         * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM Role for CloudFormation to use to perform blue-green deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceRole(final java.lang.String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * (experimental) Additional options for the blue/green deployment.
         * <p>
         * Default: - no additional options
         * <p>
         * @return {@code this}
         * @param additionalOptions Additional options for the blue/green deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder additionalOptions(final software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions additionalOptions) {
            this.props.additionalOptions(additionalOptions);
            return this;
        }

        /**
         * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
         * <p>
         * You can use the same function or a different one for deployment lifecycle events.
         * Following completion of the validation tests,
         * the Lambda {&#64;link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
         * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
         * <p>
         * Default: - no lifecycle event hooks
         * <p>
         * @return {@code this}
         * @param lifecycleEventHooks Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycleEventHooks(final software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks lifecycleEventHooks) {
            this.props.lifecycleEventHooks(lifecycleEventHooks);
            return this;
        }

        /**
         * (experimental) Traffic routing configuration settings.
         * <p>
         * Default: - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
         * <p>
         * @return {@code this}
         * @param trafficRoutingConfig Traffic routing configuration settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trafficRoutingConfig(final software.amazon.awscdk.core.CfnTrafficRoutingConfig trafficRoutingConfig) {
            this.props.trafficRoutingConfig(trafficRoutingConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook build() {
            return new software.amazon.awscdk.core.CfnCodeDeployBlueGreenHook(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
