package software.amazon.awscdk.core;

/**
 * (experimental) Construction properties of {@link CfnCodeDeployBlueGreenHook}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * CfnCodeDeployBlueGreenHookProps cfnCodeDeployBlueGreenHookProps = CfnCodeDeployBlueGreenHookProps.builder()
 *         .applications(List.of(CfnCodeDeployBlueGreenApplication.builder()
 *                 .ecsAttributes(CfnCodeDeployBlueGreenEcsAttributes.builder()
 *                         .taskDefinitions(List.of("taskDefinitions"))
 *                         .taskSets(List.of("taskSets"))
 *                         .trafficRouting(CfnTrafficRouting.builder()
 *                                 .prodTrafficRoute(CfnTrafficRoute.builder()
 *                                         .logicalId("logicalId")
 *                                         .type("type")
 *                                         .build())
 *                                 .targetGroups(List.of("targetGroups"))
 *                                 .testTrafficRoute(CfnTrafficRoute.builder()
 *                                         .logicalId("logicalId")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .target(CfnCodeDeployBlueGreenApplicationTarget.builder()
 *                         .logicalId("logicalId")
 *                         .type("type")
 *                         .build())
 *                 .build()))
 *         .serviceRole("serviceRole")
 *         // the properties below are optional
 *         .additionalOptions(CfnCodeDeployBlueGreenAdditionalOptions.builder()
 *                 .terminationWaitTimeInMinutes(123)
 *                 .build())
 *         .lifecycleEventHooks(CfnCodeDeployBlueGreenLifecycleEventHooks.builder()
 *                 .afterAllowTestTraffic("afterAllowTestTraffic")
 *                 .afterAllowTraffic("afterAllowTraffic")
 *                 .afterInstall("afterInstall")
 *                 .beforeAllowTraffic("beforeAllowTraffic")
 *                 .beforeInstall("beforeInstall")
 *                 .build())
 *         .trafficRoutingConfig(CfnTrafficRoutingConfig.builder()
 *                 .type(CfnTrafficRoutingType.ALL_AT_ONCE)
 *                 // the properties below are optional
 *                 .timeBasedCanary(CfnTrafficRoutingTimeBasedCanary.builder()
 *                         .bakeTimeMins(123)
 *                         .stepPercentage(123)
 *                         .build())
 *                 .timeBasedLinear(CfnTrafficRoutingTimeBasedLinear.builder()
 *                         .bakeTimeMins(123)
 *                         .stepPercentage(123)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:52.744Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnCodeDeployBlueGreenHookProps")
@software.amazon.jsii.Jsii.Proxy(CfnCodeDeployBlueGreenHookProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CfnCodeDeployBlueGreenHookProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> getApplications();

    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceRole();

    /**
     * (experimental) Additional options for the blue/green deployment.
     * <p>
     * Default: - no additional options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions getAdditionalOptions() {
        return null;
    }

    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     * <p>
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {&#64;link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     * <p>
     * Default: - no lifecycle event hooks
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks getLifecycleEventHooks() {
        return null;
    }

    /**
     * (experimental) Traffic routing configuration settings.
     * <p>
     * Default: - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnTrafficRoutingConfig getTrafficRoutingConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCodeDeployBlueGreenHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCodeDeployBlueGreenHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCodeDeployBlueGreenHookProps> {
        java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> applications;
        java.lang.String serviceRole;
        software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions additionalOptions;
        software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks lifecycleEventHooks;
        software.amazon.awscdk.core.CfnTrafficRoutingConfig trafficRoutingConfig;

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenHookProps#getApplications}
         * @param applications Properties of the Amazon ECS applications being deployed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder applications(java.util.List<? extends software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> applications) {
            this.applications = (java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication>)applications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenHookProps#getServiceRole}
         * @param serviceRole The IAM Role for CloudFormation to use to perform blue-green deployments. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceRole(java.lang.String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenHookProps#getAdditionalOptions}
         * @param additionalOptions Additional options for the blue/green deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder additionalOptions(software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions additionalOptions) {
            this.additionalOptions = additionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenHookProps#getLifecycleEventHooks}
         * @param lifecycleEventHooks Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
         *                            You can use the same function or a different one for deployment lifecycle events.
         *                            Following completion of the validation tests,
         *                            the Lambda {&#64;link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
         *                            function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycleEventHooks(software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks lifecycleEventHooks) {
            this.lifecycleEventHooks = lifecycleEventHooks;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenHookProps#getTrafficRoutingConfig}
         * @param trafficRoutingConfig Traffic routing configuration settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trafficRoutingConfig(software.amazon.awscdk.core.CfnTrafficRoutingConfig trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeDeployBlueGreenHookProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CfnCodeDeployBlueGreenHookProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCodeDeployBlueGreenHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeDeployBlueGreenHookProps {
        private final java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> applications;
        private final java.lang.String serviceRole;
        private final software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions additionalOptions;
        private final software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks lifecycleEventHooks;
        private final software.amazon.awscdk.core.CfnTrafficRoutingConfig trafficRoutingConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applications = software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication.class)));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalOptions = software.amazon.jsii.Kernel.get(this, "additionalOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions.class));
            this.lifecycleEventHooks = software.amazon.jsii.Kernel.get(this, "lifecycleEventHooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks.class));
            this.trafficRoutingConfig = software.amazon.jsii.Kernel.get(this, "trafficRoutingConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTrafficRoutingConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applications = (java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication>)java.util.Objects.requireNonNull(builder.applications, "applications is required");
            this.serviceRole = java.util.Objects.requireNonNull(builder.serviceRole, "serviceRole is required");
            this.additionalOptions = builder.additionalOptions;
            this.lifecycleEventHooks = builder.lifecycleEventHooks;
            this.trafficRoutingConfig = builder.trafficRoutingConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnCodeDeployBlueGreenApplication> getApplications() {
            return this.applications;
        }

        @Override
        public final java.lang.String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final software.amazon.awscdk.core.CfnCodeDeployBlueGreenAdditionalOptions getAdditionalOptions() {
            return this.additionalOptions;
        }

        @Override
        public final software.amazon.awscdk.core.CfnCodeDeployBlueGreenLifecycleEventHooks getLifecycleEventHooks() {
            return this.lifecycleEventHooks;
        }

        @Override
        public final software.amazon.awscdk.core.CfnTrafficRoutingConfig getTrafficRoutingConfig() {
            return this.trafficRoutingConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applications", om.valueToTree(this.getApplications()));
            data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            if (this.getAdditionalOptions() != null) {
                data.set("additionalOptions", om.valueToTree(this.getAdditionalOptions()));
            }
            if (this.getLifecycleEventHooks() != null) {
                data.set("lifecycleEventHooks", om.valueToTree(this.getLifecycleEventHooks()));
            }
            if (this.getTrafficRoutingConfig() != null) {
                data.set("trafficRoutingConfig", om.valueToTree(this.getTrafficRoutingConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.CfnCodeDeployBlueGreenHookProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeDeployBlueGreenHookProps.Jsii$Proxy that = (CfnCodeDeployBlueGreenHookProps.Jsii$Proxy) o;

            if (!applications.equals(that.applications)) return false;
            if (!serviceRole.equals(that.serviceRole)) return false;
            if (this.additionalOptions != null ? !this.additionalOptions.equals(that.additionalOptions) : that.additionalOptions != null) return false;
            if (this.lifecycleEventHooks != null ? !this.lifecycleEventHooks.equals(that.lifecycleEventHooks) : that.lifecycleEventHooks != null) return false;
            return this.trafficRoutingConfig != null ? this.trafficRoutingConfig.equals(that.trafficRoutingConfig) : that.trafficRoutingConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applications.hashCode();
            result = 31 * result + (this.serviceRole.hashCode());
            result = 31 * result + (this.additionalOptions != null ? this.additionalOptions.hashCode() : 0);
            result = 31 * result + (this.lifecycleEventHooks != null ? this.lifecycleEventHooks.hashCode() : 0);
            result = 31 * result + (this.trafficRoutingConfig != null ? this.trafficRoutingConfig.hashCode() : 0);
            return result;
        }
    }
}
