package software.amazon.awscdk.core;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // add service account
 * ServiceAccount serviceAccount = cluster.addServiceAccount("MyServiceAccount");
 * Bucket bucket = new Bucket(this, "Bucket");
 * bucket.grantReadWrite(serviceAccount);
 * KubernetesManifest mypod = cluster.addManifest("mypod", Map.of(
 *         "apiVersion", "v1",
 *         "kind", "Pod",
 *         "metadata", Map.of("name", "mypod"),
 *         "spec", Map.of(
 *                 "serviceAccountName", serviceAccount.getServiceAccountName(),
 *                 "containers", List.of(Map.of(
 *                         "name", "hello",
 *                         "image", "paulbouwer/hello-kubernetes:1.5",
 *                         "ports", List.of(Map.of("containerPort", 8080)))))));
 * // create the resource after the service account.
 * mypod.node.addDependency(serviceAccount);
 * // print the IAM role arn for this service account
 * // print the IAM role arn for this service account
 * CfnOutput.Builder.create(this, "ServiceAccountIamRole").value(serviceAccount.getRole().getRoleArn()).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:52.796Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnOutput")
public class CfnOutput extends software.amazon.awscdk.core.CfnElement {

    protected CfnOutput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOutput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Creates an CfnOutput value for this stack.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     * @param props CfnOutput properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CfnOutput(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnOutputProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Return the `Fn.importValue` expression to import this value into another stack.
     * <p>
     * The returned value should not be used in the same stack, but in a
     * different one. It must be deployed to the same environment, as
     * CloudFormation exports can only be imported in the same Region and
     * account.
     * <p>
     * The is no automatic registration of dependencies between stacks when using
     * this mechanism, so you should make sure to deploy them in the right order
     * yourself.
     * <p>
     * You can use this mechanism to share values across Stacks in different
     * Stages. If you intend to share the value to another Stack inside the same
     * Stage, the automatic cross-stack referencing mechanism is more convenient.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getImportValue() {
        return software.amazon.jsii.Kernel.get(this, "importValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The value of the property returned by the aws cloudformation describe-stacks command.
     * <p>
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) The value of the property returned by the aws cloudformation describe-stacks command.
     * <p>
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setValue(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "value", java.util.Objects.requireNonNull(value, "value is required"));
    }

    /**
     * (experimental) A condition to associate with this output value.
     * <p>
     * If the condition evaluates
     * to <code>false</code>, this output value will not be included in the stack.
     * <p>
     * Default: - No condition is associated with the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCondition getCondition() {
        return software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCondition.class));
    }

    /**
     * (experimental) A condition to associate with this output value.
     * <p>
     * If the condition evaluates
     * to <code>false</code>, this output value will not be included in the stack.
     * <p>
     * Default: - No condition is associated with the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setCondition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCondition value) {
        software.amazon.jsii.Kernel.set(this, "condition", value);
    }

    /**
     * (experimental) A String type that describes the output value.
     * <p>
     * The description can be a maximum of 4 K in length.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A String type that describes the output value.
     * <p>
     * The description can be a maximum of 4 K in length.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * (experimental) The name used to export the value of this output across stacks.
     * <p>
     * To use the value in another stack, pass the value of
     * <code>output.importValue</code> to it.
     * <p>
     * Default: - the output is not exported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getExportName() {
        return software.amazon.jsii.Kernel.get(this, "exportName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name used to export the value of this output across stacks.
     * <p>
     * To use the value in another stack, pass the value of
     * <code>output.importValue</code> to it.
     * <p>
     * Default: - the output is not exported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setExportName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "exportName", value);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.core.CfnOutput}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CfnOutput> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The parent construct. This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.CfnOutputProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.core.CfnOutputProps.Builder();
        }

        /**
         * (experimental) The value of the property returned by the aws cloudformation describe-stacks command.
         * <p>
         * The value of an output can include literals, parameter references, pseudo-parameters,
         * a mapping value, or intrinsic functions.
         * <p>
         * @return {@code this}
         * @param value The value of the property returned by the aws cloudformation describe-stacks command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder value(final java.lang.String value) {
            this.props.value(value);
            return this;
        }

        /**
         * (experimental) A condition to associate with this output value.
         * <p>
         * If the condition evaluates
         * to <code>false</code>, this output value will not be included in the stack.
         * <p>
         * Default: - No condition is associated with the output.
         * <p>
         * @return {@code this}
         * @param condition A condition to associate with this output value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder condition(final software.amazon.awscdk.core.CfnCondition condition) {
            this.props.condition(condition);
            return this;
        }

        /**
         * (experimental) A String type that describes the output value.
         * <p>
         * The description can be a maximum of 4 K in length.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A String type that describes the output value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) The name used to export the value of this output across stacks.
         * <p>
         * To import the value from another stack, use <code>Fn.importValue(exportName)</code>.
         * <p>
         * Default: - the output is not exported
         * <p>
         * @return {@code this}
         * @param exportName The name used to export the value of this output across stacks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exportName(final java.lang.String exportName) {
            this.props.exportName(exportName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnOutput}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.core.CfnOutput build() {
            return new software.amazon.awscdk.core.CfnOutput(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
