package software.amazon.awscdk.core;

/**
 * (experimental) Use the UpdatePolicy attribute to specify how AWS CloudFormation handles updates to the AWS::AutoScaling::AutoScalingGroup resource.
 * <p>
 * AWS CloudFormation invokes one of three update policies depending on the type of change you make or whether a
 * scheduled action is associated with the Auto Scaling group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * CfnUpdatePolicy cfnUpdatePolicy = CfnUpdatePolicy.builder()
 *         .autoScalingReplacingUpdate(CfnAutoScalingReplacingUpdate.builder()
 *                 .willReplace(false)
 *                 .build())
 *         .autoScalingRollingUpdate(CfnAutoScalingRollingUpdate.builder()
 *                 .maxBatchSize(123)
 *                 .minInstancesInService(123)
 *                 .minSuccessfulInstancesPercent(123)
 *                 .pauseTime("pauseTime")
 *                 .suspendProcesses(List.of("suspendProcesses"))
 *                 .waitOnResourceSignals(false)
 *                 .build())
 *         .autoScalingScheduledAction(CfnAutoScalingScheduledAction.builder()
 *                 .ignoreUnmodifiedGroupSizeProperties(false)
 *                 .build())
 *         .codeDeployLambdaAliasUpdate(CfnCodeDeployLambdaAliasUpdate.builder()
 *                 .applicationName("applicationName")
 *                 .deploymentGroupName("deploymentGroupName")
 *                 // the properties below are optional
 *                 .afterAllowTrafficHook("afterAllowTrafficHook")
 *                 .beforeAllowTrafficHook("beforeAllowTrafficHook")
 *                 .build())
 *         .enableVersionUpgrade(false)
 *         .useOnlineResharding(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:52.870Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnUpdatePolicy")
@software.amazon.jsii.Jsii.Proxy(CfnUpdatePolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CfnUpdatePolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
     * <p>
     * During replacement,
     * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
     * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate getAutoScalingReplacingUpdate() {
        return null;
    }

    /**
     * (experimental) To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
     * <p>
     * Rolling updates enable you to specify whether AWS CloudFormation updates instances that are in an Auto Scaling
     * group in batches or all at once.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnAutoScalingRollingUpdate getAutoScalingRollingUpdate() {
        return null;
    }

    /**
     * (experimental) To specify how AWS CloudFormation handles updates for the MinSize, MaxSize, and DesiredCapacity properties when the AWS::AutoScaling::AutoScalingGroup resource has an associated scheduled action, use the AutoScalingScheduledAction policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnAutoScalingScheduledAction getAutoScalingScheduledAction() {
        return null;
    }

    /**
     * (experimental) To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate getCodeDeployLambdaAliasUpdate() {
        return null;
    }

    /**
     * (experimental) To upgrade an Amazon ES domain to a new version of Elasticsearch rather than replacing the entire AWS::Elasticsearch::Domain resource, use the EnableVersionUpgrade update policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableVersionUpgrade() {
        return null;
    }

    /**
     * (experimental) To modify a replication group's shards by adding or removing shards, rather than replacing the entire AWS::ElastiCache::ReplicationGroup resource, use the UseOnlineResharding update policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseOnlineResharding() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUpdatePolicy> {
        software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate autoScalingReplacingUpdate;
        software.amazon.awscdk.core.CfnAutoScalingRollingUpdate autoScalingRollingUpdate;
        software.amazon.awscdk.core.CfnAutoScalingScheduledAction autoScalingScheduledAction;
        software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate codeDeployLambdaAliasUpdate;
        java.lang.Boolean enableVersionUpgrade;
        java.lang.Boolean useOnlineResharding;

        /**
         * Sets the value of {@link CfnUpdatePolicy#getAutoScalingReplacingUpdate}
         * @param autoScalingReplacingUpdate Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
         *                                   During replacement,
         *                                   AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
         *                                   can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingReplacingUpdate(software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate autoScalingReplacingUpdate) {
            this.autoScalingReplacingUpdate = autoScalingReplacingUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnUpdatePolicy#getAutoScalingRollingUpdate}
         * @param autoScalingRollingUpdate To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
         *                                 Rolling updates enable you to specify whether AWS CloudFormation updates instances that are in an Auto Scaling
         *                                 group in batches or all at once.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingRollingUpdate(software.amazon.awscdk.core.CfnAutoScalingRollingUpdate autoScalingRollingUpdate) {
            this.autoScalingRollingUpdate = autoScalingRollingUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnUpdatePolicy#getAutoScalingScheduledAction}
         * @param autoScalingScheduledAction To specify how AWS CloudFormation handles updates for the MinSize, MaxSize, and DesiredCapacity properties when the AWS::AutoScaling::AutoScalingGroup resource has an associated scheduled action, use the AutoScalingScheduledAction policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingScheduledAction(software.amazon.awscdk.core.CfnAutoScalingScheduledAction autoScalingScheduledAction) {
            this.autoScalingScheduledAction = autoScalingScheduledAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnUpdatePolicy#getCodeDeployLambdaAliasUpdate}
         * @param codeDeployLambdaAliasUpdate To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeDeployLambdaAliasUpdate(software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate codeDeployLambdaAliasUpdate) {
            this.codeDeployLambdaAliasUpdate = codeDeployLambdaAliasUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnUpdatePolicy#getEnableVersionUpgrade}
         * @param enableVersionUpgrade To upgrade an Amazon ES domain to a new version of Elasticsearch rather than replacing the entire AWS::Elasticsearch::Domain resource, use the EnableVersionUpgrade update policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableVersionUpgrade(java.lang.Boolean enableVersionUpgrade) {
            this.enableVersionUpgrade = enableVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnUpdatePolicy#getUseOnlineResharding}
         * @param useOnlineResharding To modify a replication group's shards by adding or removing shards, rather than replacing the entire AWS::ElastiCache::ReplicationGroup resource, use the UseOnlineResharding update policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder useOnlineResharding(java.lang.Boolean useOnlineResharding) {
            this.useOnlineResharding = useOnlineResharding;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUpdatePolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CfnUpdatePolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUpdatePolicy {
        private final software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate autoScalingReplacingUpdate;
        private final software.amazon.awscdk.core.CfnAutoScalingRollingUpdate autoScalingRollingUpdate;
        private final software.amazon.awscdk.core.CfnAutoScalingScheduledAction autoScalingScheduledAction;
        private final software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate codeDeployLambdaAliasUpdate;
        private final java.lang.Boolean enableVersionUpgrade;
        private final java.lang.Boolean useOnlineResharding;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingReplacingUpdate = software.amazon.jsii.Kernel.get(this, "autoScalingReplacingUpdate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate.class));
            this.autoScalingRollingUpdate = software.amazon.jsii.Kernel.get(this, "autoScalingRollingUpdate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnAutoScalingRollingUpdate.class));
            this.autoScalingScheduledAction = software.amazon.jsii.Kernel.get(this, "autoScalingScheduledAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnAutoScalingScheduledAction.class));
            this.codeDeployLambdaAliasUpdate = software.amazon.jsii.Kernel.get(this, "codeDeployLambdaAliasUpdate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate.class));
            this.enableVersionUpgrade = software.amazon.jsii.Kernel.get(this, "enableVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.useOnlineResharding = software.amazon.jsii.Kernel.get(this, "useOnlineResharding", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingReplacingUpdate = builder.autoScalingReplacingUpdate;
            this.autoScalingRollingUpdate = builder.autoScalingRollingUpdate;
            this.autoScalingScheduledAction = builder.autoScalingScheduledAction;
            this.codeDeployLambdaAliasUpdate = builder.codeDeployLambdaAliasUpdate;
            this.enableVersionUpgrade = builder.enableVersionUpgrade;
            this.useOnlineResharding = builder.useOnlineResharding;
        }

        @Override
        public final software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate getAutoScalingReplacingUpdate() {
            return this.autoScalingReplacingUpdate;
        }

        @Override
        public final software.amazon.awscdk.core.CfnAutoScalingRollingUpdate getAutoScalingRollingUpdate() {
            return this.autoScalingRollingUpdate;
        }

        @Override
        public final software.amazon.awscdk.core.CfnAutoScalingScheduledAction getAutoScalingScheduledAction() {
            return this.autoScalingScheduledAction;
        }

        @Override
        public final software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate getCodeDeployLambdaAliasUpdate() {
            return this.codeDeployLambdaAliasUpdate;
        }

        @Override
        public final java.lang.Boolean getEnableVersionUpgrade() {
            return this.enableVersionUpgrade;
        }

        @Override
        public final java.lang.Boolean getUseOnlineResharding() {
            return this.useOnlineResharding;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoScalingReplacingUpdate() != null) {
                data.set("autoScalingReplacingUpdate", om.valueToTree(this.getAutoScalingReplacingUpdate()));
            }
            if (this.getAutoScalingRollingUpdate() != null) {
                data.set("autoScalingRollingUpdate", om.valueToTree(this.getAutoScalingRollingUpdate()));
            }
            if (this.getAutoScalingScheduledAction() != null) {
                data.set("autoScalingScheduledAction", om.valueToTree(this.getAutoScalingScheduledAction()));
            }
            if (this.getCodeDeployLambdaAliasUpdate() != null) {
                data.set("codeDeployLambdaAliasUpdate", om.valueToTree(this.getCodeDeployLambdaAliasUpdate()));
            }
            if (this.getEnableVersionUpgrade() != null) {
                data.set("enableVersionUpgrade", om.valueToTree(this.getEnableVersionUpgrade()));
            }
            if (this.getUseOnlineResharding() != null) {
                data.set("useOnlineResharding", om.valueToTree(this.getUseOnlineResharding()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.CfnUpdatePolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUpdatePolicy.Jsii$Proxy that = (CfnUpdatePolicy.Jsii$Proxy) o;

            if (this.autoScalingReplacingUpdate != null ? !this.autoScalingReplacingUpdate.equals(that.autoScalingReplacingUpdate) : that.autoScalingReplacingUpdate != null) return false;
            if (this.autoScalingRollingUpdate != null ? !this.autoScalingRollingUpdate.equals(that.autoScalingRollingUpdate) : that.autoScalingRollingUpdate != null) return false;
            if (this.autoScalingScheduledAction != null ? !this.autoScalingScheduledAction.equals(that.autoScalingScheduledAction) : that.autoScalingScheduledAction != null) return false;
            if (this.codeDeployLambdaAliasUpdate != null ? !this.codeDeployLambdaAliasUpdate.equals(that.codeDeployLambdaAliasUpdate) : that.codeDeployLambdaAliasUpdate != null) return false;
            if (this.enableVersionUpgrade != null ? !this.enableVersionUpgrade.equals(that.enableVersionUpgrade) : that.enableVersionUpgrade != null) return false;
            return this.useOnlineResharding != null ? this.useOnlineResharding.equals(that.useOnlineResharding) : that.useOnlineResharding == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingReplacingUpdate != null ? this.autoScalingReplacingUpdate.hashCode() : 0;
            result = 31 * result + (this.autoScalingRollingUpdate != null ? this.autoScalingRollingUpdate.hashCode() : 0);
            result = 31 * result + (this.autoScalingScheduledAction != null ? this.autoScalingScheduledAction.hashCode() : 0);
            result = 31 * result + (this.codeDeployLambdaAliasUpdate != null ? this.codeDeployLambdaAliasUpdate.hashCode() : 0);
            result = 31 * result + (this.enableVersionUpgrade != null ? this.enableVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.useOnlineResharding != null ? this.useOnlineResharding.hashCode() : 0);
            return result;
        }
    }
}
