package software.amazon.awscdk.core;

/**
 * (experimental) Represents the building block of the construct graph.
 * <p>
 * All constructs besides the root construct must be created within the scope of
 * another construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String entry = "/path/to/function";
 * DockerImage image = DockerImage.fromBuild(entry);
 * PythonFunction.Builder.create(this, "function")
 *         .entry(entry)
 *         .runtime(Runtime.PYTHON_3_8)
 *         .bundling(BundlingOptions.builder()
 *                 .buildArgs(Map.of("PIP_INDEX_URL", "https://your.index.url/simple/", "PIP_EXTRA_INDEX_URL", "https://your.extra-index.url/simple/"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:52.892Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.Construct")
public class Construct extends software.constructs.Construct implements software.amazon.awscdk.core.IConstruct {

    protected Construct(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Construct(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Construct(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Return whether the given object is a Construct.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isConstruct(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Construct.class, "isConstruct", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * (experimental) Perform final modifications before synthesis.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     * <p>
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected void onPrepare() {
        software.amazon.jsii.Kernel.call(this, "onPrepare", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Allows this construct to emit artifacts into the cloud assembly during synthesis.
     * <p>
     * This method is usually implemented by framework-level constructs such as <code>Stack</code> and <code>Asset</code>
     * as they participate in synthesizing the cloud assembly.
     * <p>
     * @param session The synthesis session. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected void onSynthesize(final @org.jetbrains.annotations.NotNull software.constructs.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "onSynthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * (experimental) Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     * <p>
     * @return An array of validation error messages, or an empty array if the construct is valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> onValidate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "onValidate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Perform final modifications before synthesis.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     * <p>
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void prepare() {
        software.amazon.jsii.Kernel.call(this, "prepare", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Allows this construct to emit artifacts into the cloud assembly during synthesis.
     * <p>
     * This method is usually implemented by framework-level constructs such as <code>Stack</code> and <code>Asset</code>
     * as they participate in synthesizing the cloud assembly.
     * <p>
     * @param session The synthesis session. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * (experimental) Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     * <p>
     * @return An array of validation error messages, or an empty array if the construct is valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) The construct tree node associated with this construct.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
        return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
    }
}
