package software.amazon.awscdk.core;

/**
 * (experimental) An AWS-Lambda backed custom resource provider, for CDK Construct Library constructs.
 * <p>
 * This is a provider for <code>CustomResource</code> constructs, backed by an AWS Lambda
 * Function. It only supports NodeJS runtimes.
 * <p>
 * <strong>This is not a generic custom resource provider class</strong>. It is specifically
 * intended to be used only by constructs in the AWS CDK Construct Library, and
 * only exists here because of reverse dependency issues (for example, it cannot
 * use <code>iam.PolicyStatement</code> objects, since the <code>iam</code> library already depends on
 * the CDK <code>core</code> library and we cannot have cyclic dependencies).
 * <p>
 * If you are not writing constructs for the AWS Construct Library, you should
 * use the <code>Provider</code> class in the <code>custom-resources</code> module instead, which has
 * a better API and supports all Lambda runtimes, not just Node.
 * <p>
 * N.B.: When you are writing Custom Resource Providers, there are a number of
 * lifecycle events you have to pay attention to. These are documented in the
 * README of the <code>custom-resources</code> module. Be sure to give the documentation
 * in that module a read, regardless of whether you end up using the Provider
 * class in there or this one.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CustomResourceProvider provider = CustomResourceProvider.getOrCreateProvider(this, "Custom::MyCustomResourceType", CustomResourceProviderProps.builder()
 *         .codeDirectory(String.format("%s/my-handler", __dirname))
 *         .runtime(CustomResourceProviderRuntime.NODEJS_14_X)
 *         .policyStatements(List.of(Map.of(
 *                 "Effect", "Allow",
 *                 "Action", "s3:PutObject*",
 *                 "Resource", "*")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:52.906Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CustomResourceProvider")
public class CustomResourceProvider extends software.amazon.awscdk.core.Construct {

    protected CustomResourceProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomResourceProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected CustomResourceProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CustomResourceProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Returns a stack-level singleton ARN (service token) for the custom resource provider.
     * <p>
     * @return the service token of the custom resource provider, which should be
     * used when defining a `CustomResource`.
     * @param scope Construct scope. This parameter is required.
     * @param uniqueid A globally unique id that will be used for the stack-level construct. This parameter is required.
     * @param props Provider properties which will only be applied when the provider is first created. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.String getOrCreate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String uniqueid, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CustomResourceProviderProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.CustomResourceProvider.class, "getOrCreate", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(uniqueid, "uniqueid is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Returns a stack-level singleton for the custom resource provider.
     * <p>
     * @return the service token of the custom resource provider, which should be
     * used when defining a `CustomResource`.
     * @param scope Construct scope. This parameter is required.
     * @param uniqueid A globally unique id that will be used for the stack-level construct. This parameter is required.
     * @param props Provider properties which will only be applied when the provider is first created. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CustomResourceProvider getOrCreateProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String uniqueid, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CustomResourceProviderProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.CustomResourceProvider.class, "getOrCreateProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CustomResourceProvider.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(uniqueid, "uniqueid is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The hash of the lambda code backing this provider.
     * <p>
     * Can be used to trigger updates
     * on code changes, even when the properties of a custom resource remain unchanged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCodeHash() {
        return software.amazon.jsii.Kernel.get(this, "codeHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN of the provider's AWS Lambda function role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN of the provider's AWS Lambda function which should be used as the `serviceToken` when defining a custom resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * CustomResourceProvider myProvider;
     * CustomResource.Builder.create(this, "MyCustomResource")
     *         .serviceToken(myProvider.getServiceToken())
     *         .properties(Map.of(
     *                 "myPropertyOne", "one",
     *                 "myPropertyTwo", "two"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceToken() {
        return software.amazon.jsii.Kernel.get(this, "serviceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
