/**
 * <h1>monocdk Experiment</h1>
 * <p>
 * <a href="http://github.com/badges/stability-badges"><img alt="experimental" src="http://badges.github.io/stability-badges/dist/experimental.svg"></a>
 * <p>
 * An <strong>experiment</strong> to bundle all of the CDK into a single module.
 * <p>
 * <blockquote>
 * <p>
 * :warning: Please don't use this module unless you are interested in providing
 * feedback about this experience.
 * <p>
 * </blockquote>
 * <p>
 * <h2>Usage</h2>
 * <p>
 * <h3>Installation</h3>
 * <p>
 * To try out <code>monocdk</code> replace all references to CDK Construct
 * Libraries (most <code>&#64;aws-cdk/*</code> packages) in your <code>package.json</code> file with a single
 * entrey referring to <code>monocdk</code>.
 * <p>
 * You also need to add a reference to the <code>constructs</code> library, according to the
 * kind of project you are developing:
 * <p>
 * <ul>
 * <li>For libraries, model the dependency under <code>devDependencies</code> <strong>and</strong> <code>peerDependencies</code></li>
 * <li>For apps, model the dependency under <code>dependencies</code> only</li>
 * </ul>
 * <p>
 * <h3>Use in your code</h3>
 * <p>
 * <h4>Classic import</h4>
 * <p>
 * You can use a classic import to get access to each service namespaces:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import monocdk.core;
 * import software.amazon.awscdk.services.s3.*;
 * 
 * 
 * Object app = new App();
 * Object stack = new Stack(app, "MonoCDK-Stack");
 * 
 * new Bucket(stack, "TestBucket");
 * </pre></blockquote>
 * <p>
 * <h4>Barrel import</h4>
 * <p>
 * Alternatively, you can use "barrel" imports:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.App;
 * import software.amazon.awscdk.core.Stack;
 * import software.amazon.awscdk.services.s3.Bucket;
 * 
 * 
 * App app = new App();
 * Stack stack = new Stack(app, "MonoCDK-Stack");
 * 
 * new Bucket(stack, "TestBucket");
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.core;
