package software.amazon.awscdk.cxapi;

/**
 * (experimental) Asset manifest is a description of a set of assets which need to be built and published.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * import software.amazon.awscdk.cxapi.*;
 * CloudAssembly cloudAssembly;
 * NestedCloudAssemblyArtifact nestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact.Builder.create(cloudAssembly, "name")
 *         .type(ArtifactType.NONE)
 *         // the properties below are optional
 *         .dependencies(List.of("dependencies"))
 *         .displayName("displayName")
 *         .environment("environment")
 *         .metadata(Map.of(
 *                 "metadataKey", List.of(MetadataEntry.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .trace(List.of("trace"))
 *                         .build())))
 *         .properties(AwsCloudFormationStackProperties.builder()
 *                 .templateFile("templateFile")
 *                 // the properties below are optional
 *                 .assumeRoleArn("assumeRoleArn")
 *                 .assumeRoleExternalId("assumeRoleExternalId")
 *                 .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                 .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *                 .lookupRole(BootstrapRole.builder()
 *                         .arn("arn")
 *                         // the properties below are optional
 *                         .assumeRoleExternalId("assumeRoleExternalId")
 *                         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                         .requiresBootstrapStackVersion(123)
 *                         .build())
 *                 .parameters(Map.of(
 *                         "parametersKey", "parameters"))
 *                 .requiresBootstrapStackVersion(123)
 *                 .stackName("stackName")
 *                 .stackTemplateAssetObjectUrl("stackTemplateAssetObjectUrl")
 *                 .tags(Map.of(
 *                         "tagsKey", "tags"))
 *                 .terminationProtection(false)
 *                 .validateOnSynth(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.114Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.cx_api.NestedCloudAssemblyArtifact")
public class NestedCloudAssemblyArtifact extends software.amazon.awscdk.cxapi.CloudArtifact {

    protected NestedCloudAssemblyArtifact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NestedCloudAssemblyArtifact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param assembly This parameter is required.
     * @param name This parameter is required.
     * @param artifact This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public NestedCloudAssemblyArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly assembly, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ArtifactManifest artifact) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(assembly, "assembly is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(artifact, "artifact is required") });
    }

    /**
     * (experimental) The relative directory name of the asset manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDirectoryName() {
        return software.amazon.jsii.Kernel.get(this, "directoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Display name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Full path to the nested assembly directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFullPath() {
        return software.amazon.jsii.Kernel.get(this, "fullPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The nested Assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly getNestedAssembly() {
        return software.amazon.jsii.Kernel.get(this, "nestedAssembly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssembly.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact> {
        /**
         * @return a new instance of {@link Builder}.
         * @param assembly This parameter is required.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.cxapi.CloudAssembly assembly, final java.lang.String name) {
            return new Builder(assembly, name);
        }

        private final software.amazon.awscdk.cxapi.CloudAssembly assembly;
        private final java.lang.String name;
        private final software.amazon.awscdk.cloudassembly.schema.ArtifactManifest.Builder artifact;

        private Builder(final software.amazon.awscdk.cxapi.CloudAssembly assembly, final java.lang.String name) {
            this.assembly = assembly;
            this.name = name;
            this.artifact = new software.amazon.awscdk.cloudassembly.schema.ArtifactManifest.Builder();
        }

        /**
         * (experimental) The type of artifact.
         * <p>
         * @return {@code this}
         * @param type The type of artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(final software.amazon.awscdk.cloudassembly.schema.ArtifactType type) {
            this.artifact.type(type);
            return this;
        }

        /**
         * (experimental) IDs of artifacts that must be deployed before this artifact.
         * <p>
         * Default: - no dependencies.
         * <p>
         * @return {@code this}
         * @param dependencies IDs of artifacts that must be deployed before this artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dependencies(final java.util.List<java.lang.String> dependencies) {
            this.artifact.dependencies(dependencies);
            return this;
        }

        /**
         * (experimental) A string that represents this artifact.
         * <p>
         * Should only be used in user interfaces.
         * <p>
         * Default: - no display name
         * <p>
         * @return {@code this}
         * @param displayName A string that represents this artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder displayName(final java.lang.String displayName) {
            this.artifact.displayName(displayName);
            return this;
        }

        /**
         * (experimental) The environment into which this artifact is deployed.
         * <p>
         * Default: - no envrionment.
         * <p>
         * @return {@code this}
         * @param environment The environment into which this artifact is deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(final java.lang.String environment) {
            this.artifact.environment(environment);
            return this;
        }

        /**
         * (experimental) Associated metadata.
         * <p>
         * Default: - no metadata.
         * <p>
         * @return {@code this}
         * @param metadata Associated metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metadata(final java.util.Map<java.lang.String, ? extends java.util.List<? extends software.amazon.awscdk.cloudassembly.schema.MetadataEntry>> metadata) {
            this.artifact.metadata(metadata);
            return this;
        }

        /**
         * (experimental) The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder properties(final software.amazon.awscdk.cloudassembly.schema.AwsCloudFormationStackProperties properties) {
            this.artifact.properties(properties);
            return this;
        }
        /**
         * (experimental) The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder properties(final software.amazon.awscdk.cloudassembly.schema.AssetManifestProperties properties) {
            this.artifact.properties(properties);
            return this;
        }
        /**
         * (experimental) The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder properties(final software.amazon.awscdk.cloudassembly.schema.TreeArtifactProperties properties) {
            this.artifact.properties(properties);
            return this;
        }
        /**
         * (experimental) The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder properties(final software.amazon.awscdk.cloudassembly.schema.NestedCloudAssemblyProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact build() {
            return new software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact(
                this.assembly,
                this.name,
                this.artifact.build()
            );
        }
    }
}
