package software.amazon.awscdk.integtests;

/**
 * (experimental) Construct that creates a custom resource that will perform a query using the AWS SDK.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stack myAppStack;
 * AwsApiCall.Builder.create(myAppStack, "GetObject")
 *         .service("S3")
 *         .api("getObject")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.162Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.AwsApiCall")
public class AwsApiCall extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.integtests.IAwsApiCall {

    protected AwsApiCall(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsApiCall(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AwsApiCall(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.AwsApiCallProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Assert that the ExpectedResult is equal to the result of the AwsApiCall at the given path.
     * <p>
     * For example the SQS.receiveMessage api response would look
     * like:
     * <p>
     * If you wanted to assert the value of <code>Body</code> you could do
     * <p>
     * @param path This parameter is required.
     * @param expected This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void assertAtPath(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected) {
        software.amazon.jsii.Kernel.call(this, "assertAtPath", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(expected, "expected is required") });
    }

    /**
     * (experimental) Assert that the ExpectedResult is equal to the result of the AwsApiCall.
     * <p>
     * @param expected This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void expect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected) {
        software.amazon.jsii.Kernel.call(this, "expect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(expected, "expected is required") });
    }

    /**
     * (experimental) Returns the value of an attribute of the custom resource of an arbitrary type.
     * <p>
     * Attributes are returned from the custom resource provider through the
     * <code>Data</code> map where the key is the attribute name.
     * <p>
     * @param attributeName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.Kernel.call(this, "getAtt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Reference.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * (experimental) Returns the value of an attribute of the custom resource of type string.
     * <p>
     * Attributes are returned from the custom resource provider through the
     * <code>Data</code> map where the key is the attribute name.
     * <p>
     * @param attributeName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String getAttString(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.Kernel.call(this, "getAttString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.AssertionsProvider getProvider() {
        return software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.AssertionsProvider.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.AssertionsProvider value) {
        software.amazon.jsii.Kernel.set(this, "provider", java.util.Objects.requireNonNull(value, "provider is required"));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.integtests.AwsApiCall}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.integtests.AwsApiCall> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.integtests.AwsApiCallProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.integtests.AwsApiCallProps.Builder();
        }

        /**
         * (experimental) The api call to make, i.e. getBucketLifecycle.
         * <p>
         * @return {@code this}
         * @param api The api call to make, i.e. getBucketLifecycle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder api(final java.lang.String api) {
            this.props.api(api);
            return this;
        }

        /**
         * (experimental) The AWS service, i.e. S3.
         * <p>
         * @return {@code this}
         * @param service The AWS service, i.e. S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder service(final java.lang.String service) {
            this.props.service(service);
            return this;
        }

        /**
         * (experimental) Any parameters to pass to the api call.
         * <p>
         * Default: - no parameters
         * <p>
         * @return {@code this}
         * @param parameters Any parameters to pass to the api call. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(final java.lang.Object parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.integtests.AwsApiCall}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.integtests.AwsApiCall build() {
            return new software.amazon.awscdk.integtests.AwsApiCall(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
