package software.amazon.awscdk.integtests;

/**
 * (experimental) Construct that creates a CustomResource to assert that two values are equal.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.integtests.*;
 * ActualResult actualResult;
 * ExpectedResult expectedResult;
 * EqualsAssertion equalsAssertion = EqualsAssertion.Builder.create(this, "MyEqualsAssertion")
 *         .actual(actualResult)
 *         .expected(expectedResult)
 *         // the properties below are optional
 *         .failDeployment(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.167Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.EqualsAssertion")
public class EqualsAssertion extends software.amazon.awscdk.core.Construct {

    protected EqualsAssertion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EqualsAssertion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public EqualsAssertion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.EqualsAssertionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The result of the assertion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getResult() {
        return software.amazon.jsii.Kernel.get(this, "result", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.integtests.EqualsAssertion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.integtests.EqualsAssertion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.integtests.EqualsAssertionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.integtests.EqualsAssertionProps.Builder();
        }

        /**
         * (experimental) The actual results to compare.
         * <p>
         * @return {@code this}
         * @param actual The actual results to compare. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actual(final software.amazon.awscdk.integtests.ActualResult actual) {
            this.props.actual(actual);
            return this;
        }

        /**
         * (experimental) The expected result to assert.
         * <p>
         * @return {@code this}
         * @param expected The expected result to assert. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expected(final software.amazon.awscdk.integtests.ExpectedResult expected) {
            this.props.expected(expected);
            return this;
        }

        /**
         * (experimental) Set this to true if a failed assertion should result in a CloudFormation deployment failure.
         * <p>
         * This is only necessary if assertions are being
         * executed outside of <code>integ-runner</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param failDeployment Set this to true if a failed assertion should result in a CloudFormation deployment failure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder failDeployment(final java.lang.Boolean failDeployment) {
            this.props.failDeployment(failDeployment);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.integtests.EqualsAssertion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.integtests.EqualsAssertion build() {
            return new software.amazon.awscdk.integtests.EqualsAssertion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
