package software.amazon.awscdk.integtests;

/**
 * (experimental) An integration test case. Allows the definition of test properties that apply to all stacks under this case.
 * <p>
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * import software.amazon.awscdk.integtests.*;
 * Stack stack;
 * IntegTestCase integTestCase = IntegTestCase.Builder.create(this, "MyIntegTestCase")
 *         .stacks(List.of(stack))
 *         // the properties below are optional
 *         .allowDestroy(List.of("allowDestroy"))
 *         .cdkCommandOptions(CdkCommands.builder()
 *                 .deploy(DeployCommand.builder()
 *                         .args(DeployOptions.builder()
 *                                 .all(false)
 *                                 .app("app")
 *                                 .assetMetadata(false)
 *                                 .caBundlePath("caBundlePath")
 *                                 .changeSetName("changeSetName")
 *                                 .ci(false)
 *                                 .color(false)
 *                                 .context(Map.of(
 *                                         "contextKey", "context"))
 *                                 .debug(false)
 *                                 .ec2Creds(false)
 *                                 .exclusively(false)
 *                                 .execute(false)
 *                                 .force(false)
 *                                 .ignoreErrors(false)
 *                                 .json(false)
 *                                 .lookups(false)
 *                                 .notices(false)
 *                                 .notificationArns(List.of("notificationArns"))
 *                                 .output("output")
 *                                 .outputsFile("outputsFile")
 *                                 .parameters(Map.of(
 *                                         "parametersKey", "parameters"))
 *                                 .pathMetadata(false)
 *                                 .profile("profile")
 *                                 .proxy("proxy")
 *                                 .requireApproval(RequireApproval.NEVER)
 *                                 .reuseAssets(List.of("reuseAssets"))
 *                                 .roleArn("roleArn")
 *                                 .rollback(false)
 *                                 .stacks(List.of("stacks"))
 *                                 .staging(false)
 *                                 .strict(false)
 *                                 .toolkitStackName("toolkitStackName")
 *                                 .trace(false)
 *                                 .usePreviousParameters(false)
 *                                 .verbose(false)
 *                                 .versionReporting(false)
 *                                 .build())
 *                         .enabled(false)
 *                         .expectedMessage("expectedMessage")
 *                         .expectError(false)
 *                         .build())
 *                 .destroy(DestroyCommand.builder()
 *                         .args(DestroyOptions.builder()
 *                                 .all(false)
 *                                 .app("app")
 *                                 .assetMetadata(false)
 *                                 .caBundlePath("caBundlePath")
 *                                 .color(false)
 *                                 .context(Map.of(
 *                                         "contextKey", "context"))
 *                                 .debug(false)
 *                                 .ec2Creds(false)
 *                                 .exclusively(false)
 *                                 .force(false)
 *                                 .ignoreErrors(false)
 *                                 .json(false)
 *                                 .lookups(false)
 *                                 .notices(false)
 *                                 .output("output")
 *                                 .pathMetadata(false)
 *                                 .profile("profile")
 *                                 .proxy("proxy")
 *                                 .roleArn("roleArn")
 *                                 .stacks(List.of("stacks"))
 *                                 .staging(false)
 *                                 .strict(false)
 *                                 .trace(false)
 *                                 .verbose(false)
 *                                 .versionReporting(false)
 *                                 .build())
 *                         .enabled(false)
 *                         .expectedMessage("expectedMessage")
 *                         .expectError(false)
 *                         .build())
 *                 .build())
 *         .diffAssets(false)
 *         .hooks(Hooks.builder()
 *                 .postDeploy(List.of("postDeploy"))
 *                 .postDestroy(List.of("postDestroy"))
 *                 .preDeploy(List.of("preDeploy"))
 *                 .preDestroy(List.of("preDestroy"))
 *                 .build())
 *         .regions(List.of("regions"))
 *         .stackUpdateWorkflow(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.192Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.IntegTestCase")
public class IntegTestCase extends software.amazon.awscdk.core.Construct {

    protected IntegTestCase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IntegTestCase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IntegTestCase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IntegTestCaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Make assertions on resources in this test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IDeployAssert getAssertions() {
        return software.amazon.jsii.Kernel.get(this, "assertions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.IDeployAssert.class));
    }

    /**
     * (experimental) The integration test manifest for this test case.
     * <p>
     * Manifests are used
     * by the integration test runner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.IntegManifest getManifest() {
        return software.amazon.jsii.Kernel.get(this, "manifest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.IntegManifest.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.integtests.IntegTestCase}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.integtests.IntegTestCase> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.integtests.IntegTestCaseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.integtests.IntegTestCaseProps.Builder();
        }

        /**
         * (experimental) List of CloudFormation resource types in this stack that can be destroyed as part of an update without failing the test.
         * <p>
         * This list should only include resources that for this specific
         * integration test we are sure will not cause errors or an outage if
         * destroyed. For example, maybe we know that a new resource will be created
         * first before the old resource is destroyed which prevents any outage.
         * <p>
         * e.g. ['AWS::IAM::Role']
         * <p>
         * Default: - do not allow destruction of any resources on update
         * <p>
         * @return {@code this}
         * @param allowDestroy List of CloudFormation resource types in this stack that can be destroyed as part of an update without failing the test. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowDestroy(final java.util.List<java.lang.String> allowDestroy) {
            this.props.allowDestroy(allowDestroy);
            return this;
        }

        /**
         * (experimental) Additional options to use for each CDK command.
         * <p>
         * Default: - runner default options
         * <p>
         * @return {@code this}
         * @param cdkCommandOptions Additional options to use for each CDK command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdkCommandOptions(final software.amazon.awscdk.cloudassembly.schema.CdkCommands cdkCommandOptions) {
            this.props.cdkCommandOptions(cdkCommandOptions);
            return this;
        }

        /**
         * (experimental) Whether or not to include asset hashes in the diff Asset hashes can introduces a lot of unneccessary noise into tests, but there are some cases where asset hashes _should_ be included.
         * <p>
         * For example
         * any tests involving custom resources or bundling
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param diffAssets Whether or not to include asset hashes in the diff Asset hashes can introduces a lot of unneccessary noise into tests, but there are some cases where asset hashes _should_ be included. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder diffAssets(final java.lang.Boolean diffAssets) {
            this.props.diffAssets(diffAssets);
            return this;
        }

        /**
         * (experimental) Additional commands to run at predefined points in the test workflow.
         * <p>
         * e.g. { postDeploy: ['yarn', 'test'] }
         * <p>
         * Default: - no hooks
         * <p>
         * @return {@code this}
         * @param hooks Additional commands to run at predefined points in the test workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hooks(final software.amazon.awscdk.cloudassembly.schema.Hooks hooks) {
            this.props.hooks(hooks);
            return this;
        }

        /**
         * (experimental) Limit deployment to these regions.
         * <p>
         * Default: - can run in any region
         * <p>
         * @return {@code this}
         * @param regions Limit deployment to these regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder regions(final java.util.List<java.lang.String> regions) {
            this.props.regions(regions);
            return this;
        }

        /**
         * (experimental) Run update workflow on this test case This should only be set to false to test scenarios that are not possible to test as part of the update workflow.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param stackUpdateWorkflow Run update workflow on this test case This should only be set to false to test scenarios that are not possible to test as part of the update workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackUpdateWorkflow(final java.lang.Boolean stackUpdateWorkflow) {
            this.props.stackUpdateWorkflow(stackUpdateWorkflow);
            return this;
        }

        /**
         * (experimental) Stacks to be deployed during the test.
         * <p>
         * @return {@code this}
         * @param stacks Stacks to be deployed during the test. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stacks(final java.util.List<? extends software.amazon.awscdk.core.Stack> stacks) {
            this.props.stacks(stacks);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.integtests.IntegTestCase}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.integtests.IntegTestCase build() {
            return new software.amazon.awscdk.integtests.IntegTestCase(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
