package software.amazon.awscdk.integtests;

/**
 * (experimental) Properties of an integration test case stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app;
 * Stack stackUnderTest;
 * IntegTestCaseStack testCaseWithAssets = IntegTestCaseStack.Builder.create(app, "TestCaseAssets")
 *         .diffAssets(true)
 *         .build();
 * IntegTest.Builder.create(app, "Integ").testCases(List.of(stackUnderTest, testCaseWithAssets)).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.199Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.IntegTestCaseStackProps")
@software.amazon.jsii.Jsii.Proxy(IntegTestCaseStackProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IntegTestCaseStackProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloudassembly.schema.TestOptions, software.amazon.awscdk.core.StackProps {

    /**
     * @return a {@link Builder} of {@link IntegTestCaseStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegTestCaseStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<IntegTestCaseStackProps> {
        java.util.List<java.lang.String> allowDestroy;
        software.amazon.awscdk.cloudassembly.schema.CdkCommands cdkCommandOptions;
        java.lang.Boolean diffAssets;
        software.amazon.awscdk.cloudassembly.schema.Hooks hooks;
        java.util.List<java.lang.String> regions;
        java.lang.Boolean stackUpdateWorkflow;
        java.lang.Boolean analyticsReporting;
        java.lang.String description;
        software.amazon.awscdk.core.Environment env;
        java.lang.String stackName;
        software.amazon.awscdk.core.IStackSynthesizer synthesizer;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Boolean terminationProtection;

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getAllowDestroy}
         * @param allowDestroy List of CloudFormation resource types in this stack that can be destroyed as part of an update without failing the test.
         *                     This list should only include resources that for this specific
         *                     integration test we are sure will not cause errors or an outage if
         *                     destroyed. For example, maybe we know that a new resource will be created
         *                     first before the old resource is destroyed which prevents any outage.
         *                     <p>
         *                     e.g. ['AWS::IAM::Role']
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowDestroy(java.util.List<java.lang.String> allowDestroy) {
            this.allowDestroy = allowDestroy;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getCdkCommandOptions}
         * @param cdkCommandOptions Additional options to use for each CDK command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdkCommandOptions(software.amazon.awscdk.cloudassembly.schema.CdkCommands cdkCommandOptions) {
            this.cdkCommandOptions = cdkCommandOptions;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getDiffAssets}
         * @param diffAssets Whether or not to include asset hashes in the diff Asset hashes can introduces a lot of unneccessary noise into tests, but there are some cases where asset hashes _should_ be included.
         *                   For example
         *                   any tests involving custom resources or bundling
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder diffAssets(java.lang.Boolean diffAssets) {
            this.diffAssets = diffAssets;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getHooks}
         * @param hooks Additional commands to run at predefined points in the test workflow.
         *              e.g. { postDeploy: ['yarn', 'test'] }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hooks(software.amazon.awscdk.cloudassembly.schema.Hooks hooks) {
            this.hooks = hooks;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getRegions}
         * @param regions Limit deployment to these regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder regions(java.util.List<java.lang.String> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getStackUpdateWorkflow}
         * @param stackUpdateWorkflow Run update workflow on this test case This should only be set to false to test scenarios that are not possible to test as part of the update workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackUpdateWorkflow(java.lang.Boolean stackUpdateWorkflow) {
            this.stackUpdateWorkflow = stackUpdateWorkflow;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getAnalyticsReporting}
         * @param analyticsReporting Include runtime versioning information in this Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder analyticsReporting(java.lang.Boolean analyticsReporting) {
            this.analyticsReporting = analyticsReporting;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getDescription}
         * @param description A description of the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getEnv}
         * @param env The AWS environment (account/region) where this stack will be deployed.
         *            Set the <code>region</code>/<code>account</code> fields of <code>env</code> to either a concrete value to
         *            select the indicated environment (recommended for production stacks), or to
         *            the values of environment variables
         *            <code>CDK_DEFAULT_REGION</code>/<code>CDK_DEFAULT_ACCOUNT</code> to let the target environment
         *            depend on the AWS credentials/configuration that the CDK CLI is executed
         *            under (recommended for development stacks).
         *            <p>
         *            If the <code>Stack</code> is instantiated inside a <code>Stage</code>, any undefined
         *            <code>region</code>/<code>account</code> fields from <code>env</code> will default to the same field on the
         *            encompassing <code>Stage</code>, if configured there.
         *            <p>
         *            If either <code>region</code> or <code>account</code> are not set nor inherited from <code>Stage</code>, the
         *            Stack will be considered "<em>environment-agnostic</em>"". Environment-agnostic
         *            stacks can be deployed to any environment but may not be able to take
         *            advantage of all features of the CDK. For example, they will not be able to
         *            use environmental context lookups such as <code>ec2.Vpc.fromLookup</code> and will not
         *            automatically translate Service Principals to the right format based on the
         *            environment's AWS partition, and other such enhancements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(software.amazon.awscdk.core.Environment env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getStackName}
         * @param stackName Name to deploy the stack with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getSynthesizer}
         * @param synthesizer Synthesis method to use while deploying this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder synthesizer(software.amazon.awscdk.core.IStackSynthesizer synthesizer) {
            this.synthesizer = synthesizer;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getTags}
         * @param tags Stack tags that will be applied to all the taggable resources and the stack itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link IntegTestCaseStackProps#getTerminationProtection}
         * @param terminationProtection Whether to enable termination protection for this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder terminationProtection(java.lang.Boolean terminationProtection) {
            this.terminationProtection = terminationProtection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegTestCaseStackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public IntegTestCaseStackProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntegTestCaseStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegTestCaseStackProps {
        private final java.util.List<java.lang.String> allowDestroy;
        private final software.amazon.awscdk.cloudassembly.schema.CdkCommands cdkCommandOptions;
        private final java.lang.Boolean diffAssets;
        private final software.amazon.awscdk.cloudassembly.schema.Hooks hooks;
        private final java.util.List<java.lang.String> regions;
        private final java.lang.Boolean stackUpdateWorkflow;
        private final java.lang.Boolean analyticsReporting;
        private final java.lang.String description;
        private final software.amazon.awscdk.core.Environment env;
        private final java.lang.String stackName;
        private final software.amazon.awscdk.core.IStackSynthesizer synthesizer;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Boolean terminationProtection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowDestroy = software.amazon.jsii.Kernel.get(this, "allowDestroy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cdkCommandOptions = software.amazon.jsii.Kernel.get(this, "cdkCommandOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.CdkCommands.class));
            this.diffAssets = software.amazon.jsii.Kernel.get(this, "diffAssets", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.hooks = software.amazon.jsii.Kernel.get(this, "hooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.Hooks.class));
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stackUpdateWorkflow = software.amazon.jsii.Kernel.get(this, "stackUpdateWorkflow", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.analyticsReporting = software.amazon.jsii.Kernel.get(this, "analyticsReporting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Environment.class));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.synthesizer = software.amazon.jsii.Kernel.get(this, "synthesizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IStackSynthesizer.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.terminationProtection = software.amazon.jsii.Kernel.get(this, "terminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowDestroy = builder.allowDestroy;
            this.cdkCommandOptions = builder.cdkCommandOptions;
            this.diffAssets = builder.diffAssets;
            this.hooks = builder.hooks;
            this.regions = builder.regions;
            this.stackUpdateWorkflow = builder.stackUpdateWorkflow;
            this.analyticsReporting = builder.analyticsReporting;
            this.description = builder.description;
            this.env = builder.env;
            this.stackName = builder.stackName;
            this.synthesizer = builder.synthesizer;
            this.tags = builder.tags;
            this.terminationProtection = builder.terminationProtection;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowDestroy() {
            return this.allowDestroy;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.CdkCommands getCdkCommandOptions() {
            return this.cdkCommandOptions;
        }

        @Override
        public final java.lang.Boolean getDiffAssets() {
            return this.diffAssets;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.Hooks getHooks() {
            return this.hooks;
        }

        @Override
        public final java.util.List<java.lang.String> getRegions() {
            return this.regions;
        }

        @Override
        public final java.lang.Boolean getStackUpdateWorkflow() {
            return this.stackUpdateWorkflow;
        }

        @Override
        public final java.lang.Boolean getAnalyticsReporting() {
            return this.analyticsReporting;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.core.Environment getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public final software.amazon.awscdk.core.IStackSynthesizer getSynthesizer() {
            return this.synthesizer;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Boolean getTerminationProtection() {
            return this.terminationProtection;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowDestroy() != null) {
                data.set("allowDestroy", om.valueToTree(this.getAllowDestroy()));
            }
            if (this.getCdkCommandOptions() != null) {
                data.set("cdkCommandOptions", om.valueToTree(this.getCdkCommandOptions()));
            }
            if (this.getDiffAssets() != null) {
                data.set("diffAssets", om.valueToTree(this.getDiffAssets()));
            }
            if (this.getHooks() != null) {
                data.set("hooks", om.valueToTree(this.getHooks()));
            }
            if (this.getRegions() != null) {
                data.set("regions", om.valueToTree(this.getRegions()));
            }
            if (this.getStackUpdateWorkflow() != null) {
                data.set("stackUpdateWorkflow", om.valueToTree(this.getStackUpdateWorkflow()));
            }
            if (this.getAnalyticsReporting() != null) {
                data.set("analyticsReporting", om.valueToTree(this.getAnalyticsReporting()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getStackName() != null) {
                data.set("stackName", om.valueToTree(this.getStackName()));
            }
            if (this.getSynthesizer() != null) {
                data.set("synthesizer", om.valueToTree(this.getSynthesizer()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminationProtection() != null) {
                data.set("terminationProtection", om.valueToTree(this.getTerminationProtection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.integ_tests.IntegTestCaseStackProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegTestCaseStackProps.Jsii$Proxy that = (IntegTestCaseStackProps.Jsii$Proxy) o;

            if (this.allowDestroy != null ? !this.allowDestroy.equals(that.allowDestroy) : that.allowDestroy != null) return false;
            if (this.cdkCommandOptions != null ? !this.cdkCommandOptions.equals(that.cdkCommandOptions) : that.cdkCommandOptions != null) return false;
            if (this.diffAssets != null ? !this.diffAssets.equals(that.diffAssets) : that.diffAssets != null) return false;
            if (this.hooks != null ? !this.hooks.equals(that.hooks) : that.hooks != null) return false;
            if (this.regions != null ? !this.regions.equals(that.regions) : that.regions != null) return false;
            if (this.stackUpdateWorkflow != null ? !this.stackUpdateWorkflow.equals(that.stackUpdateWorkflow) : that.stackUpdateWorkflow != null) return false;
            if (this.analyticsReporting != null ? !this.analyticsReporting.equals(that.analyticsReporting) : that.analyticsReporting != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.stackName != null ? !this.stackName.equals(that.stackName) : that.stackName != null) return false;
            if (this.synthesizer != null ? !this.synthesizer.equals(that.synthesizer) : that.synthesizer != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.terminationProtection != null ? this.terminationProtection.equals(that.terminationProtection) : that.terminationProtection == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowDestroy != null ? this.allowDestroy.hashCode() : 0;
            result = 31 * result + (this.cdkCommandOptions != null ? this.cdkCommandOptions.hashCode() : 0);
            result = 31 * result + (this.diffAssets != null ? this.diffAssets.hashCode() : 0);
            result = 31 * result + (this.hooks != null ? this.hooks.hashCode() : 0);
            result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
            result = 31 * result + (this.stackUpdateWorkflow != null ? this.stackUpdateWorkflow.hashCode() : 0);
            result = 31 * result + (this.analyticsReporting != null ? this.analyticsReporting.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.stackName != null ? this.stackName.hashCode() : 0);
            result = 31 * result + (this.synthesizer != null ? this.synthesizer.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminationProtection != null ? this.terminationProtection.hashCode() : 0);
            return result;
        }
    }
}
