package software.amazon.awscdk.integtests;

/**
 * (experimental) An AWS Lambda Invoke function API call.
 * <p>
 * Use this istead of the generic AwsApiCall in order to
 * invoke a lambda function. This will automatically create
 * the correct permissions to invoke the function
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.integtests.*;
 * LambdaInvokeFunction lambdaInvokeFunction = LambdaInvokeFunction.Builder.create(this, "MyLambdaInvokeFunction")
 *         .functionName("functionName")
 *         // the properties below are optional
 *         .invocationType(InvocationType.EVENT)
 *         .logType(LogType.NONE)
 *         .payload("payload")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.203Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.LambdaInvokeFunction")
public class LambdaInvokeFunction extends software.amazon.awscdk.integtests.AwsApiCall {

    protected LambdaInvokeFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaInvokeFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LambdaInvokeFunction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.LambdaInvokeFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.integtests.LambdaInvokeFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.integtests.LambdaInvokeFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.integtests.LambdaInvokeFunctionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.integtests.LambdaInvokeFunctionProps.Builder();
        }

        /**
         * (experimental) The name of the function to invoke.
         * <p>
         * @return {@code this}
         * @param functionName The name of the function to invoke. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * (experimental) The type of invocation to use.
         * <p>
         * Default: InvocationType.REQUEST_RESPONE
         * <p>
         * @return {@code this}
         * @param invocationType The type of invocation to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invocationType(final software.amazon.awscdk.integtests.InvocationType invocationType) {
            this.props.invocationType(invocationType);
            return this;
        }

        /**
         * (experimental) Whether to return the logs as part of the response.
         * <p>
         * Default: LogType.NONE
         * <p>
         * @return {@code this}
         * @param logType Whether to return the logs as part of the response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logType(final software.amazon.awscdk.integtests.LogType logType) {
            this.props.logType(logType);
            return this;
        }

        /**
         * (experimental) Payload to send as part of the invoke.
         * <p>
         * Default: - no payload
         * <p>
         * @return {@code this}
         * @param payload Payload to send as part of the invoke. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payload(final java.lang.String payload) {
            this.props.payload(payload);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.integtests.LambdaInvokeFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.integtests.LambdaInvokeFunction build() {
            return new software.amazon.awscdk.integtests.LambdaInvokeFunction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
