package software.amazon.awscdk.pipelines;

/**
 * (experimental) Defines which stages of a pipeline require the specified credentials.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISecret dockerHubSecret = Secret.fromSecretCompleteArn(this, "DHSecret", "arn:aws:...");
 * // Only the image asset publishing actions will be granted read access to the secret.
 * DockerCredential creds = DockerCredential.dockerHub(dockerHubSecret, ExternalDockerCredentialOptions.builder().usages(List.of(DockerCredentialUsage.ASSET_PUBLISHING)).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.344Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.pipelines.DockerCredentialUsage")
public enum DockerCredentialUsage {
    /**
     * (experimental) Synth/Build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SYNTH,
    /**
     * (experimental) Self-update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SELF_UPDATE,
    /**
     * (experimental) Asset publishing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ASSET_PUBLISHING,
}
