package software.amazon.awscdk.pipelines;

/**
 * (experimental) Deployment of a single `Stage`.
 * <p>
 * A <code>Stage</code> consists of one or more <code>Stacks</code>, which will be
 * deployed in dependency order.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.pipelines.*;
 * Stack stack;
 * Stage stage;
 * Step step;
 * StageDeployment stageDeployment = StageDeployment.fromStage(stage, StageDeploymentProps.builder()
 *         .post(List.of(step))
 *         .pre(List.of(step))
 *         .stackSteps(List.of(StackSteps.builder()
 *                 .stack(stack)
 *                 // the properties below are optional
 *                 .changeSet(List.of(step))
 *                 .post(List.of(step))
 *                 .pre(List.of(step))
 *                 .build()))
 *         .stageName("stageName")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:12.411Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.pipelines.StageDeployment")
public class StageDeployment extends software.amazon.jsii.JsiiObject {

    protected StageDeployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StageDeployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Create a new `StageDeployment` from a `Stage`.
     * <p>
     * Synthesizes the target stage, and deployes the stacks found inside
     * in dependency order.
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment fromStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.StageDeploymentProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.StageDeployment.class, "fromStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * (experimental) Create a new `StageDeployment` from a `Stage`.
     * <p>
     * Synthesizes the target stage, and deployes the stacks found inside
     * in dependency order.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment fromStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stage stage) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.StageDeployment.class, "fromStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * (experimental) Add an additional step to run after all of the stacks in this stage.
     * <p>
     * @param steps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPost(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Step... steps) {
        software.amazon.jsii.Kernel.call(this, "addPost", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * (experimental) Add an additional step to run before any of the stacks in this stage.
     * <p>
     * @param steps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addPre(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Step... steps) {
        software.amazon.jsii.Kernel.call(this, "addPre", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * (experimental) Additional steps that are run after all of the stacks in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "post", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * (experimental) Additional steps that are run before any of the stacks in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "pre", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * (experimental) The stacks deployed in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.StackDeployment> getStacks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackDeployment.class))));
    }

    /**
     * (experimental) Instructions for additional steps that are run at stack level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.StackSteps> getStackSteps() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stackSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackSteps.class))));
    }

    /**
     * (experimental) The display name of this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
