package software.amazon.awscdk.services.amplify;

/**
 * (experimental) An Amplify Console application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp = App.Builder.create(this, "MyApp")
 *         .sourceCodeProvider(GitHubSourceCodeProvider.Builder.create()
 *                 .owner("&lt;user&gt;")
 *                 .repository("&lt;repo&gt;")
 *                 .oauthToken(SecretValue.secretsManager("my-github-token"))
 *                 .build())
 *         .autoBranchCreation(AutoBranchCreation.builder() // Automatically connect branches that match a pattern set
 *                 .patterns(List.of("feature/*", "test/*")).build())
 *         .autoBranchDeletion(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:53.233Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.App")
public class App extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.amplify.IApp, software.amazon.awscdk.services.iam.IGrantable {

    protected App(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected App(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public App(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.AppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing application.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param appId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.IApp fromAppId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String appId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.amplify.App.class, "fromAppId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.IApp.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(appId, "appId is required") });
    }

    /**
     * (experimental) Adds an environment variable to the auto created branch.
     * <p>
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     * <p>
     * @param name This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.App addAutoBranchEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.Kernel.call(this, "addAutoBranchEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.App.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Adds a branch to this application.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.Branch addBranch(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.BranchOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addBranch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.Branch.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Adds a branch to this application.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.Branch addBranch(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addBranch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.Branch.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Adds a custom rewrite/redirect rule to this application.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.App addCustomRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.CustomRule rule) {
        return software.amazon.jsii.Kernel.call(this, "addCustomRule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.App.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) Adds a domain to this application.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.Domain addDomain(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.DomainOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.Domain.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Adds a domain to this application.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.Domain addDomain(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.Domain.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Adds an environment variable to this application.
     * <p>
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     * <p>
     * @param name This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.App addEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.Kernel.call(this, "addEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.App.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) The application id.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAppId() {
        return software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAppName() {
        return software.amazon.jsii.Kernel.get(this, "appName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The default domain of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefaultDomain() {
        return software.amazon.jsii.Kernel.get(this, "defaultDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.amplify.App}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplify.App> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.amplify.AppProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.amplify.AppProps.Builder();
        }

        /**
         * (experimental) The name for the application.
         * <p>
         * Default: - a CDK generated name
         * <p>
         * @return {@code this}
         * @param appName The name for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder appName(final java.lang.String appName) {
            this.props.appName(appName);
            return this;
        }

        /**
         * (experimental) The auto branch creation configuration.
         * <p>
         * Use this to automatically create
         * branches that match a certain pattern.
         * <p>
         * Default: - no auto branch creation
         * <p>
         * @return {@code this}
         * @param autoBranchCreation The auto branch creation configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoBranchCreation(final software.amazon.awscdk.services.amplify.AutoBranchCreation autoBranchCreation) {
            this.props.autoBranchCreation(autoBranchCreation);
            return this;
        }

        /**
         * (experimental) Automatically disconnect a branch in the Amplify Console when you delete a branch from your Git repository.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param autoBranchDeletion Automatically disconnect a branch in the Amplify Console when you delete a branch from your Git repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoBranchDeletion(final java.lang.Boolean autoBranchDeletion) {
            this.props.autoBranchDeletion(autoBranchDeletion);
            return this;
        }

        /**
         * (experimental) The Basic Auth configuration.
         * <p>
         * Use this to set password protection at an
         * app level to all your branches.
         * <p>
         * Default: - no password protection
         * <p>
         * @return {@code this}
         * @param basicAuth The Basic Auth configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder basicAuth(final software.amazon.awscdk.services.amplify.BasicAuth basicAuth) {
            this.props.basicAuth(basicAuth);
            return this;
        }

        /**
         * (experimental) BuildSpec for the application.
         * <p>
         * Alternatively, add a <code>amplify.yml</code>
         * file to the repository.
         * <p>
         * Default: - no build spec
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html">https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html</a>
         * @param buildSpec BuildSpec for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        /**
         * (experimental) The custom HTTP response headers for an Amplify app.
         * <p>
         * Default: - no custom response headers
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html">https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html</a>
         * @param customResponseHeaders The custom HTTP response headers for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customResponseHeaders(final java.util.List<? extends software.amazon.awscdk.services.amplify.CustomResponseHeader> customResponseHeaders) {
            this.props.customResponseHeaders(customResponseHeaders);
            return this;
        }

        /**
         * (experimental) Custom rewrite/redirect rules for the application.
         * <p>
         * Default: - no custom rewrite/redirect rules
         * <p>
         * @return {@code this}
         * @param customRules Custom rewrite/redirect rules for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customRules(final java.util.List<? extends software.amazon.awscdk.services.amplify.CustomRule> customRules) {
            this.props.customRules(customRules);
            return this;
        }

        /**
         * (experimental) A description for the application.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description A description for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Environment variables for the application.
         * <p>
         * All environment variables that you add are encrypted to prevent rogue
         * access so you can use them to store secret information.
         * <p>
         * Default: - no environment variables
         * <p>
         * @return {@code this}
         * @param environmentVariables Environment variables for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environmentVariables(final java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        /**
         * (experimental) The IAM service role to associate with the application.
         * <p>
         * The App
         * implements IGrantable.
         * <p>
         * Default: - a new role is created
         * <p>
         * @return {@code this}
         * @param role The IAM service role to associate with the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The source code provider for this application.
         * <p>
         * Default: - not connected to a source code provider
         * <p>
         * @return {@code this}
         * @param sourceCodeProvider The source code provider for this application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceCodeProvider(final software.amazon.awscdk.services.amplify.ISourceCodeProvider sourceCodeProvider) {
            this.props.sourceCodeProvider(sourceCodeProvider);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.amplify.App}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.amplify.App build() {
            return new software.amazon.awscdk.services.amplify.App(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
