package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Custom rewrite/redirect rule for an Amplify App.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp;
 * amplifyApp.addCustomRule(Map.of(
 *         "source", "/docs/specific-filename.html",
 *         "target", "/documents/different-filename.html",
 *         "status", RedirectStatus.TEMPORARY_REDIRECT));
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:53.285Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.CustomRule")
public class CustomRule extends software.amazon.jsii.JsiiObject {

    protected CustomRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        SINGLE_PAGE_APPLICATION_REDIRECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.amplify.CustomRule.class, "SINGLE_PAGE_APPLICATION_REDIRECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.CustomRule.class));
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CustomRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.CustomRuleOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Sets up a 200 rewrite for all paths to `index.html` except for path containing a file extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.amplify.CustomRule SINGLE_PAGE_APPLICATION_REDIRECT;

    /**
     * (experimental) The source pattern for a URL rewrite or redirect rule.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The target pattern for a URL rewrite or redirect rule.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getTarget() {
        return software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The condition for a URL rewrite or redirect rule, e.g. country code.
     * <p>
     * Default: - no condition
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getCondition() {
        return software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The status code for a URL rewrite or redirect rule.
     * <p>
     * Default: PERMANENT_REDIRECT
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.RedirectStatus getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.RedirectStatus.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.amplify.CustomRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplify.CustomRule> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.amplify.CustomRuleOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.amplify.CustomRuleOptions.Builder();
        }

        /**
         * (experimental) The source pattern for a URL rewrite or redirect rule.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
         * @param source The source pattern for a URL rewrite or redirect rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder source(final java.lang.String source) {
            this.options.source(source);
            return this;
        }

        /**
         * (experimental) The target pattern for a URL rewrite or redirect rule.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
         * @param target The target pattern for a URL rewrite or redirect rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder target(final java.lang.String target) {
            this.options.target(target);
            return this;
        }

        /**
         * (experimental) The condition for a URL rewrite or redirect rule, e.g. country code.
         * <p>
         * Default: - no condition
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
         * @param condition The condition for a URL rewrite or redirect rule, e.g. country code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder condition(final java.lang.String condition) {
            this.options.condition(condition);
            return this;
        }

        /**
         * (experimental) The status code for a URL rewrite or redirect rule.
         * <p>
         * Default: PERMANENT_REDIRECT
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
         * @param status The status code for a URL rewrite or redirect rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder status(final software.amazon.awscdk.services.amplify.RedirectStatus status) {
            this.options.status(status);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.amplify.CustomRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.amplify.CustomRule build() {
            return new software.amazon.awscdk.services.amplify.CustomRule(
                this.options.build()
            );
        }
    }
}
