package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Options for a custom rewrite/redirect rule for an Amplify App.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * CustomRuleOptions customRuleOptions = CustomRuleOptions.builder()
 *         .source("source")
 *         .target("target")
 *         // the properties below are optional
 *         .condition("condition")
 *         .status(RedirectStatus.REWRITE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:53.286Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.CustomRuleOptions")
@software.amazon.jsii.Jsii.Proxy(CustomRuleOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CustomRuleOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The source pattern for a URL rewrite or redirect rule.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * (experimental) The target pattern for a URL rewrite or redirect rule.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTarget();

    /**
     * (experimental) The condition for a URL rewrite or redirect rule, e.g. country code.
     * <p>
     * Default: - no condition
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCondition() {
        return null;
    }

    /**
     * (experimental) The status code for a URL rewrite or redirect rule.
     * <p>
     * Default: PERMANENT_REDIRECT
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html">https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.RedirectStatus getStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CustomRuleOptions> {
        java.lang.String source;
        java.lang.String target;
        java.lang.String condition;
        software.amazon.awscdk.services.amplify.RedirectStatus status;

        /**
         * Sets the value of {@link CustomRuleOptions#getSource}
         * @param source The source pattern for a URL rewrite or redirect rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleOptions#getTarget}
         * @param target The target pattern for a URL rewrite or redirect rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleOptions#getCondition}
         * @param condition The condition for a URL rewrite or redirect rule, e.g. country code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder condition(java.lang.String condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleOptions#getStatus}
         * @param status The status code for a URL rewrite or redirect rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder status(software.amazon.awscdk.services.amplify.RedirectStatus status) {
            this.status = status;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomRuleOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CustomRuleOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomRuleOptions {
        private final java.lang.String source;
        private final java.lang.String target;
        private final java.lang.String condition;
        private final software.amazon.awscdk.services.amplify.RedirectStatus status;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.RedirectStatus.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.condition = builder.condition;
            this.status = builder.status;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getCondition() {
            return this.condition;
        }

        @Override
        public final software.amazon.awscdk.services.amplify.RedirectStatus getStatus() {
            return this.status;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("source", om.valueToTree(this.getSource()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_amplify.CustomRuleOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomRuleOptions.Jsii$Proxy that = (CustomRuleOptions.Jsii$Proxy) o;

            if (!source.equals(that.source)) return false;
            if (!target.equals(that.target)) return false;
            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            return this.status != null ? this.status.equals(that.status) : that.status == null;
        }

        @Override
        public final int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }
    }
}
