package software.amazon.awscdk.services.amplify;

/**
 * (experimental) GitHub source code provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp = App.Builder.create(this, "MyApp")
 *         .sourceCodeProvider(GitHubSourceCodeProvider.Builder.create()
 *                 .owner("&lt;user&gt;")
 *                 .repository("&lt;repo&gt;")
 *                 .oauthToken(SecretValue.secretsManager("my-github-token"))
 *                 .build())
 *         .autoBranchCreation(AutoBranchCreation.builder() // Automatically connect branches that match a pattern set
 *                 .patterns(List.of("feature/*", "test/*")).build())
 *         .autoBranchDeletion(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:53.291Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.GitHubSourceCodeProvider")
public class GitHubSourceCodeProvider extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.amplify.ISourceCodeProvider {

    protected GitHubSourceCodeProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GitHubSourceCodeProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GitHubSourceCodeProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.GitHubSourceCodeProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Binds the source code provider to an app.
     * <p>
     * @param _app This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.SourceCodeProviderConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.App _app) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.SourceCodeProviderConfig.class), new Object[] { java.util.Objects.requireNonNull(_app, "_app is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.amplify.GitHubSourceCodeProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplify.GitHubSourceCodeProvider> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.amplify.GitHubSourceCodeProviderProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.amplify.GitHubSourceCodeProviderProps.Builder();
        }

        /**
         * (experimental) A personal access token with the `repo` scope.
         * <p>
         * @return {@code this}
         * @param oauthToken A personal access token with the `repo` scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder oauthToken(final software.amazon.awscdk.core.SecretValue oauthToken) {
            this.props.oauthToken(oauthToken);
            return this;
        }

        /**
         * (experimental) The user or organization owning the repository.
         * <p>
         * @return {@code this}
         * @param owner The user or organization owning the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owner(final java.lang.String owner) {
            this.props.owner(owner);
            return this;
        }

        /**
         * (experimental) The name of the repository.
         * <p>
         * @return {@code this}
         * @param repository The name of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(final java.lang.String repository) {
            this.props.repository(repository);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.amplify.GitHubSourceCodeProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.amplify.GitHubSourceCodeProvider build() {
            return new software.amazon.awscdk.services.amplify.GitHubSourceCodeProvider(
                this.props.build()
            );
        }
    }
}
