package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Configuration for the source code provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.amplify.*;
 * SecretValue secretValue;
 * SourceCodeProviderConfig sourceCodeProviderConfig = SourceCodeProviderConfig.builder()
 *         .repository("repository")
 *         // the properties below are optional
 *         .accessToken(secretValue)
 *         .oauthToken(secretValue)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:53.311Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.SourceCodeProviderConfig")
@software.amazon.jsii.Jsii.Proxy(SourceCodeProviderConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SourceCodeProviderConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The repository for the application. Must use the `HTTPS` protocol.
     * <p>
     * For example, <code>https://github.com/aws/aws-cdk</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getRepository();

    /**
     * (experimental) Personal Access token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key.
     * <p>
     * Token is not stored.
     * <p>
     * Either <code>accessToken</code> or <code>oauthToken</code> must be specified if <code>repository</code>
     * is sepcified.
     * <p>
     * Default: - do not use a token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SecretValue getAccessToken() {
        return null;
    }

    /**
     * (experimental) OAuth token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key.
     * <p>
     * OAuth token is not stored.
     * <p>
     * Either <code>accessToken</code> or <code>oauthToken</code> must be specified if <code>repository</code>
     * is specified.
     * <p>
     * Default: - do not use a token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SecretValue getOauthToken() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SourceCodeProviderConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceCodeProviderConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SourceCodeProviderConfig> {
        java.lang.String repository;
        software.amazon.awscdk.core.SecretValue accessToken;
        software.amazon.awscdk.core.SecretValue oauthToken;

        /**
         * Sets the value of {@link SourceCodeProviderConfig#getRepository}
         * @param repository The repository for the application. Must use the `HTTPS` protocol. This parameter is required.
         *                   For example, <code>https://github.com/aws/aws-cdk</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(java.lang.String repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link SourceCodeProviderConfig#getAccessToken}
         * @param accessToken Personal Access token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key.
         *                    Token is not stored.
         *                    <p>
         *                    Either <code>accessToken</code> or <code>oauthToken</code> must be specified if <code>repository</code>
         *                    is sepcified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessToken(software.amazon.awscdk.core.SecretValue accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        /**
         * Sets the value of {@link SourceCodeProviderConfig#getOauthToken}
         * @param oauthToken OAuth token for 3rd party source control system for an Amplify App, used to create webhook and read-only deploy key.
         *                   OAuth token is not stored.
         *                   <p>
         *                   Either <code>accessToken</code> or <code>oauthToken</code> must be specified if <code>repository</code>
         *                   is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder oauthToken(software.amazon.awscdk.core.SecretValue oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceCodeProviderConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SourceCodeProviderConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceCodeProviderConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceCodeProviderConfig {
        private final java.lang.String repository;
        private final software.amazon.awscdk.core.SecretValue accessToken;
        private final software.amazon.awscdk.core.SecretValue oauthToken;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
            this.oauthToken = software.amazon.jsii.Kernel.get(this, "oauthToken", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repository = java.util.Objects.requireNonNull(builder.repository, "repository is required");
            this.accessToken = builder.accessToken;
            this.oauthToken = builder.oauthToken;
        }

        @Override
        public final java.lang.String getRepository() {
            return this.repository;
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getOauthToken() {
            return this.oauthToken;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repository", om.valueToTree(this.getRepository()));
            if (this.getAccessToken() != null) {
                data.set("accessToken", om.valueToTree(this.getAccessToken()));
            }
            if (this.getOauthToken() != null) {
                data.set("oauthToken", om.valueToTree(this.getOauthToken()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_amplify.SourceCodeProviderConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceCodeProviderConfig.Jsii$Proxy that = (SourceCodeProviderConfig.Jsii$Proxy) o;

            if (!repository.equals(that.repository)) return false;
            if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
            return this.oauthToken != null ? this.oauthToken.equals(that.oauthToken) : that.oauthToken == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repository.hashCode();
            result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
            result = 31 * result + (this.oauthToken != null ? this.oauthToken.hashCode() : 0);
            return result;
        }
    }
}
