package software.amazon.awscdk.services.amplifyuibuilder;

/**
 * Properties for defining a `CfnForm`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplifyuibuilder.*;
 * CfnFormProps cfnFormProps = CfnFormProps.builder()
 *         .dataType(FormDataTypeConfigProperty.builder()
 *                 .dataSourceType("dataSourceType")
 *                 .dataTypeName("dataTypeName")
 *                 .build())
 *         .fields(Map.of(
 *                 "fieldsKey", FieldConfigProperty.builder()
 *                         .excluded(false)
 *                         .inputType(FieldInputConfigProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .defaultChecked(false)
 *                                 .defaultCountryCode("defaultCountryCode")
 *                                 .defaultValue("defaultValue")
 *                                 .descriptiveText("descriptiveText")
 *                                 .maxValue(123)
 *                                 .minValue(123)
 *                                 .name("name")
 *                                 .placeholder("placeholder")
 *                                 .readOnly(false)
 *                                 .required(false)
 *                                 .step(123)
 *                                 .value("value")
 *                                 .valueMappings(ValueMappingsProperty.builder()
 *                                         .values(List.of(ValueMappingProperty.builder()
 *                                                 .value(FormInputValuePropertyProperty.builder()
 *                                                         .value("value")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .displayValue(FormInputValuePropertyProperty.builder()
 *                                                         .value("value")
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .label("label")
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .validations(List.of(FieldValidationConfigurationProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .numValues(List.of(123))
 *                                 .strValues(List.of("strValues"))
 *                                 .validationMessage("validationMessage")
 *                                 .build()))
 *                         .build()))
 *         .formActionType("formActionType")
 *         .name("name")
 *         .schemaVersion("schemaVersion")
 *         .sectionalElements(Map.of(
 *                 "sectionalElementsKey", SectionalElementProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .level(123)
 *                         .orientation("orientation")
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .text("text")
 *                         .build()))
 *         .style(FormStyleProperty.builder()
 *                 .horizontalGap(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .outerPadding(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .verticalGap(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .appId("appId")
 *         .cta(FormCTAProperty.builder()
 *                 .cancel(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .clear(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .position("position")
 *                 .submit(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .environmentName("environmentName")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:53.432Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnFormProps")
@software.amazon.jsii.Jsii.Proxy(CfnFormProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFormProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of data source to use to create the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataType();

    /**
     * Stores the information about the form's fields.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFields();

    /**
     * The operation to perform on the specified form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFormActionType();

    /**
     * The name of the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The schema version of the form when it was imported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchemaVersion();

    /**
     * Stores the visual helper elements for the form that are not associated with any data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSectionalElements();

    /**
     * Stores the configuration for the form's style.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getStyle();

    /**
     * The unique ID of the Amplify app associated with the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppId() {
        return null;
    }

    /**
     * Stores the call to action configuration for the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCta() {
        return null;
    }

    /**
     * The name of the backend environment that is a part of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentName() {
        return null;
    }

    /**
     * One or more key-value pairs to use when tagging the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFormProps> {
        java.lang.Object dataType;
        java.lang.Object fields;
        java.lang.String formActionType;
        java.lang.String name;
        java.lang.String schemaVersion;
        java.lang.Object sectionalElements;
        java.lang.Object style;
        java.lang.String appId;
        java.lang.Object cta;
        java.lang.String environmentName;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnFormProps#getDataType}
         * @param dataType The type of data source to use to create the form. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormDataTypeConfigProperty dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getDataType}
         * @param dataType The type of data source to use to create the form. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(software.amazon.awscdk.core.IResolvable dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getFields}
         * @param fields Stores the information about the form's fields. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(software.amazon.awscdk.core.IResolvable fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getFields}
         * @param fields Stores the information about the form's fields. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(java.util.Map<java.lang.String, ? extends java.lang.Object> fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getFormActionType}
         * @param formActionType The operation to perform on the specified form. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder formActionType(java.lang.String formActionType) {
            this.formActionType = formActionType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getName}
         * @param name The name of the form. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getSchemaVersion}
         * @param schemaVersion The schema version of the form when it was imported. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaVersion(java.lang.String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getSectionalElements}
         * @param sectionalElements Stores the visual helper elements for the form that are not associated with any data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sectionalElements(software.amazon.awscdk.core.IResolvable sectionalElements) {
            this.sectionalElements = sectionalElements;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getSectionalElements}
         * @param sectionalElements Stores the visual helper elements for the form that are not associated with any data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sectionalElements(java.util.Map<java.lang.String, ? extends java.lang.Object> sectionalElements) {
            this.sectionalElements = sectionalElements;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getStyle}
         * @param style Stores the configuration for the form's style. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder style(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormStyleProperty style) {
            this.style = style;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getStyle}
         * @param style Stores the configuration for the form's style. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder style(software.amazon.awscdk.core.IResolvable style) {
            this.style = style;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getAppId}
         * @param appId The unique ID of the Amplify app associated with the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getCta}
         * @param cta Stores the call to action configuration for the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cta(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormCTAProperty cta) {
            this.cta = cta;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getCta}
         * @param cta Stores the call to action configuration for the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cta(software.amazon.awscdk.core.IResolvable cta) {
            this.cta = cta;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getEnvironmentName}
         * @param environmentName The name of the backend environment that is a part of the Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(java.lang.String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getTags}
         * @param tags One or more key-value pairs to use when tagging the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFormProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFormProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFormProps {
        private final java.lang.Object dataType;
        private final java.lang.Object fields;
        private final java.lang.String formActionType;
        private final java.lang.String name;
        private final java.lang.String schemaVersion;
        private final java.lang.Object sectionalElements;
        private final java.lang.Object style;
        private final java.lang.String appId;
        private final java.lang.Object cta;
        private final java.lang.String environmentName;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fields = software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.formActionType = software.amazon.jsii.Kernel.get(this, "formActionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schemaVersion = software.amazon.jsii.Kernel.get(this, "schemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sectionalElements = software.amazon.jsii.Kernel.get(this, "sectionalElements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.style = software.amazon.jsii.Kernel.get(this, "style", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.appId = software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cta = software.amazon.jsii.Kernel.get(this, "cta", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.environmentName = software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataType = java.util.Objects.requireNonNull(builder.dataType, "dataType is required");
            this.fields = java.util.Objects.requireNonNull(builder.fields, "fields is required");
            this.formActionType = java.util.Objects.requireNonNull(builder.formActionType, "formActionType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.schemaVersion = java.util.Objects.requireNonNull(builder.schemaVersion, "schemaVersion is required");
            this.sectionalElements = java.util.Objects.requireNonNull(builder.sectionalElements, "sectionalElements is required");
            this.style = java.util.Objects.requireNonNull(builder.style, "style is required");
            this.appId = builder.appId;
            this.cta = builder.cta;
            this.environmentName = builder.environmentName;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getDataType() {
            return this.dataType;
        }

        @Override
        public final java.lang.Object getFields() {
            return this.fields;
        }

        @Override
        public final java.lang.String getFormActionType() {
            return this.formActionType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final java.lang.Object getSectionalElements() {
            return this.sectionalElements;
        }

        @Override
        public final java.lang.Object getStyle() {
            return this.style;
        }

        @Override
        public final java.lang.String getAppId() {
            return this.appId;
        }

        @Override
        public final java.lang.Object getCta() {
            return this.cta;
        }

        @Override
        public final java.lang.String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataType", om.valueToTree(this.getDataType()));
            data.set("fields", om.valueToTree(this.getFields()));
            data.set("formActionType", om.valueToTree(this.getFormActionType()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("schemaVersion", om.valueToTree(this.getSchemaVersion()));
            data.set("sectionalElements", om.valueToTree(this.getSectionalElements()));
            data.set("style", om.valueToTree(this.getStyle()));
            if (this.getAppId() != null) {
                data.set("appId", om.valueToTree(this.getAppId()));
            }
            if (this.getCta() != null) {
                data.set("cta", om.valueToTree(this.getCta()));
            }
            if (this.getEnvironmentName() != null) {
                data.set("environmentName", om.valueToTree(this.getEnvironmentName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnFormProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFormProps.Jsii$Proxy that = (CfnFormProps.Jsii$Proxy) o;

            if (!dataType.equals(that.dataType)) return false;
            if (!fields.equals(that.fields)) return false;
            if (!formActionType.equals(that.formActionType)) return false;
            if (!name.equals(that.name)) return false;
            if (!schemaVersion.equals(that.schemaVersion)) return false;
            if (!sectionalElements.equals(that.sectionalElements)) return false;
            if (!style.equals(that.style)) return false;
            if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) return false;
            if (this.cta != null ? !this.cta.equals(that.cta) : that.cta != null) return false;
            if (this.environmentName != null ? !this.environmentName.equals(that.environmentName) : that.environmentName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataType.hashCode();
            result = 31 * result + (this.fields.hashCode());
            result = 31 * result + (this.formActionType.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.schemaVersion.hashCode());
            result = 31 * result + (this.sectionalElements.hashCode());
            result = 31 * result + (this.style.hashCode());
            result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
            result = 31 * result + (this.cta != null ? this.cta.hashCode() : 0);
            result = 31 * result + (this.environmentName != null ? this.environmentName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
