package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Vpc vpc = new Vpc(this, "VPC");
 * NetworkLoadBalancer nlb = NetworkLoadBalancer.Builder.create(this, "NLB")
 *         .vpc(vpc)
 *         .build();
 * VpcLink link = VpcLink.Builder.create(this, "link")
 *         .targets(List.of(nlb))
 *         .build();
 * Integration integration = Integration.Builder.create()
 *         .type(IntegrationType.HTTP_PROXY)
 *         .options(IntegrationOptions.builder()
 *                 .connectionType(ConnectionType.VPC_LINK)
 *                 .vpcLink(link)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:53.732Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigateway.ConnectionType")
public enum ConnectionType {
    /**
     * (experimental) For connections through the public routable internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INTERNET,
    /**
     * (experimental) For private connections between API Gateway and a network load balancer in a VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VPC_LINK,
}
