package software.amazon.awscdk.services.apigatewayv2;

/**
 * (experimental) The integration for an API route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpApi httpApi;
 * IntegrationCredentials integrationCredentials;
 * ParameterMapping parameterMapping;
 * PayloadFormatVersion payloadFormatVersion;
 * HttpIntegration httpIntegration = HttpIntegration.Builder.create(this, "MyHttpIntegration")
 *         .httpApi(httpApi)
 *         .integrationType(HttpIntegrationType.HTTP_PROXY)
 *         // the properties below are optional
 *         .connectionId("connectionId")
 *         .connectionType(HttpConnectionType.VPC_LINK)
 *         .credentials(integrationCredentials)
 *         .integrationSubtype(HttpIntegrationSubtype.EVENTBRIDGE_PUT_EVENTS)
 *         .integrationUri("integrationUri")
 *         .method(HttpMethod.ANY)
 *         .parameterMapping(parameterMapping)
 *         .payloadFormatVersion(payloadFormatVersion)
 *         .secureServerName("secureServerName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.082Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigatewayv2.HttpIntegration")
public class HttpIntegration extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigatewayv2.IHttpIntegration {

    protected HttpIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpIntegration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The HTTP API associated with this integration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi() {
        return software.amazon.jsii.Kernel.get(this, "httpApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpApi.class));
    }

    /**
     * (experimental) Id of the integration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getIntegrationId() {
        return software.amazon.jsii.Kernel.get(this, "integrationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.HttpIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.HttpIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.HttpIntegrationProps.Builder();
        }

        /**
         * (experimental) The HTTP API to which this integration should be bound.
         * <p>
         * @return {@code this}
         * @param httpApi The HTTP API to which this integration should be bound. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpApi(final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
            this.props.httpApi(httpApi);
            return this;
        }

        /**
         * (experimental) Integration type.
         * <p>
         * @return {@code this}
         * @param integrationType Integration type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationType(final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType integrationType) {
            this.props.integrationType(integrationType);
            return this;
        }

        /**
         * (experimental) The ID of the VPC link for a private integration.
         * <p>
         * Supported only for HTTP APIs.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param connectionId The ID of the VPC link for a private integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionId(final java.lang.String connectionId) {
            this.props.connectionId(connectionId);
            return this;
        }

        /**
         * (experimental) The type of the network connection to the integration endpoint.
         * <p>
         * Default: HttpConnectionType.INTERNET
         * <p>
         * @return {@code this}
         * @param connectionType The type of the network connection to the integration endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionType(final software.amazon.awscdk.services.apigatewayv2.HttpConnectionType connectionType) {
            this.props.connectionType(connectionType);
            return this;
        }

        /**
         * (experimental) The credentials with which to invoke the integration.
         * <p>
         * Default: - no credentials, use resource-based permissions on supported AWS services
         * <p>
         * @return {@code this}
         * @param credentials The credentials with which to invoke the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder credentials(final software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * (experimental) Integration subtype.
         * <p>
         * Used for AWS Service integrations, specifies the target of the integration.
         * <p>
         * Default: - none, required if no `integrationUri` is defined.
         * <p>
         * @return {@code this}
         * @param integrationSubtype Integration subtype. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationSubtype(final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype integrationSubtype) {
            this.props.integrationSubtype(integrationSubtype);
            return this;
        }

        /**
         * (experimental) Integration URI.
         * <p>
         * This will be the function ARN in the case of <code>HttpIntegrationType.AWS_PROXY</code>,
         * or HTTP URL in the case of <code>HttpIntegrationType.HTTP_PROXY</code>.
         * <p>
         * Default: - none, required if no `integrationSubtype` is defined.
         * <p>
         * @return {@code this}
         * @param integrationUri Integration URI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationUri(final java.lang.String integrationUri) {
            this.props.integrationUri(integrationUri);
            return this;
        }

        /**
         * (experimental) The HTTP method to use when calling the underlying HTTP proxy.
         * <p>
         * Default: - none. required if the integration type is `HttpIntegrationType.HTTP_PROXY`.
         * <p>
         * @return {@code this}
         * @param method The HTTP method to use when calling the underlying HTTP proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder method(final software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
            this.props.method(method);
            return this;
        }

        /**
         * (experimental) Specifies how to transform HTTP requests before sending them to the backend.
         * <p>
         * Default: undefined requests are sent to the backend unmodified
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterMapping(final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.props.parameterMapping(parameterMapping);
            return this;
        }

        /**
         * (experimental) The version of the payload format.
         * <p>
         * Default: - defaults to latest in the case of HttpIntegrationType.AWS_PROXY`, irrelevant otherwise.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html</a>
         * @param payloadFormatVersion The version of the payload format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payloadFormatVersion(final software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion) {
            this.props.payloadFormatVersion(payloadFormatVersion);
            return this;
        }

        /**
         * (experimental) Specifies the TLS configuration for a private integration.
         * <p>
         * Default: undefined private integration traffic will use HTTP protocol
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html</a>
         * @param secureServerName Specifies the TLS configuration for a private integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secureServerName(final java.lang.String secureServerName) {
            this.props.secureServerName(secureServerName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.HttpIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.HttpIntegration build() {
            return new software.amazon.awscdk.services.apigatewayv2.HttpIntegration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
