package software.amazon.awscdk.services.apigatewayv2;

/**
 * (experimental) The options to create a new Stage for an HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HttpApi api;
 * DomainName dn;
 * api.addStage("beta", HttpStageOptions.builder()
 *         .stageName("beta")
 *         .autoDeploy(true)
 *         // https://${dn.domainName}/bar goes to the beta stage
 *         .domainMapping(DomainMappingOptions.builder()
 *                 .domainName(dn)
 *                 .mappingKey("bar")
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.100Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigatewayv2.HttpStageOptions")
@software.amazon.jsii.Jsii.Proxy(HttpStageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface HttpStageOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.StageOptions {

    /**
     * (experimental) The name of the stage.
     * <p>
     * See <code>StageName</code> class for more details.
     * <p>
     * Default: '$default' the default stage of the API. This stage will have the URL at the root of the API endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpStageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpStageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<HttpStageOptions> {
        java.lang.String stageName;
        java.lang.Boolean autoDeploy;
        software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping;
        software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;

        /**
         * Sets the value of {@link HttpStageOptions#getStageName}
         * @param stageName The name of the stage.
         *                  See <code>StageName</code> class for more details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageOptions#getAutoDeploy}
         * @param autoDeploy Whether updates to an API automatically trigger a new deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoDeploy(java.lang.Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageOptions#getDomainMapping}
         * @param domainMapping The options for custom domain and api mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainMapping(software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping) {
            this.domainMapping = domainMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpStageOptions#getThrottle}
         * @param throttle Throttle settings for the routes of this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder throttle(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpStageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public HttpStageOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpStageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpStageOptions {
        private final java.lang.String stageName;
        private final java.lang.Boolean autoDeploy;
        private final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping;
        private final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoDeploy = software.amazon.jsii.Kernel.get(this, "autoDeploy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.domainMapping = software.amazon.jsii.Kernel.get(this, "domainMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions.class));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stageName = builder.stageName;
            this.autoDeploy = builder.autoDeploy;
            this.domainMapping = builder.domainMapping;
            this.throttle = builder.throttle;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.lang.Boolean getAutoDeploy() {
            return this.autoDeploy;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions getDomainMapping() {
            return this.domainMapping;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }
            if (this.getAutoDeploy() != null) {
                data.set("autoDeploy", om.valueToTree(this.getAutoDeploy()));
            }
            if (this.getDomainMapping() != null) {
                data.set("domainMapping", om.valueToTree(this.getDomainMapping()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apigatewayv2.HttpStageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpStageOptions.Jsii$Proxy that = (HttpStageOptions.Jsii$Proxy) o;

            if (this.stageName != null ? !this.stageName.equals(that.stageName) : that.stageName != null) return false;
            if (this.autoDeploy != null ? !this.autoDeploy.equals(that.autoDeploy) : that.autoDeploy != null) return false;
            if (this.domainMapping != null ? !this.domainMapping.equals(that.domainMapping) : that.domainMapping != null) return false;
            return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stageName != null ? this.stageName.hashCode() : 0;
            result = 31 * result + (this.autoDeploy != null ? this.autoDeploy.hashCode() : 0);
            result = 31 * result + (this.domainMapping != null ? this.domainMapping.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            return result;
        }
    }
}
